/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.log;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.isc.kem.common.constants.ConfigConstant;
import kd.isc.kem.common.util.ConfigHelper;
import kd.isc.kem.common.util.DateUtil;
import kd.isc.kem.core.queue.KemQueueItemStatus;

public class ClearLogTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ClearLogTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.clearFinishQueueLog();
    }

    private void cleanFullLog() {
        String daysStr = ConfigHelper.getSystemParam((String)"kem_log_maxdays", (String)String.valueOf(30));
        int days = Integer.parseInt(daysStr);
        try {
            String strLog = ResManager.loadKDString((String)"kem-kem_ClearLog-\u65e5\u5fd7\u4fdd\u7559\u65f6\u957f %s \u5929\u3002", (String)"KemClearLog_6", (String)"isc-kem-core", (Object[])new Object[]{days});
            log.info(strLog);
            LogORM logORM = LogORM.create();
            Date timeBeforeNDay = DateUtil.addDays((Date)new Date(), (int)(-days));
            QFilter[] qFilters = new QFilter[]{new QFilter("opdate", "<", (Object)timeBeforeNDay)};
            int count = logORM.delete("kem_log", qFilters);
            String str = ResManager.loadKDString((String)"kem-kem_ClearLog-(1/3)\u65e5\u5fd7\u6e05\u7406\u4efb\u52a1\u6267\u884c\u6210\u529f,\u6e05\u7406\u4e86 %s \u6761\u8bb0\u5f55\u3002", (String)"KemClearLog_0", (String)"isc-kem-core", (Object[])new Object[]{count});
            log.info(str);
            count = logORM.delete("kem_nodelog", qFilters);
            str = ResManager.loadKDString((String)"kem-kem_ClearLog-(2/3)NodeLog\u65e5\u5fd7\u6e05\u7406\u4efb\u52a1\u6267\u884c\u6210\u529f,\u6e05\u7406\u4e86 %s \u6761\u8bb0\u5f55\u3002", (String)"KemClearLog_1", (String)"isc-kem-core", (Object[])new Object[]{count});
            log.info(str);
        }
        catch (Exception e) {
            String str = ResManager.loadKDString((String)"kem-kem_ClearLog\u65e5\u5fd7\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25:%s", (String)"KemClearLog_2", (String)"isc-kem-core", (Object[])new Object[]{e.getMessage()});
            log.error(str, (Throwable)e);
            throw e;
        }
    }

    public void clearFinishQueueLog() {
        try {
            String strLog = ResManager.loadKDString((String)"kem-kem_ClearLog-\u6d88\u606f\u961f\u5217\u4fdd\u7559\u65f6\u957f - \u72b6\u6001\u6210\u529f\uff08F)\uff1a%1s \u5929, \u5168\u90e8\u6d88\u606f\uff08ALL)\uff1a %2s \u5929", (String)"KemClearLog_5", (String)"isc-kem-core", (Object[])new Object[]{3L, 7L});
            log.info(strLog);
            Date checkDate = new Date(System.currentTimeMillis() - 259200000L);
            String sql = "DELETE FROM t_kem_queue WHERE fscheduletime<=? and fstatus=?";
            DB.execute((DBRoute)ConfigConstant.DB_ROUTE, (String)sql, (Object[])new Object[]{checkDate, KemQueueItemStatus.F1});
            Date checkDate2 = new Date(System.currentTimeMillis() - 604800000L);
            String sql2 = "DELETE FROM t_kem_queue WHERE fscheduletime<=? ";
            DB.execute((DBRoute)ConfigConstant.DB_ROUTE, (String)sql2, (Object[])new Object[]{checkDate2});
            String str = ResManager.loadKDString((String)"kem-kem_ClearLog-(3/3)QueueLog\u961f\u5217\u6e05\u7406\u4efb\u52a1\u6267\u884c\u6210\u529f\u3002", (String)"KemClearLog_3", (String)"isc-kem-core", (Object[])new Object[0]);
            log.info(str);
        }
        catch (Exception e) {
            String str = ResManager.loadKDString((String)"kem-kem_ClearLog-Kem_QueueLog\u961f\u5217\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25:%s\u3002", (String)"KemClearLog_4", (String)"isc-kem-core", (Object[])new Object[]{e.getMessage()});
            log.error(str, (Throwable)e);
            throw e;
        }
    }
}

