/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.threads.ThreadPools;
import kd.isc.kem.core.queue.KemQueueConsumer;
import kd.isc.kem.core.queue.KemQueueType;
import kd.isc.kem.core.queue.consumer.ActionConsumer;
import kd.isc.kem.core.queue.consumer.CronConsumer;
import kd.isc.kem.core.queue.consumer.EmptyConsumer;
import kd.isc.kem.core.queue.consumer.EventConsumer;
import kd.isc.kem.core.queue.impl.db.KemDbQueueMgr;

public class KemQueueMgr {
    private static final KemQueueMgr instance = new KemQueueMgr();
    private static final Map<String, KemQueueConsumer> typeConsumers = new HashMap<String, KemQueueConsumer>();
    private static final Log log = LogFactory.getLog(KemQueueMgr.class);

    private KemQueueMgr() {
    }

    public static KemQueueMgr get() {
        return instance;
    }

    public void startService() {
        ThreadPools.executeOnce((String)"kem queue service", () -> {
            AtomicInteger count = new AtomicInteger(0);
            List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
            accounts.forEach(account -> {
                RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
                try (AutoCloseable ignored = rc.setupThreadRequestContext();){
                    if (KemDbQueueMgr.getKemEnabled()) {
                        KemDbQueueMgr.getLoader();
                        count.getAndIncrement();
                    }
                }
                catch (Exception e) {
                    ExceptionLogger.log((String)"start kem queue service error", (Throwable)e);
                }
            });
            log.info("Kem-\u4e8b\u4ef6\u7f51\u683c\u670d\u52a1\u542f\u52a8\u4e2d\uff0cKemQueueMgr.startService()\u5df2\u6267\u884c\uff0c\u672c\u96c6\u7fa4\u5df2\u542f\u52a8KEM\u670d\u52a1\u8d26\u5957\u6570\u91cf\uff1a" + count.get());
        });
    }

    public KemQueueConsumer findConsumeByQueue(String queue, String type) {
        KemQueueConsumer consumer = typeConsumers.get(type);
        if (consumer == null) {
            consumer = typeConsumers.get(KemQueueType.None.toString());
        }
        return consumer;
    }

    private static void initQueueConsumer() {
        typeConsumers.put(KemQueueType.Event.toString(), new EventConsumer());
        typeConsumers.put(KemQueueType.Action.toString(), new ActionConsumer());
        typeConsumers.put(KemQueueType.Cron.toString(), new CronConsumer());
        typeConsumers.put(KemQueueType.None.toString(), new EmptyConsumer());
    }

    static {
        KemQueueMgr.initQueueConsumer();
    }
}

