/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue;

import java.util.Arrays;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.core.exception.KemCoreError;

public enum KemQueuePriority {
    High(1, "High"),
    Normal(2, "Normal"),
    Low(3, "Low");

    private final int mCode;
    private final String title;

    private KemQueuePriority(int value, String title) {
        this.mCode = value;
        this.title = title;
    }

    public int getCode() {
        return this.mCode;
    }

    public String getTitle() {
        return this.title;
    }

    public static KemQueuePriority getPriority(int code) {
        return Arrays.stream(KemQueuePriority.values()).filter(it -> it.getCode() == code).findFirst().orElseThrow(() -> new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"Priority code \u201c" + code + "\u201d is not supported"}));
    }
}

