/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.isc.kem.common.util.ConfigHelper;
import kd.isc.kem.common.util.DataUtil;

public class KemQueueThreadMgr {
    public static final KemQueueThreadMgr WORKER = new KemQueueThreadMgr("KEM_QUEUE_WORKER", KemQueueThreadMgr.getMaxWorkThread());
    public static final KemQueueThreadMgr MAIN = new KemQueueThreadMgr("KEM_QUEUE_SCHEDULE", KemQueueThreadMgr.getMaxMainThread());
    private static final Log log = LogFactory.getLog(KemQueueThreadMgr.class);
    private final int maxThreadCount;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final String name;
    private final SortedList<Item> queue = new SortedList(new ArrayList());
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    private KemQueueThreadMgr(String name, int maxThreadCount) {
        this.name = name;
        this.maxThreadCount = maxThreadCount;
    }

    public String getName() {
        return this.name;
    }

    public long submit(Runnable runnable, int seconds) {
        long delay = Math.max((long)seconds * 1000L, 50L);
        long scheduleTime = System.currentTimeMillis() + delay;
        return this.submit(runnable, RequestContext.get(), scheduleTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long submit(Runnable runnable, RequestContext ctx, long scheduleTime) {
        if (ctx == null) {
            throw new NullPointerException("ctx is null.");
        }
        if (runnable == null) {
            throw new NullPointerException("runnable is null.");
        }
        Item item = new Item(runnable, scheduleTime, ctx);
        this.queue.add(item);
        if (this.threadCount.get() > 0 && this.queue.top() == item) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            catch (Exception exception) {
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.threadCount.get() < this.maxThreadCount) {
            this.startThread();
        }
        return scheduleTime;
    }

    public boolean runAhead(Runnable runnable, int seconds) {
        Item[] items;
        long delay = Math.max((long)seconds * 1000L, 20L);
        long scheduleTime = System.currentTimeMillis() + delay;
        for (Item i : items = (Item[])this.queue.toArray(new Item[0])) {
            if (i.runnable != runnable || i.scheduleTime <= scheduleTime || !this.queue.remove(i)) continue;
            this.submit(runnable, RequestContext.get(), scheduleTime);
            return true;
        }
        return false;
    }

    private boolean hasTask() {
        boolean hasTask;
        boolean bl = hasTask = !this.queue.isEmpty();
        if (!hasTask) {
            long now = System.currentTimeMillis();
            this.pause(now, now + 60000L);
            hasTask = !this.queue.isEmpty();
        }
        return hasTask;
    }

    private Item pop() {
        long now = System.currentTimeMillis();
        Item item = this.queue.top();
        if (item == null) {
            return null;
        }
        long scheduleTime = item.scheduleTime;
        if (now >= scheduleTime) {
            return this.queue.cmpAndPop(item);
        }
        this.pause(now, scheduleTime);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pause(long now, long scheduleTime) {
        long delay = Math.max(scheduleTime - now, 0L);
        this.lock.lock();
        try {
            boolean retVal = this.condition.await(delay, TimeUnit.MILLISECONDS);
            if (!retVal) {
                return;
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startThread() {
        ThreadPools.executeOnce((String)this.getName(), () -> {
            block10: {
                if (this.threadCount.get() >= this.maxThreadCount) {
                    return;
                }
                this.threadCount.incrementAndGet();
                block7: while (true) {
                    try {
                        while (this.hasTask()) {
                            Item i = this.pop();
                            if (i == null) continue;
                            Runnable runnable = i.runnable;
                            try {
                                RequestContextCreator.restoreForMQ((RequestContext)i.ctx);
                                runnable.run();
                                continue block7;
                            }
                            catch (Throwable e) {
                                log.warn(e);
                            }
                        }
                        break block10;
                    }
                    catch (Throwable e) {
                        log.warn(e);
                        break block10;
                    }
                }
                finally {
                    this.threadCount.decrementAndGet();
                }
            }
        });
    }

    private static int getMaxMainThread() {
        String str = ConfigHelper.getSysProperty((String)"kem.Thread.MaxMainThread", (String)String.valueOf(2));
        return DataUtil.i((Object)str, (int)2);
    }

    private static int getMaxWorkThread() {
        String str = ConfigHelper.getSysProperty((String)"kem.Thread.MaxWorkThread", (String)String.valueOf(8));
        return DataUtil.i((Object)str, (int)8);
    }

    private static class Item
    implements Comparable<Item> {
        private final Runnable runnable;
        private final long scheduleTime;
        private final RequestContext ctx;

        private Item(Runnable runnable, long scheduleTime, RequestContext ctx) {
            this.runnable = runnable;
            this.scheduleTime = scheduleTime;
            this.ctx = ctx;
        }

        @Override
        public int compareTo(Item o) {
            return Long.compare(this.scheduleTime, o.scheduleTime);
        }
    }

    private static class SortedList<T extends Comparable<T>> {
        private final List<T> list;

        public SortedList(List<T> list) {
            this.list = list;
        }

        public synchronized void add(T o) {
            int i;
            int len = this.list.size();
            for (i = 0; i < len && o.compareTo(this.list.get(i)) >= 0; ++i) {
            }
            this.list.add(i, o);
        }

        public synchronized T[] toArray(T[] a) {
            return (Comparable[])this.list.toArray(a);
        }

        public synchronized boolean remove(T o) {
            return this.list.remove(o);
        }

        public synchronized T pop() {
            return (T)(this.list.isEmpty() ? null : (Comparable)this.list.remove(0));
        }

        public synchronized T cmpAndPop(T o) {
            if (this.list.isEmpty()) {
                return null;
            }
            Comparable i = (Comparable)this.list.get(0);
            if (i == o) {
                return (T)((Comparable)this.list.remove(0));
            }
            return null;
        }

        public synchronized T top() {
            return (T)(this.list.isEmpty() ? null : (Comparable)this.list.get(0));
        }

        public synchronized boolean isEmpty() {
            return this.list.isEmpty();
        }
    }
}

