/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue;

import java.util.Arrays;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.core.exception.KemCoreError;

public enum KemQueueType {
    None(0, "Other"),
    Event(1, "EventMsg"),
    Cron(2, "PoolingMsg"),
    Action(3, "ActionMsg");

    private final int mCode;
    private final String title;

    private KemQueueType(int value, String title) {
        this.mCode = value;
        this.title = title;
    }

    public int getCode() {
        return this.mCode;
    }

    public String getTitle() {
        return this.title;
    }

    public static KemQueueType getQueueType(int code) {
        return Arrays.stream(KemQueueType.values()).filter(it -> it.getCode() == code).findFirst().orElseThrow(() -> new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"KemQueueType code \u201c" + code + "\u201d is not supported"}));
    }
}

