/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.isc.kem.core.queue.KemQueueConsumer;
import kd.isc.kem.core.queue.KemQueueExecutor;
import kd.isc.kem.core.queue.KemQueueItem;
import kd.isc.kem.core.queue.KemQueueMgr;
import kd.isc.kem.core.queue.KemQueueThreadMgr;

public class KemQueueWorkerMgr {
    private static final Map<String, Set<Long>> concurrentTaskSet = new HashMap<String, Set<Long>>();

    private KemQueueWorkerMgr() {
    }

    public static boolean canRun() {
        return KemQueueWorkerMgr.getConcurrentTaskSet().size() < 15;
    }

    public static void submit(KemQueueItem item, KemQueueExecutor worker) {
        Set<Long> running = KemQueueWorkerMgr.getConcurrentTaskSet();
        if (running.size() > 15) {
            return;
        }
        if (!running.add(item.getId())) {
            return;
        }
        KemQueueThreadMgr.WORKER.submit(() -> {
            try {
                String queue = item.getQueue();
                String type = item.getType().toString();
                KemQueueConsumer consumer = KemQueueMgr.get().findConsumeByQueue(queue, type);
                if (consumer != null && worker.canHandle(item)) {
                    worker.handle(item, consumer);
                }
            }
            finally {
                running.remove(item.getId());
            }
        }, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getConcurrentTaskSet() {
        String accountId = RequestContext.get().getAccountId();
        Set running = concurrentTaskSet.get(accountId);
        if (running == null) {
            Map<String, Set<Long>> map = concurrentTaskSet;
            synchronized (map) {
                running = concurrentTaskSet.computeIfAbsent(accountId, k -> Sets.newConcurrentHashSet());
            }
        }
        return running;
    }
}

