/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue.consumer;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.kem.core.queue.KemQueueAcker;
import kd.isc.kem.core.queue.KemQueueConsumer;
import kd.isc.kem.core.queue.impl.db.KemDbQueueSaver;
import kd.isc.kem.core.subscribe.SubscriberManager;
import kd.isc.kem.core.subscribe.handler.LogHandler;
import kd.isc.kem.core.subscribe.model.TargetRetryModel;

public class ActionConsumer
implements KemQueueConsumer<TargetRetryModel> {
    private static Log logger = LogFactory.getLog(ActionConsumer.class);

    @Override
    public void onMessage(TargetRetryModel model, long msgId, boolean resend, KemQueueAcker acker) {
        try {
            long targetId = model.getTargetId();
            if (targetId <= 0L) {
                acker.discard(msgId, "TargetId cannot be null.");
                return;
            }
            SubscriberManager.retryTarget(model, true);
            acker.ack(msgId);
        }
        catch (Exception e) {
            logger.error(ActionConsumer.class.getSimpleName(), (Throwable)e);
            acker.discard(msgId, LogHandler.getExMsg(e));
        }
        if (model != null && model.getInfo() != null) {
            KemDbQueueSaver.updateSubInstanceId(msgId, model.getInfo().getSubInstanceId());
        }
    }
}

