/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue.consumer;

import java.io.Serializable;
import java.util.Date;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.common.util.SerializationUtils;
import kd.isc.kem.core.event.CronEvent;
import kd.isc.kem.core.event.Event;
import kd.isc.kem.core.queue.KemQueueAcker;
import kd.isc.kem.core.queue.KemQueueConsumer;
import kd.isc.kem.core.queue.KemQueueFactory;
import kd.isc.kem.core.queue.KemQueuePriority;
import kd.isc.kem.core.queue.KemQueueType;
import kd.isc.kem.core.queue.impl.db.KemDbQueueSaver;
import kd.isc.kem.core.subscribe.SubscriberManager;
import kd.isc.kem.core.subscribe.handler.LogHandler;
import kd.isc.kem.core.subscribe.model.SubscribeInfo;
import kd.isc.kem.core.task.KemCronJobUtil;
import kd.isc.kem.core.task.KemSubscribeTask;

public class CronConsumer
implements KemQueueConsumer<CronEvent> {
    private static Log logger = LogFactory.getLog(KemSubscribeTask.class);

    @Override
    public void onMessage(CronEvent msg, long msgId, boolean resend, KemQueueAcker acker) {
        CronEvent newMsg = (CronEvent)SerializationUtils.clone((Serializable)msg);
        this.publishCron(newMsg);
        try {
            SubscribeInfo subscribeInfo = msg.getSubInfo();
            SubscriberManager.execute(subscribeInfo);
            acker.ack(msgId);
            if (subscribeInfo != null) {
                KemDbQueueSaver.updateSubInstanceId(msgId, subscribeInfo.getSubInstanceId());
            }
        }
        catch (Exception e) {
            logger.error(CronConsumer.class.getSimpleName(), (Throwable)e);
            acker.discard(msgId, LogHandler.getExMsg(e));
        }
    }

    private void publishCron(CronEvent msg) {
        Event event;
        long subInstanceId = ID.genLongId();
        Date scheduleTime = KemCronJobUtil.getNextScheduleTime(msg.getCronExpress());
        Date now = new Date();
        long cronMinInterval = 30000L;
        if (scheduleTime.getTime() - now.getTime() < cronMinInterval) {
            scheduleTime = new Date(now.getTime() + cronMinInterval);
        }
        if ((event = msg.getSubInfo().getEvent()) != null && event.getData() != null) {
            JsonHashMap jsonEventData = event.getData();
            jsonEventData.put((Object)"scheduleTime", (Object)scheduleTime);
        }
        SubscribeInfo subInfo = new SubscribeInfo(subInstanceId, msg.getSubId(), msg.getSubNumber(), event, scheduleTime);
        msg.setSubInfo(subInfo);
        msg.setScheduleTime(scheduleTime);
        String queueName = "KemCronEvent";
        String remark = event != null ? event.getEventNumber() + ":" + scheduleTime : "";
        long msgId = subInstanceId;
        KemQueueFactory.getQueue(queueName).publish(msgId, queueName, KemQueueType.Cron, KemQueuePriority.Normal, scheduleTime, 1, msg, msg.getSubId(), subInstanceId, remark);
    }
}

