/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue.consumer;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.kem.common.constants.EventType;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.common.util.CollectionUtil;
import kd.isc.kem.core.event.Event;
import kd.isc.kem.core.event.operate.SubOperateEventHandler;
import kd.isc.kem.core.exception.KemCoreError;
import kd.isc.kem.core.queue.KemQueueAcker;
import kd.isc.kem.core.queue.KemQueueConsumer;
import kd.isc.kem.core.queue.impl.db.KemDbQueueSaver;
import kd.isc.kem.core.subscribe.SubscriberManager;
import kd.isc.kem.core.subscribe.handler.LogHandler;
import kd.isc.kem.core.subscribe.model.SubscribeInfo;

public class EventConsumer
implements KemQueueConsumer<SubscribeInfo> {
    private static Log logger = LogFactory.getLog(EventConsumer.class);

    @Override
    public void onMessage(SubscribeInfo subscribeInfo, long msgId, boolean resend, KemQueueAcker acker) {
        try {
            SubscribeInfo newSubscribeInfo;
            try {
                newSubscribeInfo = this.formatEventData(subscribeInfo);
            }
            catch (Exception e) {
                throw new KemException((Throwable)e, (KemErrorTemplate)KemCoreError.CoreError, new Object[]{"event params format error:" + StringUtil.getMessage((Throwable)e)});
            }
            SubscriberManager.execute(newSubscribeInfo);
            acker.ack(msgId);
            if (subscribeInfo != null) {
                KemDbQueueSaver.updateSubInstanceId(msgId, subscribeInfo.getSubInstanceId());
            }
        }
        catch (Exception e) {
            logger.error(EventConsumer.class.getSimpleName(), (Throwable)e);
            acker.discard(msgId, LogHandler.getExMsg(e));
        }
    }

    private SubscribeInfo formatEventData(SubscribeInfo subscribeInfo) {
        DynamicObjectCollection dataEntry;
        Event event = subscribeInfo.getEvent();
        JsonHashMap eventData = event.getData();
        if (CollectionUtil.isEmpty((Map)eventData)) {
            return subscribeInfo;
        }
        if (event.isCronEvent()) {
            return subscribeInfo;
        }
        if (event.getEventType() != EventType.SDK && event.getEventType() != EventType.WebHook) {
            return subscribeInfo;
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)event.getEventId(), (String)"kem_event");
        if (object == null || CollectionUtil.isEmpty((Collection)(dataEntry = object.getDynamicObjectCollection("data_entry")))) {
            return subscribeInfo;
        }
        Map<Long, List<DynamicObject>> pidMap = dataEntry.stream().collect(Collectors.groupingBy(it -> it.getLong("pid")));
        Map<String, Object> data = SubOperateEventHandler.getData((Map<String, Object>)eventData, 0L, pidMap, null, event.getEventType());
        Event newEvent = new Event(event.getEventId(), event.getEventNumber(), event.getDataSourceId(), event.getEventType(), new JsonHashMap(data));
        SubscribeInfo newSubscribeInfo = new SubscribeInfo(subscribeInfo.getSubInstanceId(), subscribeInfo.getSubId(), subscribeInfo.getSubNumber(), newEvent, subscribeInfo.getDate());
        return newSubscribeInfo;
    }
}

