/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue.impl.db;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.id.ID;
import kd.isc.kem.common.exception.KemCommonError;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.core.event.CronEvent;
import kd.isc.kem.core.queue.KemQueue;
import kd.isc.kem.core.queue.KemQueueItem;
import kd.isc.kem.core.queue.KemQueueItemStatus;
import kd.isc.kem.core.queue.KemQueuePriority;
import kd.isc.kem.core.queue.KemQueueRequestContext;
import kd.isc.kem.core.queue.KemQueueType;
import kd.isc.kem.core.queue.impl.db.KemDbQueueNotifier;
import kd.isc.kem.core.queue.impl.db.KemDbQueueSaver;

public class KemDbQueueImpl
implements KemQueue {
    private String name;

    public String getName() {
        return this.name;
    }

    public KemDbQueueImpl(String name) {
        this.name = name;
    }

    @Override
    public void publish(long msgId, String queue, KemQueueType type, KemQueuePriority priority, Date scheduleTime, int deliveryCount, Object msg, long subId, long subInstanceId, String remark) {
        if (msg == null || msgId <= 0L || type == null || subId <= 0L) {
            throw new KemException((KemErrorTemplate)KemCommonError.CommonError, new Object[]{"Push msg to queue: msg or subId cannot be null."});
        }
        KemQueueItem item = this.buildKemQueueItem(msgId, queue, type, priority, scheduleTime, deliveryCount, msg, subId, subInstanceId, remark);
        boolean isPubToQueue = true;
        if (type == KemQueueType.Cron) {
            isPubToQueue = ((CronEvent)msg).isPub();
        }
        if (isPubToQueue) {
            KemDbQueueSaver.add(item);
            KemDbQueueNotifier.notify(item);
        } else {
            KemDbQueueSaver.removeBySubId(subId);
        }
    }

    private KemQueueItem buildKemQueueItem(long msgId, String queue, KemQueueType type, KemQueuePriority priority, Date scheduleTime, int deliveryCount, Object msg, long subId, long subInstanceId, String remark) {
        KemQueueItem item = new KemQueueItem();
        if (msgId <= 0L) {
            msgId = ID.genLongId();
        }
        item.setId(msgId);
        item.setType(type);
        item.setQueue(queue);
        try {
            item.setData(JacksonUtil.writeValueAsString((Object)msg));
        }
        catch (Exception exception) {
            // empty catch block
        }
        item.setStatus(KemQueueItemStatus.C1);
        item.setScheduleTime(scheduleTime);
        item.setPriority(priority);
        item.setDeliveryCount(deliveryCount);
        item.setSubId(subId);
        item.setSubInstanceId(subInstanceId);
        item.setRemark(remark);
        item.setErrMsg("");
        KemQueueRequestContext rc = new KemQueueRequestContext();
        rc.setUserId(RequestContext.get().getUserId());
        rc.setUserName(RequestContext.get().getUserName());
        item.setRequestContext(rc);
        return item;
    }

    @Override
    public void deleteByMsgId(long msgId) {
        KemDbQueueSaver.deleteByMsgId(msgId);
    }

    @Override
    public void deleteBySubId(long subId) {
        KemDbQueueSaver.removeBySubId(subId);
    }
}

