/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue.impl.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.util.JSONUtils;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.kem.common.constants.ConfigConstant;
import kd.isc.kem.common.util.DataUtil;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.core.event.CronEvent;
import kd.isc.kem.core.queue.KemQueueConsumer;
import kd.isc.kem.core.queue.KemQueueExecutor;
import kd.isc.kem.core.queue.KemQueueItem;
import kd.isc.kem.core.queue.KemQueueItemStatus;
import kd.isc.kem.core.queue.KemQueuePriority;
import kd.isc.kem.core.queue.KemQueueRequestContext;
import kd.isc.kem.core.queue.KemQueueThreadMgr;
import kd.isc.kem.core.queue.KemQueueType;
import kd.isc.kem.core.queue.KemQueueUtil;
import kd.isc.kem.core.queue.KemQueueWorkerMgr;
import kd.isc.kem.core.queue.impl.db.KemDbQueueAcker;
import kd.isc.kem.core.queue.impl.db.KemDbQueueSaver;
import kd.isc.kem.core.subscribe.model.SubscribeInfo;
import kd.isc.kem.core.subscribe.model.TargetRetryModel;

public class KemDbQueueLoader
implements Runnable,
KemQueueExecutor {
    private final long id = ID.genLongId();
    private long nextScheduleTime = System.currentTimeMillis();
    private static final String QUEUE_FIELDS = " fid,fstatus,fqueue,ftype,fpriority,fdata,fscheduletime,fdeliverycount, fsubid,fsubinstanceid,fqueuetag,ferrmsg,fremark,fctx ";

    protected KemDbQueueLoader() {
    }

    public long getId() {
        return this.id;
    }

    @Override
    public boolean canHandle(KemQueueItem item) {
        return KemDbQueueSaver.setRunning(item.getId(), this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(KemQueueItem item, KemQueueConsumer consumer) {
        if (item.getRequestContext() != null && RequestContext.get().getCurrUserId() < 0L) {
            RequestContext.get().setUserId(item.getRequestContext().getUserId());
            RequestContext.get().setUserName(item.getRequestContext().getUserName());
        }
        KemDbQueueAcker acker = new KemDbQueueAcker();
        try {
            Object data;
            KemQueueType type = item.getType();
            switch (type) {
                case Event: {
                    data = JacksonUtil.readValue((String)item.getData(), SubscribeInfo.class);
                    break;
                }
                case Cron: {
                    data = JacksonUtil.readValue((String)item.getData(), CronEvent.class);
                    break;
                }
                case Action: {
                    data = JacksonUtil.readValue((String)item.getData(), TargetRetryModel.class);
                    break;
                }
                case None: {
                    data = item.getData();
                    break;
                }
                default: {
                    data = item.getData();
                }
            }
            ConnectionManager.pushResLicense((boolean)true);
            consumer.onMessage(data, item.getId(), item.getDeliveryCount() > 0, acker);
        }
        catch (Exception ex) {
            KemDbQueueSaver.setQueueItemStatus(item.getId(), KemQueueItemStatus.E1, ex.getMessage());
        }
        finally {
            acker.ack(item.getId());
            ConnectionManager.popResLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int delay;
        boolean isEmpty = true;
        try {
            List<KemQueueItem> queueItems = this.loadFromDb();
            isEmpty = queueItems.isEmpty();
            for (KemQueueItem item : queueItems) {
                KemQueueWorkerMgr.submit(item, this);
            }
            delay = isEmpty ? 300 : 5;
        }
        catch (Throwable throwable) {
            int delay2 = isEmpty ? 300 : 5;
            this.nextScheduleTime = KemQueueThreadMgr.MAIN.submit(this, delay2);
            throw throwable;
        }
        this.nextScheduleTime = KemQueueThreadMgr.MAIN.submit(this, delay);
    }

    public boolean runNow(KemQueueItem item) {
        if (KemQueueWorkerMgr.canRun()) {
            KemQueueWorkerMgr.submit(item, this);
            return true;
        }
        long t = System.currentTimeMillis() + 5000L;
        if (this.nextScheduleTime > t) {
            KemQueueThreadMgr.MAIN.runAhead(this, 5);
            this.nextScheduleTime = t;
        }
        return false;
    }

    public boolean runNow(long msgId) {
        KemQueueItem item = null;
        String sql = "select  fid,fstatus,fqueue,ftype,fpriority,fdata,fscheduletime,fdeliverycount, fsubid,fsubinstanceid,fqueuetag,ferrmsg,fremark,fctx  from t_kem_queue  where fid = ? and fscheduletime<=? and fstatus = ? and fqueuetag=?";
        Object[] params = new Object[]{msgId, new Date(System.currentTimeMillis() + 200L), KemQueueItemStatus.C1, KemQueueUtil.getHostTag()};
        try (DataSet dataSet = DB.queryDataSet((String)"kem.queue", (DBRoute)ConfigConstant.DB_ROUTE, (String)sql, (Object[])params);){
            RowMeta rowMeta = dataSet.getRowMeta();
            List<String> fieldNames = Arrays.asList(rowMeta.getFieldNames());
            for (Row row : dataSet) {
                item = this.covertRowToItem(row, fieldNames);
            }
        }
        if (item != null) {
            return this.runNow(item);
        }
        return false;
    }

    private List<KemQueueItem> loadFromDb() {
        String sql = String.format("select top %s  fid,fstatus,fqueue,ftype,fpriority,fdata,fscheduletime,fdeliverycount, fsubid,fsubinstanceid,fqueuetag,ferrmsg,fremark,fctx  from t_kem_queue  where fscheduletime<=? and fstatus = ? and fqueuetag=?  order by fscheduletime,fpriority ", 50);
        Object[] params = new Object[]{new Date(System.currentTimeMillis() + 500L), KemQueueItemStatus.C1, KemQueueUtil.getHostTag()};
        ArrayList<KemQueueItem> rtn = new ArrayList<KemQueueItem>(50);
        try (DataSet dataSet = DB.queryDataSet((String)"kem.queue", (DBRoute)ConfigConstant.DB_ROUTE, (String)sql, (Object[])params);){
            RowMeta rowMeta = dataSet.getRowMeta();
            List<String> fieldNames = Arrays.asList(rowMeta.getFieldNames());
            for (Row row : dataSet) {
                rtn.add(this.covertRowToItem(row, fieldNames));
            }
        }
        return rtn;
    }

    private KemQueueItem covertRowToItem(Row row, List<String> fieldNames) {
        KemQueueItem item = new KemQueueItem();
        if (fieldNames.contains("fid")) {
            item.setId(row.getLong("fid"));
        }
        if (fieldNames.contains("fstatus")) {
            item.setStatus(KemQueueItemStatus.valueOf(row.getString("fstatus")));
        }
        if (fieldNames.contains("fqueue")) {
            item.setQueue(row.getString("fqueue"));
        }
        if (fieldNames.contains("ftype")) {
            int type = DataUtil.i((Object)row.getString("ftype"));
            item.setType(KemQueueType.getQueueType(type));
        }
        if (fieldNames.contains("fpriority")) {
            int priority = DataUtil.i((Object)row.getString("fpriority"));
            item.setPriority(KemQueuePriority.getPriority(priority));
        }
        if (fieldNames.contains("fdata")) {
            item.setData(row.getString("fdata"));
        }
        if (fieldNames.contains("fscheduletime")) {
            item.setScheduleTime(row.getDate("fscheduletime"));
        }
        if (fieldNames.contains("fdeliverycount")) {
            item.setDeliveryCount(row.getInteger("fdeliverycount"));
        }
        if (fieldNames.contains("fsubid")) {
            item.setSubId(row.getLong("fsubid"));
        }
        if (fieldNames.contains("fsubinstanceid")) {
            item.setSubInstanceId(row.getLong("fsubinstanceid"));
        }
        if (fieldNames.contains("fqueuetag")) {
            item.setQueueTag(row.getString("fqueuetag"));
        }
        if (fieldNames.contains("ferrmsg")) {
            item.setErrMsg(row.getString("ferrmsg"));
        }
        if (fieldNames.contains("fremark")) {
            item.setRemark(row.getString("fremark"));
        }
        if (fieldNames.contains("fctx")) {
            String fctx = row.getString("fctx");
            KemQueueRequestContext rc = null;
            try {
                if (StringUtil.isNotEmpty((String)fctx)) {
                    rc = (KemQueueRequestContext)JSONUtils.cast((String)fctx, KemQueueRequestContext.class);
                }
            }
            catch (Exception ignore) {
                rc = null;
            }
            item.setRequestContext(rc);
        }
        return item;
    }
}

