/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue.impl.db;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.kem.common.constants.ConfigConstant;
import kd.isc.kem.core.queue.KemQueueItemStatus;
import kd.isc.kem.core.queue.KemQueueThreadMgr;
import kd.isc.kem.core.queue.KemQueueUtil;
import kd.isc.kem.core.queue.impl.db.KemDbQueueLoader;

public class KemDbQueueMgr {
    private static final Log log = LogFactory.getLog(KemDbQueueMgr.class);
    private static final Map<String, KemDbQueueLoader> tasks = new HashMap<String, KemDbQueueLoader>();
    private static final int INIT_THREAD_DELAY = 30;
    private static final Object lockObject = new Object();

    private KemDbQueueMgr() {
    }

    public static void clearDbLoader() {
        tasks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KemDbQueueLoader getLoader() {
        String key = RequestContext.get().getAccountId();
        KemDbQueueLoader loader = tasks.get(key);
        if (loader == null) {
            Object object = lockObject;
            synchronized (object) {
                loader = new KemDbQueueLoader();
                tasks.put(key, loader);
                KemQueueThreadMgr.MAIN.submit(loader, 5);
                KemQueueThreadMgr.MAIN.submit(new UpdateOnline(), 5);
                KemQueueThreadMgr.MAIN.submit(new WorkerChecker(), 30);
                KemQueueThreadMgr.MAIN.submit(new UnackItemChecker(), 30);
            }
        }
        return loader;
    }

    public static boolean getKemEnabled() {
        boolean existsKemSub = false;
        try {
            SqlBuilder sql = new SqlBuilder().append("select top 1 fid from t_kem_sub where fenable='1' and fstatus='B' ", new Object[0]);
            try (DataSet dataSet = DB.queryDataSet((String)"kem.sub", (DBRoute)ConfigConstant.DB_ROUTE, (SqlBuilder)sql);){
                if (dataSet != null && !dataSet.isEmpty()) {
                    log.info("KEM--Kem service is enabled, accountId\uff1a" + RequestContext.get().getAccountId());
                    existsKemSub = true;
                }
            }
        }
        catch (Exception nothing) {
            log.info(String.format("KEM-Error occurred when Loading t_kem_sub, accountId\uff1a%s,error message: %s", RequestContext.get().getAccountId(), nothing.getMessage()));
        }
        return existsKemSub;
    }

    static long getWorkerId() {
        return KemDbQueueMgr.getLoader().getId();
    }

    private static class UnackItemChecker
    implements Runnable {
        private UnackItemChecker() {
        }

        @Override
        public void run() {
            try {
                this.updateUnackItem();
            }
            finally {
                KemQueueThreadMgr.MAIN.submit(this, 300);
            }
        }

        private void updateUnackItem() {
            Date checkDate = new Date(System.currentTimeMillis() - 1800000L);
            Date startDate = new Date(0L);
            String sql = "UPDATE t_kem_queue set fstatus=?,fmodifytime=? WHERE fstatus=? and fstarttime>? and fstarttime<? ";
            DB.update((DBRoute)ConfigConstant.DB_ROUTE, (String)sql, (Object[])new Object[]{KemQueueItemStatus.T1, new Date(), KemQueueItemStatus.R1, startDate, checkDate});
        }
    }

    private static class WorkerChecker
    implements Runnable {
        private WorkerChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SqlBuilder sql = new SqlBuilder().append("select fid,fhost,factiveat from t_kem_queue_worker where factiveat<=?", new Object[]{new Date(System.currentTimeMillis() - 1800000L)});
                ArrayList<Long> delIds = new ArrayList<Long>(2);
                try (DataSet dataSet = DB.queryDataSet((String)"kem.queue", (DBRoute)ConfigConstant.DB_ROUTE, (SqlBuilder)sql);){
                    for (Row row : dataSet) {
                        Long id = row.getLong("fid");
                        String host = row.getString("fhost");
                        this.updateByHost(id, host);
                        delIds.add(id);
                    }
                }
                if (!delIds.isEmpty()) {
                    sql = new SqlBuilder().append("DELETE FROM t_kem_queue_worker where ", new Object[0]).appendIn("fid", delIds);
                    DB.execute((DBRoute)ConfigConstant.DB_ROUTE, (SqlBuilder)sql);
                }
            }
            finally {
                KemQueueThreadMgr.MAIN.submit(this, 300);
            }
        }

        public void updateByHost(long id, String host) {
            String sql = "UPDATE t_kem_queue set fstatus=?,fstarttime=null,fmodifytime=null WHERE fstatus=? and fdeliveryhost=?";
            DB.update((DBRoute)ConfigConstant.DB_ROUTE, (String)sql, (Object[])new Object[]{KemQueueItemStatus.C1, KemQueueItemStatus.R1, host});
        }
    }

    private static class UpdateOnline
    implements Runnable {
        private UpdateOnline() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long workerId = KemDbQueueMgr.getWorkerId();
                SqlBuilder sql = new SqlBuilder().append("UPDATE t_kem_queue_worker set factiveat=? WHERE fid=?", new Object[]{new Date(), workerId});
                int updateCount = DB.update((DBRoute)ConfigConstant.DB_ROUTE, (SqlBuilder)sql);
                if (updateCount == 0) {
                    String host = KemQueueUtil.getHostName(workerId);
                    sql = new SqlBuilder().append("INSERT INTO t_kem_queue_worker (fid,fhost,factiveat) values (?,?,?)", new Object[]{workerId, host, new Date()});
                    DB.execute((DBRoute)ConfigConstant.DB_ROUTE, (SqlBuilder)sql);
                }
            }
            finally {
                KemQueueThreadMgr.MAIN.submit(this, 300);
            }
        }
    }
}

