/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue.impl.db;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.db.RequestContextInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.BroadcastService;
import kd.isc.kem.core.queue.KemQueueItem;
import kd.isc.kem.core.queue.impl.db.KemDbQueueMgr;

public class KemDbQueueNotifier {
    private static final Log log = LogFactory.getLog(KemDbQueueNotifier.class);
    private static long lastNotifyDate = 0L;

    public static void notify(KemQueueItem item) {
        Date now = new Date();
        if (now.compareTo(item.getScheduleTime()) < 0) {
            return;
        }
        if (KemDbQueueMgr.getLoader().runNow(item)) {
            return;
        }
        if (System.currentTimeMillis() - lastNotifyDate > 3000L) {
            lastNotifyDate = System.currentTimeMillis();
            Object[] params = new Object[]{RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), item.getId()};
            BroadcastService.broadcastMessageWithApp((String)"kem", (String)KemDbQueueNotifier.class.getName(), (String)"broadcastNotify", (Object[])params);
        }
    }

    public static void broadcastNotify(String tenantId, String accountId, long msgId) {
        RequestContextInfo rc = new RequestContextInfo(tenantId, accountId);
        try (AutoCloseable ignore = rc.setupThreadRequestContext();){
            KemDbQueueMgr.getLoader().runNow(msgId);
        }
        catch (Exception ignore2) {
            log.error("Kem-Exception\uff1a" + ignore2.getMessage(), (Throwable)ignore2);
        }
    }
}

