/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.queue.impl.db;

import java.io.IOException;
import java.util.Date;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.id.ID;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.kem.common.constants.ConfigConstant;
import kd.isc.kem.core.queue.KemQueueItem;
import kd.isc.kem.core.queue.KemQueueItemStatus;
import kd.isc.kem.core.queue.KemQueueUtil;

public class KemDbQueueSaver {
    public static void add(KemQueueItem item) {
        String fctx = "";
        try {
            fctx = JSONUtils.toString((Object)item.getRequestContext());
        }
        catch (IOException ex) {
            fctx = "";
        }
        String errMsg2 = StringUtil.trim((String)item.getErrMsg(), (int)400);
        if (errMsg2 == null) {
            errMsg2 = "";
        }
        String remark2 = StringUtil.trim((String)item.getRemark(), (int)200);
        SqlBuilder sql = new SqlBuilder().append("insert into t_kem_queue (fid,ftype,fqueue,fdata,fstatus,fpriority,fscheduletime,fdeliveryCount,fqueuetag,fsubid,fcreatetime,fctx,ferrMsg,fremark) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{item.getId(), item.getType().getCode(), item.getQueue(), item.getData(), item.getStatus(), item.getPriority().getCode(), item.getScheduleTime(), item.getDeliveryCount(), KemQueueUtil.getHostTag(), item.getSubId(), new Date(), fctx, errMsg2, remark2});
        DB.execute((DBRoute)ConfigConstant.DB_ROUTE, (SqlBuilder)sql);
    }

    public static void removeBySubId(long subId) {
        String sql = "DELETE FROM t_kem_queue WHERE fsubid=? and fstatus=?";
        DB.execute((DBRoute)ConfigConstant.DB_ROUTE, (String)sql, (Object[])new Object[]{subId, KemQueueItemStatus.C1});
    }

    public static void deleteByMsgId(long msgId) {
        String sql = "DELETE FROM t_kem_queue WHERE fid=?";
        DB.execute((DBRoute)ConfigConstant.DB_ROUTE, (String)sql, (Object[])new Object[]{msgId});
    }

    public static void reEnQueue(long msgId, String errMsg) {
        String errMsg2 = StringUtil.trim((String)errMsg, (int)400);
        SqlBuilder sql = new SqlBuilder().append("UPDATE t_kem_queue set fstatus=?,fstarttime=?, fmodifytime=?, fscheduleTime=?,ferrMsg=? WHERE fid=?", new Object[]{KemQueueItemStatus.C1, null, null, new Date(), errMsg2, msgId});
        DB.update((DBRoute)ConfigConstant.DB_ROUTE, (SqlBuilder)sql);
    }

    public static boolean setRunning(long msgId, long workerId) {
        String host = ID.toStringId((long)workerId) + ":" + NetAddressUtils.getLocalIpAddress();
        SqlBuilder sql = new SqlBuilder().append("UPDATE t_kem_queue set fstatus=?,fstarttime=?,fdeliveryHost=? WHERE fid=? AND fstatus = ?", new Object[]{KemQueueItemStatus.R1, new Date(), host, msgId, KemQueueItemStatus.C1});
        int updateCount = DB.update((DBRoute)ConfigConstant.DB_ROUTE, (SqlBuilder)sql);
        return updateCount > 0;
    }

    public static void setQueueItemStatus(long msgId, KemQueueItemStatus status, String errMsg) {
        String errMsg2 = "";
        if (status == KemQueueItemStatus.E1 || status == KemQueueItemStatus.T1) {
            errMsg2 = kd.isc.kem.common.util.StringUtil.substring((String)errMsg, (int)0, (int)400);
        }
        SqlBuilder sql = new SqlBuilder().append("UPDATE t_kem_queue set fstatus=?,fmodifytime=?,ferrMsg=? WHERE fid=?", new Object[]{status, new Date(), errMsg2, msgId});
        DB.update((DBRoute)ConfigConstant.DB_ROUTE, (SqlBuilder)sql);
    }

    public static boolean cmpAndSetQueueItemStatus(long msgId, Set<KemQueueItemStatus> expectStatus, KemQueueItemStatus newStatus) {
        int updateCount;
        SqlBuilder sql = newStatus == KemQueueItemStatus.E1 || newStatus == KemQueueItemStatus.T1 ? new SqlBuilder().append("UPDATE t_kem_queue set fstatus=?,fmodifytime=? WHERE fid=?", new Object[]{newStatus, new Date(), msgId}) : new SqlBuilder().append("UPDATE t_kem_queue set fstatus=?,fmodifytime=?,ferrMsg='' WHERE fid=?", new Object[]{newStatus, new Date(), msgId});
        if (expectStatus != null && !expectStatus.isEmpty()) {
            if (expectStatus.size() > 1) {
                sql.append(" AND ", new Object[0]).appendIn("fstatus", expectStatus.toArray(new Object[0]));
            } else {
                sql.append(" AND ", new Object[0]).append("fstatus = ?", new Object[]{expectStatus.toArray(new Object[0])[0]});
            }
        }
        return (updateCount = DB.update((DBRoute)ConfigConstant.DB_ROUTE, (SqlBuilder)sql)) > 0;
    }

    public static boolean updateSubInstanceId(long msgId, long subInstanceId) {
        SqlBuilder sql = new SqlBuilder().append("UPDATE t_kem_queue set fsubinstanceid=? WHERE fid=?", new Object[]{subInstanceId, msgId});
        int updateCount = DB.update((DBRoute)ConfigConstant.DB_ROUTE, (SqlBuilder)sql);
        return updateCount > 0;
    }
}

