/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.script;

import java.util.HashMap;
import java.util.Map;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.core.script.KemScript;

public class KemConditionUtil {
    private static final IConverter defaultConverter = (name, type, val) -> name + " " + type + " " + val;
    private static final Map<String, IConverter> converters = new HashMap<String, IConverter>();

    private KemConditionUtil() {
    }

    public static String genScript(String name, String type, String value, boolean isPreview, HashMap<String, Object> ctx) {
        IConverter converter = converters.getOrDefault(type, defaultConverter);
        if (!isPreview) {
            if (value.startsWith("<%") && value.endsWith("%>")) {
                int start = value.indexOf("<%");
                int end = value.lastIndexOf("%>");
                value = value.substring(start + 2, end);
                value = KemConditionUtil.calScriptValue(value, ctx);
            } else if (value.startsWith("#{") && value.endsWith("}")) {
                int start = value.indexOf("#{");
                int end = value.lastIndexOf(125);
                value = value.substring(start + 2, end);
                value = KemConditionUtil.calScriptValue(value, ctx);
            }
        }
        return converter.toScript(name, type, value);
    }

    private static String calScriptValue(String value, HashMap<String, Object> ctx) {
        Object obj = KemScript.eval(value, ctx);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return JacksonUtil.isJson((String)str) ? str : JacksonUtil.writeValueAsString((Object)str);
        }
        return JacksonUtil.writeValueAsString((Object)obj);
    }

    static {
        IConverter eq = (name, type, val) -> name + " == " + val;
        converters.put("=", eq);
        IConverter ge = (name, type, val) -> name + " >= " + val;
        converters.put(">=", ge);
        IConverter gt = (name, type, val) -> name + " > " + val;
        converters.put(">", gt);
        IConverter ne = (name, type, val) -> name + " != " + val;
        converters.put("<>", ne);
        IConverter le = (name, type, val) -> name + " <= " + val;
        converters.put("<=", le);
        IConverter lt = (name, type, val) -> name + " < " + val;
        converters.put("<", lt);
        IConverter IN = (name, type, val) -> name + " in " + val;
        converters.put("in", IN);
        IConverter notInConverter = (name, type, val) -> "!(" + name + " in " + val + ")";
        converters.put("not in", notInConverter);
        IConverter NOT_CONTAINS = (name, type, val) -> "!(" + name + " contains " + val + ")";
        converters.put("NOT_CONTAINS", NOT_CONTAINS);
        IConverter CONTAINS = (name, type, val) -> name + " contains " + val;
        converters.put("CONTAINS", CONTAINS);
        IConverter STARTS_WITH = (name, type, val) -> name + " startsWith " + val;
        converters.put("STARTS_WITH", STARTS_WITH);
        IConverter NOT_STARTS_WITH = (name, type, val) -> "!(" + name + " startsWith " + val + ")";
        converters.put("NOT_STARTS_WITH", NOT_STARTS_WITH);
        IConverter ENDS_WITH = (name, type, val) -> name + " endsWith " + val;
        converters.put("ENDS_WITH", ENDS_WITH);
        IConverter NOT_ENDS_WITH = (name, type, val) -> "!(" + name + " endsWith " + val + ")";
        converters.put("NOT_ENDS_WITH", NOT_ENDS_WITH);
        IConverter IS_NULL = (name, type, val) -> name + " is null";
        converters.put("IS_NULL", IS_NULL);
        IConverter IS_NOT_NULL = (name, type, val) -> name + " is not null";
        converters.put("IS_NOT_NULL", IS_NOT_NULL);
    }

    private static interface IConverter {
        public String toScript(String var1, String var2, String var3);
    }
}

