/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.kem.common.constants.LogStatus;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.core.event.Event;
import kd.isc.kem.core.event.EventPubInfo;
import kd.isc.kem.core.event.EventServiceImpl;
import kd.isc.kem.core.event.KemEventFactory;
import kd.isc.kem.core.exception.KemCoreError;
import kd.isc.kem.core.subscribe.builder.Subscriber;
import kd.isc.kem.core.subscribe.handler.LogHandler;
import kd.isc.kem.core.subscribe.model.NodeOutput;
import kd.isc.kem.core.subscribe.model.SubscribeInfo;
import kd.isc.kem.core.subscribe.model.TargetRetryModel;
import kd.isc.kem.core.subscribe.subscriber.KemSubscriber;

public class SubscriberManager {
    private static final Log LOG = LogFactory.getLog(SubscriberManager.class);

    public static void execute(SubscribeInfo info) {
        DynamicObject sub = SubscriberManager.getSubPublish(info.getSubId());
        if (sub == null) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"subId: " + info.getSubId() + " does not exist or subscription is not published."});
        }
        Subscriber subscriber = SubscriberManager.getSubscriber(info);
        subscriber.execute();
    }

    public static EventPubInfo retryQueue(long subId, NodeOutput sourceNodeOutput) {
        List<EventPubInfo> infoList = KemEventFactory.getEventService().publishBySubId(subId, (Map<String, Object>)sourceNodeOutput.getOutput());
        return infoList.get(0);
    }

    public static void retrySub(long subId, NodeOutput sourceNodeOutput) {
        SubscribeInfo subInfo = SubscriberManager.getSubscribeInfo(null, subId, (Map<String, Object>)sourceNodeOutput.getOutput());
        SubscriberManager.execute(subInfo);
    }

    private static SubscribeInfo getSubscribeInfo(Long subInstanceId, long subId, Map<String, Object> eventData) {
        DynamicObject sub = SubscriberManager.getSubPublish(subId);
        if (sub == null) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"subId: " + subId + " does not exist or subscription is not published."});
        }
        long eventId = sub.getLong("eventid.id");
        long dataSourceId = sub.getLong("eventdatasourceid.id");
        Event event = EventServiceImpl.getEvent(eventId, dataSourceId, eventData == null ? Collections.emptyMap() : eventData);
        long insId = subInstanceId != null && subInstanceId > 0L ? subInstanceId : ID.genLongId();
        return new SubscribeInfo(insId, subId, sub.getString("number"), event, new Date());
    }

    public static void retryTarget(long subInstanceId, long subId, NodeOutput nodeOutput, long targetId, int retrySeq) {
        JsonHashMap data = nodeOutput == null ? null : nodeOutput.getOutput();
        SubscribeInfo subInfo = SubscriberManager.getSubscribeInfo(subInstanceId, subId, (Map<String, Object>)data);
        TargetRetryModel targetRetryModel = new TargetRetryModel(subInfo, targetId, retrySeq, ID.genLongId(), null);
        SubscriberManager.retryTarget(targetRetryModel, false);
    }

    public static void retryTarget(TargetRetryModel model, boolean isAutoRetry) {
        DynamicObject sub = SubscriberManager.getSubPublish(model.getInfo().getSubId());
        if (sub == null) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"subId: " + model.getInfo().getSubId() + " does not exist or subscription is not published."});
        }
        if (sub.getDynamicObjectCollection("target_entry").stream().noneMatch(it -> it.getLong("id") == model.getTargetId())) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"subId: " + model.getInfo().getSubId() + ", targetId: " + model.getTargetId() + " does not exist or has deleted."});
        }
        KemSubscriber kemSubscriber = new KemSubscriber(model.getInfo());
        kemSubscriber.executeTargetRetry(model, isAutoRetry);
    }

    private static Subscriber getSubscriber(SubscribeInfo info) {
        KemSubscriber kemSubscriber = new KemSubscriber(info);
        LogHandler.initLog(info, LogStatus.Prepare, null);
        return kemSubscriber;
    }

    private static DynamicObject getSubPublish(long subId) {
        QFilter[] qFilters = QFilterUtil.builder().put("id", "=", (Object)subId).put("status", "=", (Object)"B").build();
        return BusinessDataServiceHelper.loadSingleFromCache((String)"kem_subscribe", (QFilter[])qFilters);
    }
}

