/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.definition;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.util.script.feature.sql.SqlRuntime;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.common.util.DataUtil;
import kd.isc.kem.common.util.SerializationUtils;
import kd.isc.kem.core.exception.KemCoreError;
import kd.isc.kem.core.script.KemConditionUtil;
import kd.isc.kem.core.script.KemScript;
import kd.isc.kem.core.script.ScriptUsageScene;
import kd.isc.kem.core.subscribe.definition.LogProcessorDefinition;
import kd.isc.kem.core.subscribe.definition.NodeType;
import kd.isc.kem.core.subscribe.model.FilterModel;
import kd.isc.kem.core.subscribe.model.NodeOutput;
import kd.isc.kem.core.subscribe.model.SubscriberContext;

public class FilterDefinition
extends LogProcessorDefinition<FilterDefinition, FilterModel> {
    private static final Log LOG = LogFactory.getLog(FilterDefinition.class);

    public FilterDefinition(SubscriberContext parentContext) {
        super(parentContext, NodeType.FILTER);
    }

    @Override
    JsonHashMap getInput(FilterModel model) {
        return this.getSubscriberContext().getNodeIn().getOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NodeOutput getOutput(JsonHashMap input, FilterModel model) {
        String select = "matchscript,matchscript_tag,subcond_entry.leftbracket,subcond_entry.paraname,subcond_entry.condtype,subcond_entry.paravalue,subcond_entry.rightbracket,subcond_entry.andor";
        DynamicObject filterConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getSubscribeInfo().getSubId(), (String)"kem_subscribe", (String)select);
        DynamicObjectCollection condEntry = filterConfig.getDynamicObjectCollection("subcond_entry");
        String script = filterConfig.getString("matchscript_tag");
        HashMap<String, Object> ctx = KemScript.getCtx((Map<String, Object>)input, this.getSubscribeInfo());
        String ruleScript = FilterDefinition.buildRuleScript(condEntry, false, (HashMap)SerializationUtils.clone(ctx));
        Boolean ruleResult = Boolean.TRUE;
        if (!StringUtils.isEmpty((String)ruleScript)) {
            LOG.info("---filter-getOutput-ruleScript--{}", (Object)ruleScript);
            try {
                ruleResult = (Boolean)ObjectConverter.convert((Object)KemScript.eval(ruleScript, (HashMap)SerializationUtils.clone(ctx)), Boolean.class, (boolean)false);
            }
            catch (Exception ex) {
                KemException.throwEx((Throwable)ex, (KemErrorTemplate)KemCoreError.CoreError, (Object[])new Object[]{"ruleScript: " + ruleScript});
            }
        }
        Boolean scriptResult = Boolean.TRUE;
        if (!StringUtils.isEmpty((String)script)) {
            LOG.info("---filter-getOutput-script--{}", (Object)script);
            try {
                HashMap map = (HashMap)SerializationUtils.clone(ctx);
                map.putAll(ScriptUsageScene.Script.extFunctions());
                scriptResult = (Boolean)ObjectConverter.convert((Object)KemScript.eval(script, map), Boolean.class, (boolean)false);
            }
            catch (Exception ex) {
                KemException.throwEx((Throwable)ex, (KemErrorTemplate)KemCoreError.CoreError, (Object[])new Object[]{"script: " + script});
            }
            finally {
                SqlRuntime.setCurrent(null);
            }
        }
        NodeOutput nodeOutput = NodeOutput.of(ruleResult != false && scriptResult != false, input);
        nodeOutput.putExt("filter", ruleScript);
        nodeOutput.putExt("filterScript", script);
        return nodeOutput;
    }

    public static String buildRuleScript(DynamicObjectCollection condEntry, boolean isPreview, HashMap<String, Object> ctx) {
        StringBuilder sb = new StringBuilder();
        int len = condEntry.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject filterEntry = (DynamicObject)condEntry.get(i);
            if (filterEntry == null) continue;
            sb.append(FilterDefinition.trim(filterEntry.get("leftbracket")));
            String name = FilterDefinition.trim(filterEntry.get("paraname"));
            String type = FilterDefinition.trim(filterEntry.get("condtype"));
            String value = FilterDefinition.trim(filterEntry.get("paravalue"));
            String condScript = KemConditionUtil.genScript(name, type, value, isPreview, (HashMap)SerializationUtils.clone(ctx));
            sb.append(' ').append(condScript).append(' ');
            sb.append(FilterDefinition.trim(filterEntry.get("rightbracket")));
            if (i >= len - 1) continue;
            if ("1".equals(DataUtil.s((Object)filterEntry.get("andor")))) {
                sb.append("||");
                continue;
            }
            sb.append("&&");
        }
        return sb.toString().trim();
    }

    private static String trim(Object o) {
        String s = DataUtil.s((Object)o);
        if (s == null) {
            return "";
        }
        return s;
    }
}

