/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.definition;

import com.google.common.base.Stopwatch;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.kem.common.constants.LogStatus;
import kd.isc.kem.common.constants.NodeLogStatus;
import kd.isc.kem.common.exception.ExceptionUtil;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.common.util.KemAssert;
import kd.isc.kem.common.util.LogUtil;
import kd.isc.kem.core.exception.KemCoreError;
import kd.isc.kem.core.subscribe.definition.FilterDefinition;
import kd.isc.kem.core.subscribe.definition.NodeType;
import kd.isc.kem.core.subscribe.definition.OptionalIdentifiedDefinition;
import kd.isc.kem.core.subscribe.definition.SourceDefinition;
import kd.isc.kem.core.subscribe.definition.TargetDefinition;
import kd.isc.kem.core.subscribe.handler.LogHandler;
import kd.isc.kem.core.subscribe.model.FilterModel;
import kd.isc.kem.core.subscribe.model.NodeLogModel;
import kd.isc.kem.core.subscribe.model.NodeOutput;
import kd.isc.kem.core.subscribe.model.SourceModel;
import kd.isc.kem.core.subscribe.model.SubscribeInfo;
import kd.isc.kem.core.subscribe.model.SubscriberContext;
import kd.isc.kem.core.subscribe.model.TargetModel;
import kd.isc.kem.core.subscribe.model.TargetRetryModel;

public abstract class ProcessorDefinition<Type extends ProcessorDefinition<Type, ModelType>, ModelType>
extends OptionalIdentifiedDefinition<Type> {
    protected static final Log LOG = LogFactory.getLog(ProcessorDefinition.class);
    protected static final JsonHashMap NULL = null;
    private final SubscriberContext subscriberContext;
    private final NodeType nodeType;

    public ProcessorDefinition(SubscriberContext parentContext, NodeType nodeType) {
        KemAssert.notNull((Object)parentContext, (String)"parentContext must not be null");
        KemAssert.notNull((Object)((Object)nodeType), (String)"nodeType must not be null");
        if (NodeType.LOG == nodeType && NodeType.LOG == parentContext.getNodeType()) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"cannot have connected log nodes"});
        }
        this.subscriberContext = new SubscriberContext(parentContext, nodeType);
        this.nodeType = nodeType;
        LogUtil.info((Log)LOG, (String)(super.getClass().getName() + ": " + (Object)((Object)nodeType) + "\uff1a" + this.subscriberContext));
    }

    public SourceDefinition source(Function<SubscriberContext, SourceModel> function) {
        return this.wrap(() -> this.definitionWrap(SourceDefinition::new, function), NodeType.SOURCE);
    }

    public FilterDefinition filter(Function<SubscriberContext, FilterModel> function) {
        return this.wrap(() -> this.definitionWrap(FilterDefinition::new, function), NodeType.FILTER);
    }

    public Optional<TargetDefinition> targets(Function<SubscriberContext, TargetModel> function) {
        Function<SubscriberContext, TargetDefinition> definitionFunction = TargetDefinition::new;
        return Optional.ofNullable(this.wrap(() -> (TargetDefinition)this.definitionWrap(definitionFunction, function), NodeType.TARGET));
    }

    public Optional<TargetDefinition> retryTargets(Function<SubscriberContext, TargetModel> function, TargetRetryModel model, boolean isAutoRetry) {
        Function<SubscriberContext, TargetDefinition> definitionFunction = it -> new TargetDefinition((SubscriberContext)it, model, isAutoRetry);
        return Optional.ofNullable(this.wrap(() -> (TargetDefinition)this.definitionWrap(definitionFunction, function), NodeType.TARGET));
    }

    <Def extends ProcessorDefinition<Def, Model>, Model> Def definitionWrap(Function<SubscriberContext, Def> definitionFunction, BiFunction<SubscriberContext, Boolean, Model> modelBiFunction, boolean isRecordInput) {
        SubscriberContext parentContext = this.getSubscriberContext();
        ProcessorDefinition definition = (ProcessorDefinition)definitionFunction.apply(parentContext);
        KemAssert.notNull((Object)definition, (String)"definition must not be null");
        Model model = modelBiFunction.apply(definition.getSubscriberContext(), isRecordInput);
        KemAssert.notNull(model, (String)"model must not be null");
        return (Def)this.endDefinition(definition, model);
    }

    private <Def extends ProcessorDefinition<Def, Model>, Model> Def definitionWrap(Function<SubscriberContext, Def> definitionFunction, Function<SubscriberContext, Model> function) {
        SubscriberContext parentContext = this.getSubscriberContext();
        ProcessorDefinition definition = (ProcessorDefinition)definitionFunction.apply(parentContext);
        KemAssert.notNull((Object)definition, (String)"definition must not be null");
        Model model = function.apply(definition.getSubscriberContext());
        KemAssert.notNull(model, (String)"model must not be null");
        return (Def)this.endDefinition(definition, model);
    }

    <Def extends ProcessorDefinition<Def, Model>, Model> Def wrap(Supplier<Def> supplier, NodeType nodeType) {
        ProcessorDefinition result = null;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            result = (ProcessorDefinition)supplier.get();
        }
        catch (Exception e) {
            LOG.error("KEM_LOG:\uff1a" + (Object)((Object)nodeType), (Throwable)e);
            if (!(e instanceof KemException) || !KemCoreError.NOT_RECORD_LOG.getCode().equals(((KemException)e).getErrorCode().getCode())) {
                NodeLogModel nodeLogModel = new NodeLogModel(this.getSubscribeInfo().getSubInstanceId(), 0L, nodeType, NodeLogStatus.Fail, null, null, e, true, 0, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                LogHandler.recordNodeLog(nodeLogModel, false);
            }
            throw new KemException((Throwable)e, (KemErrorTemplate)KemCoreError.CoreError, new Object[]{ExceptionUtil.getMessage((Throwable)e)});
        }
        return (Def)result;
    }

    public SubscriberContext getSubscriberContext() {
        return this.subscriberContext;
    }

    protected SubscribeInfo getSubscribeInfo() {
        return this.getSubscriberContext().getInfo();
    }

    private <Def extends ProcessorDefinition<Def, Model>, Model> Def endDefinition(Def definition, Model model) {
        SubscriberContext context = definition.getSubscriberContext();
        if (context.getNodeType() != NodeType.LOG && context.getNodeIn() != null && !context.getNodeIn().isStatus()) {
            LogHandler.updateLog(context.getInfo().getSubInstanceId(), LogStatus.Ignore);
            return null;
        }
        JsonHashMap in = null;
        NodeOutput out = null;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            NodeInOur<Model> inOur = definition.execute(model);
            in = inOur.getIn();
            context.setInput(in);
            out = inOur.getOut();
            context.setOutput(out);
            if (!((NodeInOur)inOur).isSuccess) {
                throw ((NodeInOur)inOur).error;
            }
            context.setCost(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
        catch (Throwable e) {
            LOG.error("KEM_LOG:\uff1a" + (Object)((Object)context.getNodeType()), e);
            NodeLogModel nodeLogModel = new NodeLogModel(this.getSubscribeInfo().getSubInstanceId(), definition.getNodeId(), context.getNodeType(), NodeLogStatus.Fail, in, out, e, true, 0, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
            LogHandler.recordNodeLog(nodeLogModel, false);
            throw new KemException(e, (KemErrorTemplate)KemCoreError.NOT_RECORD_LOG, new Object[]{ExceptionUtil.getMessage((Throwable)e)});
        }
        return definition;
    }

    NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    long getNodeId() {
        return this.getSubscriberContext().getNodeId();
    }

    abstract JsonHashMap getInput(ModelType var1);

    abstract NodeOutput getOutput(JsonHashMap var1, ModelType var2);

    NodeInOur<ModelType> execute(ModelType model) {
        return new NodeInOur<ModelType>(() -> this.getInput(model), input -> this.getOutput((JsonHashMap)input, model), model);
    }

    private static class NodeInOur<Model> {
        private JsonHashMap input;
        private NodeOutput output;
        private boolean isSuccess = true;
        private Throwable error;

        NodeInOur(Supplier<JsonHashMap> in, Function<JsonHashMap, NodeOutput> out, Model model) {
            try {
                this.input = in.get();
            }
            catch (Exception e) {
                this.error = e;
                this.isSuccess = false;
            }
            try {
                if (this.isSuccess) {
                    this.output = out.apply(this.input);
                }
            }
            catch (Exception e) {
                this.error = e;
                this.isSuccess = false;
            }
        }

        JsonHashMap getIn() {
            return this.input;
        }

        NodeOutput getOut() {
            return this.output;
        }
    }
}

