/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.definition;

import java.util.Collections;
import java.util.List;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.common.util.KemAssert;
import kd.isc.kem.core.subscribe.definition.NodeType;
import kd.isc.kem.core.subscribe.definition.ProcessorDefinition;
import kd.isc.kem.core.subscribe.definition.TargetForEachDefinition;
import kd.isc.kem.core.subscribe.model.NodeOutput;
import kd.isc.kem.core.subscribe.model.SubscriberContext;
import kd.isc.kem.core.subscribe.model.TargetModel;
import kd.isc.kem.core.subscribe.model.TargetRetryModel;

public class TargetDefinition
extends ProcessorDefinition<TargetDefinition, TargetModel> {
    private boolean isRetry = false;
    private boolean isAutoRetry = true;
    private TargetRetryModel targetRetryModel;

    public TargetDefinition(SubscriberContext parentContext) {
        super(parentContext, NodeType.TARGET);
    }

    public TargetDefinition(SubscriberContext parentContext, TargetRetryModel model, boolean isAutoRetry) {
        this(parentContext);
        this.isRetry = true;
        KemAssert.isTrue((model.getTargetId() > 0L ? 1 : 0) != 0, (String)"targetId must be not null");
        this.targetRetryModel = model;
        this.isAutoRetry = isAutoRetry;
    }

    @Override
    JsonHashMap getInput(TargetModel model) {
        return this.getSubscriberContext().getNodeIn().getOutput();
    }

    @Override
    NodeOutput getOutput(JsonHashMap input, TargetModel model) {
        return NodeOutput.of(Boolean.TRUE, NULL);
    }

    public TargetForEachDefinition forEach() {
        return new TargetForEachDefinition(this);
    }

    public boolean isRetry() {
        return this.isRetry;
    }

    public List<Long> getTargetIds() {
        return this.getTargetRetryModel() == null ? Collections.emptyList() : Collections.singletonList(this.getTargetRetryModel().getTargetId());
    }

    public int getRetrySeq() {
        return this.getTargetRetryModel() == null ? 1 : this.getTargetRetryModel().getRetrySeq();
    }

    public boolean isAutoRetry() {
        return this.isAutoRetry;
    }

    public TargetRetryModel getTargetRetryModel() {
        return this.targetRetryModel;
    }
}

