/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.definition;

import com.google.common.base.Stopwatch;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.kem.common.constants.LogStatus;
import kd.isc.kem.common.constants.NodeLogStatus;
import kd.isc.kem.common.util.CollectionUtil;
import kd.isc.kem.core.subscribe.definition.NodeType;
import kd.isc.kem.core.subscribe.definition.TargetDefinition;
import kd.isc.kem.core.subscribe.definition.TargetForEachDefinition;
import kd.isc.kem.core.subscribe.handler.LogHandler;
import kd.isc.kem.core.subscribe.handler.TargetRetryHandler;
import kd.isc.kem.core.subscribe.model.NodeLogModel;
import kd.isc.kem.core.subscribe.model.TargetResult;

public class TargetExecuteDefinition {
    private static final Log LOG = LogFactory.getLog(TargetExecuteDefinition.class);
    private final TargetDefinition targetDefinition;
    private final TargetForEachDefinition targetForEachDefinition;
    private TargetLog targetLog;

    public TargetExecuteDefinition(TargetDefinition targetDefinition, TargetForEachDefinition targetForEachDefinition) {
        this.targetDefinition = targetDefinition;
        this.targetForEachDefinition = targetForEachDefinition;
    }

    public TargetExecuteDefinition log() {
        this.targetLog = new TargetLog();
        return this;
    }

    public TargetExecuteDefinition log(BiConsumer<NodeLogModel, Boolean> consumer) {
        this.targetLog = new TargetLog(consumer);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TargetDefinition endTarget() {
        boolean isRetry = this.targetDefinition.isRetry();
        DynamicObject subscribe = BusinessDataServiceHelper.loadSingleFromCache((Object)this.targetDefinition.getSubscribeInfo().getSubId(), (String)"kem_subscribe");
        DynamicObjectCollection targetEntry = subscribe.getDynamicObjectCollection("target_entry");
        long subInstanceId = this.targetDefinition.getSubscribeInfo().getSubInstanceId();
        if (CollectionUtil.isEmpty((Collection)targetEntry)) {
            if (isRetry) {
                return this.targetDefinition;
            }
            LogHandler.updateLog(subInstanceId, LogStatus.Success);
            return this.targetDefinition;
        }
        LogStatus status = LogStatus.Success;
        try {
            for (int i = 0; i < targetEntry.size(); ++i) {
                DynamicObject target = (DynamicObject)targetEntry.get(i);
                long entryId = target.getLong("id");
                if (isRetry && !this.targetDefinition.getTargetIds().contains(entryId)) continue;
                NodeLogModel nodeLogModel = new NodeLogModel(subInstanceId, entryId, NodeType.TARGET, null, null, null, null, true, this.targetDefinition.getRetrySeq(), 0L);
                nodeLogModel.setTargetMsgId(isRetry ? this.targetDefinition.getTargetRetryModel().getMsgId() : this.targetDefinition.getSubscribeInfo().getSubInstanceId());
                nodeLogModel.setAutoRetry(this.targetDefinition.isAutoRetry());
                DynamicObject actionType = target.getDynamicObject("actiontype");
                nodeLogModel.setActionName("\u3010" + actionType.getString("name") + "\u3011" + target.getString("actionname"));
                nodeLogModel.setActionTypeId(actionType.getLong("id"));
                Stopwatch stopwatch = Stopwatch.createStarted();
                TargetResult executeResult = null;
                try {
                    executeResult = this.targetForEachDefinition.doExecute(target, this.targetDefinition.getSubscriberContext(), this.targetDefinition.getTargetRetryModel());
                    if (executeResult == null) continue;
                    nodeLogModel.setInput(executeResult.getInput());
                    nodeLogModel.setOutput(executeResult.getOutput());
                    if (!executeResult.isStatus()) {
                        throw executeResult.getException();
                    }
                    nodeLogModel.setNodeLogStatus(NodeLogStatus.Success);
                    if (LogStatus.Fail == status) {
                        status = LogStatus.Partial_Success;
                    }
                    nodeLogModel.setCost(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                    continue;
                }
                catch (Throwable e) {
                    nodeLogModel.setCost(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                    LOG.error("TargetExecuteDefinition.endTarget", e);
                    nodeLogModel.setNodeLogStatus(NodeLogStatus.Fail);
                    nodeLogModel.setException(e);
                    status = i == 0 ? LogStatus.Fail : (LogStatus.Success == status ? LogStatus.Partial_Success : status);
                    try {
                        if (!this.targetDefinition.isAutoRetry()) continue;
                        boolean bl = TargetRetryHandler.doRetry(target, this.targetDefinition.getSubscriberContext(), executeResult, this.targetDefinition.getRetrySeq());
                    }
                    catch (Exception ex) {
                        LOG.error("\u91cd\u8bd5\u5165\u961f\u5931\u8d25\uff1a", (Throwable)ex);
                    }
                    continue;
                }
                finally {
                    this.doLog(nodeLogModel, isRetry);
                }
            }
            return this.targetDefinition;
        }
        finally {
            try (DLock lock = DLock.create((String)("KemSubLog-" + subInstanceId));){
                lock.lock();
                if (isRetry) {
                    int successCount = LogHandler.getSuccessTargetNodeCount(subInstanceId);
                    status = successCount == 0 ? LogStatus.Fail : (successCount == targetEntry.size() ? LogStatus.Success : LogStatus.Partial_Success);
                }
                LogHandler.updateLog(subInstanceId, status);
            }
        }
    }

    private void doLog(NodeLogModel nodeLogModel, boolean isRetry) {
        if (this.targetLog != null) {
            this.targetLog.doAction(nodeLogModel, isRetry);
        }
    }

    static class TargetLog {
        private BiConsumer<NodeLogModel, Boolean> consumer;

        public TargetLog() {
        }

        public TargetLog(BiConsumer<NodeLogModel, Boolean> consumer) {
            this.consumer = consumer;
        }

        public void doAction(NodeLogModel nodeLogModel, boolean isRetry) {
            if (this.consumer != null) {
                this.consumer.accept(nodeLogModel, isRetry);
                return;
            }
            LogHandler.recordNodeLog(nodeLogModel, isRetry);
        }
    }
}

