/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.definition;

import com.fasterxml.jackson.databind.JsonNode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.kem.common.function.Function3;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.core.subscribe.definition.TargetDefinition;
import kd.isc.kem.core.subscribe.definition.TargetExecuteDefinition;
import kd.isc.kem.core.subscribe.handler.TargetHandle;
import kd.isc.kem.core.subscribe.model.JsonNodeExt;
import kd.isc.kem.core.subscribe.model.SubscriberContext;
import kd.isc.kem.core.subscribe.model.TargetResult;
import kd.isc.kem.core.subscribe.model.TargetRetryModel;

public class TargetForEachDefinition {
    private static final Log LOG = LogFactory.getLog(TargetForEachDefinition.class);
    private final TargetDefinition targetDefinition;
    private TargetExecute targetExecute;

    public TargetForEachDefinition(TargetDefinition targetDefinition) {
        this.targetDefinition = targetDefinition;
    }

    public TargetExecuteDefinition execute() {
        this.targetExecute = new TargetExecute();
        return new TargetExecuteDefinition(this.targetDefinition, this);
    }

    public TargetExecuteDefinition execute(Function3<DynamicObject, JsonHashMap, TargetRetryModel, TargetResult> function) {
        this.targetExecute = new TargetExecute(function);
        return new TargetExecuteDefinition(this.targetDefinition, this);
    }

    protected TargetResult doExecute(DynamicObject target, SubscriberContext context, TargetRetryModel model) {
        return this.targetExecute == null ? null : this.targetExecute.doAction(target, context, model);
    }

    static class TargetExecute {
        private Function3<DynamicObject, JsonHashMap, TargetRetryModel, TargetResult> function;

        public TargetExecute() {
        }

        public TargetExecute(Function3<DynamicObject, JsonHashMap, TargetRetryModel, TargetResult> function) {
            this.function = function;
        }

        public TargetResult doAction(DynamicObject target, SubscriberContext context, TargetRetryModel model) {
            if (this.function != null) {
                return (TargetResult)this.function.apply((Object)target, (Object)context.getNodeIn().getOutput(), (Object)model);
            }
            String actionConfig = target.getString("actionconfig_tag");
            JsonNode targetConfig = JacksonUtil.readTree((String)actionConfig);
            TargetResult handle = TargetHandle.handle(JsonNodeExt.of(targetConfig), JsonNodeExt.of(JacksonUtil.valueToTree((Object)context.getNodeIn().getOutput())), model, context.getInfo());
            return handle;
        }
    }
}

