/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.handler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.NetAddressUtils;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.kem.common.constants.Constants;
import kd.isc.kem.common.constants.LogStatus;
import kd.isc.kem.common.constants.NodeLogStatus;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.util.CollectionUtil;
import kd.isc.kem.common.util.ConfigHelper;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.common.util.KemAssert;
import kd.isc.kem.common.util.LogUtil;
import kd.isc.kem.core.event.Event;
import kd.isc.kem.core.exception.KemCoreError;
import kd.isc.kem.core.subscribe.definition.NodeType;
import kd.isc.kem.core.subscribe.model.NodeLogModel;
import kd.isc.kem.core.subscribe.model.SubscribeInfo;

public class LogHandler {
    private static final Log LOG = LogFactory.getLog(LogHandler.class);

    public static long initLog(SubscribeInfo info, LogStatus logStatus, Throwable e) {
        LogUtil.info((Log)LOG, (String)"SubInstanceId = {}", (Object[])new Object[]{info.getSubInstanceId()});
        try {
            DynamicObject sub = BusinessDataServiceHelper.loadSingleFromCache((Object)info.getSubId(), (String)"kem_subscribe");
            KemAssert.notNull((Object)sub, (String)("subId\uff1a" + info.getSubId() + " not exist"));
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"kem_log");
            log.set("id", (Object)info.getSubInstanceId());
            log.set("cost", (Object)0);
            log.set("status", (Object)logStatus.getCode());
            log.set("subid", (Object)info.getSubId());
            log.set("subnumber", (Object)info.getSubNumber());
            log.set("subname", (Object)sub.getString("name"));
            log.set("datasourceid", (Object)sub.getString("eventdatasourceid.id"));
            log.set("datasourcenumber", (Object)sub.getString("eventdatasourceid.name"));
            log.set("eventid", (Object)info.getEvent().getEventId());
            log.set("eventnumber", (Object)info.getEvent().getEventNumber());
            if (Event.isCronEvent(info.getEvent())) {
                log.set("eventname", (Object)info.getEvent().getData().getString("cronExpress"));
            } else {
                DynamicObject event = BusinessDataServiceHelper.loadSingleFromCache((Object)info.getEvent().getEventId(), (String)"kem_event");
                KemAssert.notNull((Object)event, (String)("eventId\uff1a" + info.getEvent().getEventId() + " not exist"));
                log.set("eventname", (Object)event.getString("name"));
            }
            log.set("msgid", (Object)info.getSubInstanceId());
            log.set("srcsubtype", sub.get("srcsubtype"));
            log.set("actionname", (Object)sub.getDynamicObjectCollection("target_entry").stream().map(it -> it.getString("actionname")).collect(Collectors.joining(",")));
            log.set("username", (Object)RequestContext.get().getUserName());
            long[] insert = LogORM.create().insert(Collections.singletonList(log));
            return insert[0];
        }
        catch (Throwable ex) {
            LOG.error("KEM_LOG:: SubInstanceId = " + info.getSubInstanceId(), ex);
            return 0L;
        }
    }

    public static int updateLog(long subInstanceId, LogStatus logStatus) {
        LogUtil.info((Log)LOG, (String)"SubInstanceId = {}, logStatus={}", (Object[])new Object[]{subInstanceId, logStatus});
        try {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"kem_log");
            HashSet fields = new HashSet(type.getAllFields().keySet());
            fields.add(type.getPrimaryKey().getName());
            QFilter filter = new QFilter("id", "=", (Object)subInstanceId);
            DynamicObjectCollection objects = null;
            LogORM logORM = LogORM.create();
            for (int count = 0; count <= 20 && CollectionUtil.isEmpty((Collection)(objects = logORM.query("kem_log", String.join((CharSequence)",", fields), new QFilter[]{filter}, 10, 0))); ++count) {
                try {
                    TimeUnit.MILLISECONDS.sleep(300L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (objects == null || CollectionUtil.isEmpty(objects)) {
                throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"KEM_LOG:log not found"});
            }
            DynamicObject log = (DynamicObject)objects.get(0);
            log.set("status", (Object)logStatus.getCode());
            return logORM.update(Collections.singletonList(log));
        }
        catch (Throwable e) {
            LOG.error("KEM_LOG:: SubInstanceId = " + subInstanceId + ", logStatus=" + logStatus, e);
            return 0;
        }
    }

    public static void recordNodeLog(NodeLogModel model, boolean isRetry) {
        try {
            int maxLogSize = LogHandler.getMaxLogSize();
            DynamicObject nodeLog = BusinessDataServiceHelper.newDynamicObject((String)"kem_nodelog");
            nodeLog.set("id", (Object)ID.genLongId());
            nodeLog.set("logid", (Object)model.getSubInstanceId());
            nodeLog.set("nodetype", (Object)String.valueOf(model.getNodeType().getCode()));
            nodeLog.set("cost", (Object)model.getCost());
            nodeLog.set("status", (Object)model.getNodeLogStatus().getCode());
            nodeLog.set("errorcode", (Object)StringUtil.trim((String)LogHandler.getErrorCode(model.getException()), (int)40));
            nodeLog.set("nodeid", (Object)model.getNodeId());
            String inputJson = model.isRecordInput() ? LogHandler.getJson(model.getInput()) : "";
            nodeLog.set("input_tag", (Object)inputJson);
            nodeLog.set("output_tag", (Object)StringUtil.trim((String)LogHandler.getJson(model.getOutput()), (int)maxLogSize));
            String exMsg = LogHandler.getExMsg(model.getException());
            long msgId = NodeType.TARGET == model.getNodeType() ? model.getTargetMsgId().longValue() : model.getSubInstanceId();
            String errMsg = "InstanceId\uff1a" + Instance.getInstanceId() + "\r\nTraceId\uff1a" + RequestContext.get().getTraceId() + "\r\nmsgId\uff1a" + msgId + "\r\n\r\n" + StringUtil.trim((String)exMsg, (int)maxLogSize);
            nodeLog.set("message_tag", (Object)errMsg);
            nodeLog.set("message", model.getException() != null ? StringUtil.trim((String)StringUtil.getMessage((Throwable)model.getException()), (int)200) : null);
            String hostIp = null;
            try {
                hostIp = RequestContext.get().getLoginIP();
                if (StringUtil.isEmpty((String)hostIp)) {
                    hostIp = NetAddressUtils.getLocalIpAddress();
                }
            }
            catch (Throwable e) {
                LOG.error("KEM_LOG:", e);
            }
            nodeLog.set("hostip", (Object)StringUtil.trim((String)hostIp, (int)40));
            String uName = StringUtil.trim((String)RequestContext.get().getUserName(), (int)50);
            if (isRetry && StringUtil.isEmpty((String)uName)) {
                uName = ResManager.loadKDString((String)"\u81ea\u52a8\u91cd\u8bd5", (String)"LogHandle_0", (String)"isc-kem-core", (Object[])new Object[0]);
            }
            nodeLog.set("username", (Object)uName);
            nodeLog.set("opdesc", (Object)StringUtil.trim((String)model.getActionName(), (int)200));
            nodeLog.set("actiontypeid", (Object)model.getActionTypeId());
            nodeLog.set("retrytype", (Object)(model.isAutoRetry() ? 0 : 1));
            if (NodeType.TARGET == model.getNodeType()) {
                try (DLock lock = DLock.create((String)("KemSubNodeLog-" + RequestContext.get().getAccountId() + "-" + model.getSubInstanceId()));){
                    lock.lock();
                    String sql = "select max(fretryseq) from t_kem_nodelog where flogid = " + model.getSubInstanceId() + " and fnodeid = " + model.getNodeId();
                    int max = (Integer)DB.query((DBRoute)Constants.KemDBRoute.DB_LOG_ROUTE, (String)sql, rs -> {
                        if (rs.next()) {
                            return rs.getInt(1);
                        }
                        return 0;
                    });
                    nodeLog.set("retryseq", (Object)(max + 1));
                    LogORM.create().insert(Collections.singletonList(nodeLog));
                }
            } else {
                nodeLog.set("retryseq", (Object)1);
                LogORM.create().insert(Collections.singletonList(nodeLog));
            }
            if (NodeLogStatus.Fail == model.getNodeLogStatus() && NodeType.TARGET != model.getNodeType()) {
                LogHandler.updateLog(model.getSubInstanceId(), LogStatus.Fail);
            }
        }
        catch (Throwable ex) {
            LOG.error("KEM_LOG:", ex);
        }
    }

    public static String getExMsg(Throwable e) {
        if (e == null) {
            return "";
        }
        try {
            return StringUtil.toString((Throwable)e);
        }
        catch (Throwable ex) {
            return StringUtil.getMessage((Throwable)ex);
        }
    }

    private static String getJson(Object obj) {
        if (obj instanceof String && JacksonUtil.isJson((String)((String)obj))) {
            return (String)obj;
        }
        try {
            String result = JacksonUtil.writeValueAsString((Object)obj);
            return result == null ? "" : result;
        }
        catch (Throwable e) {
            return obj.toString();
        }
    }

    private static String getErrorCode(Throwable exception) {
        if (exception == null) {
            return null;
        }
        if (exception instanceof KDException) {
            ErrorCode errorCode = ((KDException)exception).getErrorCode();
            return errorCode == null ? null : errorCode.getCode();
        }
        return null;
    }

    public static int getSuccessTargetNodeCount(long subInstanceId) {
        QFilter filter = new QFilter("logid", "=", (Object)subInstanceId).and(new QFilter("nodetype", "=", (Object)String.valueOf(NodeType.TARGET.getCode())).and(new QFilter("status", "=", (Object)String.valueOf(NodeLogStatus.Success.getCode()))));
        try (DataSet dataSet = LogORM.create().queryDataSet("kem_nodelog", "nodeid", new QFilter[]{filter}, 10, 0);){
            int n = dataSet.count("nodeid", true);
            return n;
        }
    }

    public static int getMaxLogSize() {
        try {
            String str = ConfigHelper.getSystemParam((String)"kem_log_maxlength", (String)String.valueOf(10240));
            int value = Integer.parseInt(str);
            return value;
        }
        catch (Throwable e) {
            LOG.error("KEM_LOG:getMaxLogSize", e);
            return 10240;
        }
    }
}

