/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.handler;

import java.util.Arrays;
import java.util.Date;
import kd.isc.kem.common.constants.Retry;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.util.DateUtil;
import kd.isc.kem.core.exception.KemCoreError;
import kd.isc.kem.core.queue.KemQueueFactory;
import kd.isc.kem.core.queue.KemQueuePriority;
import kd.isc.kem.core.queue.KemQueueType;
import kd.isc.kem.core.subscribe.model.SubscriberContext;
import kd.isc.kem.core.subscribe.model.TargetRetryModel;
import org.apache.commons.lang3.RandomUtils;

public enum RetryType {
    RETRIES_3(Retry.RETRIES_3.getCode()){

        @Override
        public boolean doRetry(TargetRetryModel model, SubscriberContext context) {
            if (model.getRetrySeq() > 4) {
                return false;
            }
            int n = model.getRetrySeq() - 2;
            int amount = (1 << n) * 60 + RandomUtils.nextInt((int)0, (int)21) - 10;
            KemQueueFactory.getQueue(model.getInfo().getEvent().getEventNumber()).publish(model.getMsgId(), model.getInfo().getEvent().getEventNumber(), KemQueueType.Action, KemQueuePriority.Normal, DateUtil.addSeconds((Date)new Date(), (int)amount), model.getRetrySeq(), model, model.getInfo().getSubId(), model.getInfo().getSubInstanceId(), model.getTargetName());
            return true;
        }
    }
    ,
    NO_RETRY(Retry.NO_RETRY.getCode());

    private final int code;

    private RetryType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static boolean retry(int code, TargetRetryModel model, SubscriberContext context) {
        RetryType retryType = RetryType.getRetryType(code);
        return retryType.doRetry(model, context);
    }

    public boolean doRetry(TargetRetryModel model, SubscriberContext context) {
        return false;
    }

    private static RetryType getRetryType(int code) {
        return Arrays.stream(RetryType.values()).filter(it -> it.getCode() == code).findFirst().orElseThrow(() -> new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"RetryType code \u201c" + code + "\u201d is not supported"}));
    }
}

