/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.handler;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.permission.util.PhoneValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.Pair;
import kd.isc.iscb.platform.core.api.parsers.model.IscFieldType;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.feature.sql.SqlRuntime;
import kd.isc.kem.common.encrypt.EncryptModel;
import kd.isc.kem.common.encrypt.KemEncryptType;
import kd.isc.kem.common.encrypt.KemSignEncryptHelper;
import kd.isc.kem.common.encrypt.KemSignType;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.model.KemMessageInfo;
import kd.isc.kem.common.spi.KemSpiHelper;
import kd.isc.kem.common.util.CollectionUtil;
import kd.isc.kem.common.util.HttpUtil;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.common.util.KHashMap;
import kd.isc.kem.common.util.KemJsonNodeType;
import kd.isc.kem.common.util.MapSorter;
import kd.isc.kem.common.util.SerializationUtils;
import kd.isc.kem.common.util.TimeLimiterHelper;
import kd.isc.kem.core.datasource.helper.IscApiHelper;
import kd.isc.kem.core.datasource.helper.IscMQHelper;
import kd.isc.kem.core.datasource.helper.IscServiceFlowHelper;
import kd.isc.kem.core.datasource.helper.MessageHelper;
import kd.isc.kem.core.exception.KemCoreError;
import kd.isc.kem.core.script.KemExprUtil;
import kd.isc.kem.core.script.KemScript;
import kd.isc.kem.core.script.ScriptUsageScene;
import kd.isc.kem.core.subscribe.model.JsonNodeExt;
import kd.isc.kem.core.subscribe.model.ServiceFlowModel;
import kd.isc.kem.core.subscribe.model.SubscribeInfo;
import kd.isc.kem.core.subscribe.model.TargetResult;
import kd.isc.kem.core.subscribe.model.TargetRetryModel;
import org.hibernate.validator.internal.constraintvalidators.hv.EmailValidator;

public enum TargetHandle {
    API("restapi"){

        @Override
        public TargetResult doHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, TargetRetryModel model, SubscribeInfo info) {
            return TargetHandle.apiHandle(targetConfig, nodeIn, info);
        }
    }
    ,
    MQ("mq"){

        @Override
        public TargetResult doHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, TargetRetryModel model, SubscribeInfo info) {
            return TargetHandle.mqHandle(targetConfig, nodeIn, info);
        }
    }
    ,
    ISC_SF("iscsf"){

        @Override
        TargetResult doHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, TargetRetryModel model, SubscribeInfo info) {
            return TargetHandle.iscSfHandle(targetConfig, nodeIn, info);
        }
    }
    ,
    MSG("msg"){

        @Override
        TargetResult doHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, TargetRetryModel model, SubscribeInfo info) {
            return TargetHandle.msgHandle(targetConfig, nodeIn, info);
        }
    }
    ,
    ISC_SCRIPT("script"){

        @Override
        TargetResult doHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, TargetRetryModel model, SubscribeInfo info) {
            return TargetHandle.scriptHandle(targetConfig, nodeIn, info);
        }
    }
    ,
    WEB_HOOK("webhook"){

        @Override
        TargetResult doHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, TargetRetryModel model, SubscribeInfo info) {
            return TargetHandle.webhookHandle(targetConfig, nodeIn, info);
        }
    }
    ,
    PBC("pbc"){

        @Override
        TargetResult doHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, TargetRetryModel model, SubscribeInfo info) {
            return TargetHandle.pbcHandle(targetConfig, nodeIn);
        }
    };

    public static final String $_QUERY_STRING = "$queryString";
    public static final String $_BODY = "$body";
    public static final String $_HEADER = "$header";
    public static final String ORIGINAL_DATA = "originalData";
    public static final String KEM_LOG_DETAIL = "kem_log_detail";
    public static final String ENCRYPT = "encrypt";
    public static final String X_KEM_SIGNATURE = "x-kem-signature";
    public static final String X_KEM_REQUEST_NONCE = "x-kem-request-nonce";
    public static final String X_KEM_REQUEST_TIMESTAMP = "x-kem-request-timestamp";
    public static final String X_KEM_ENCRYPT_IV = "x-kem-encrypt-iv";
    public static final String SIGN_SEC_KY = "signsecretkey";
    public static final String SIGN_TYPE = "signtype";
    public static final String ENCRYPT_SEC_KY = "encryptsecretkey";
    public static final String ENCRYPT_TYPE = "encrypttype";
    public static final String PARAM_NAME = "paramName";
    public static final String PARAM_VALUE = "paramValue";
    private final String code;

    private static TargetResult apiHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, SubscribeInfo info) {
        TargetResult targetResult = new TargetResult(nodeIn);
        JsonNode jsonNode = nodeIn.getJsonNode();
        HashMap<String, Object> body = new HashMap(16);
        HashMap<String, Object> header = new HashMap(16);
        HashMap<String, Object> queryString = new HashMap(16);
        try {
            List<JsonNodeExt> bodyParams = TargetHandle.toList(targetConfig.withArray("body"));
            List<JsonNodeExt> reqHeaders = TargetHandle.toList(targetConfig.withArray("header"));
            List<JsonNodeExt> urlParams = TargetHandle.toList(targetConfig.withArray("queryString"));
            header = TargetHandle.getHeader(reqHeaders, nodeIn, info);
            body = TargetHandle.getBody(bodyParams, nodeIn, info);
            queryString = TargetHandle.getQueryString(urlParams, nodeIn, info);
            HashMap<String, Object> ctx = KemScript.getCtx(TargetHandle.getMapByJsonNode(jsonNode), info);
            ctx.put($_HEADER, header);
            ctx.put($_BODY, body);
            ctx.put($_QUERY_STRING, queryString);
            String script = targetConfig.get("script").asText();
            if (!kd.isc.kem.common.util.StringUtil.isBlank((CharSequence)script)) {
                try {
                    ctx.putAll((Map<String, Object>)ScriptUsageScene.Script.extFunctions());
                    KemScript.eval(script, ctx);
                }
                catch (Exception e) {
                    throw new KemException((Throwable)e, (KemErrorTemplate)KemCoreError.ScriptError, new Object[]{ResManager.loadKDString((String)"\u8d4b\u503c\u811a\u672c\u6267\u884c\u9519\u8bef\uff1a", (String)"TargetHandle_2", (String)"isc-kem-core", (Object[])new Object[0])});
                }
                finally {
                    SqlRuntime.setCurrent(null);
                }
            }
            long targetId = targetConfig.get("targetId").asLong();
            DynamicObject api = BusinessDataServiceHelper.loadSingleFromCache((Object)targetId, (String)"isc_apic_webapi", (String)"number");
            HashMap<String, Object> bodyMap = TargetHandle.getNewHashMap(body);
            HashMap<String, Object> headerMap = TargetHandle.getNewHashMap(header);
            HashMap<String, Object> queryStringMap = TargetHandle.getNewHashMap(queryString);
            Callable<Object> callable = () -> IscApiHelper.invokeApi(api.getString("number"), bodyMap, headerMap, queryStringMap, targetConfig.get("actiondatasourceid").asText());
            Object output = TimeLimiterHelper.callTargetWithTimeout(callable, (long)TimeLimiterHelper.getTargetWebapiTimeoutSeconds(), (TimeUnit)TimeUnit.SECONDS);
            targetResult.setOutput(output);
            ctx.put("$result", TargetHandle.getMapByObject(output));
            TargetHandle.checkAssert(targetConfig.get("assertion").asText(), TargetHandle.getNewHashMap(ctx));
            targetResult.setStatus(true);
        }
        catch (Exception e) {
            targetResult.setStatus(false);
            targetResult.setException(e);
        }
        targetResult.getInput().getData().set("body", body).set("header", header).set("queryString", queryString);
        return targetResult;
    }

    private static TargetResult mqHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, SubscribeInfo info) {
        TargetResult targetResult = new TargetResult(nodeIn);
        HashMap<String, Object> input = null;
        try {
            long targetId = targetConfig.get("targetId").asLong();
            DynamicObject publishTopic = BusinessDataServiceHelper.loadSingleFromCache((Object)targetId, (String)"isc_mq_publisher");
            input = TargetHandle.getBody(null, nodeIn, info);
            long id = IscMQHelper.send(publishTopic, JacksonUtil.writeValueAsString(input));
            targetResult.setStatus(true);
            targetResult.setOutput(id);
        }
        catch (Exception e) {
            targetResult.setStatus(false);
            targetResult.setException(e);
        }
        targetResult.getInput().getData().set("message", input);
        return targetResult;
    }

    private static TargetResult msgHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, SubscribeInfo info) {
        TargetResult targetResult = new TargetResult(nodeIn);
        KemMessageInfo message = null;
        HashMap<String, Object> ctx = null;
        try {
            String msgChannel = targetConfig.get("msg_channel").asText();
            String msgTitle = targetConfig.get("msg_title").asText();
            String msgContent = targetConfig.get("msg_content").asText();
            message = new KemMessageInfo();
            message.setMessageTag((ILocaleString)new LocaleString(StringUtil.trim((String)(ResManager.loadKDString((String)"[KEM]", (String)"TargetHandle_1", (String)"isc-kem-core", (Object[])new Object[0]) + info.getSubNumber()), (int)50)));
            message.setMessageSenderName((ILocaleString)new LocaleString(ResManager.loadKDString((String)"[KEM]", (String)"TargetHandle_1", (String)"isc-kem-core", (Object[])new Object[0]) + info.getSubInstanceId()));
            message.setSource("KEM");
            message.setEntityNumber("kem_subscribe");
            message.setBizDataId(Long.valueOf(info.getSubInstanceId()));
            message.setNestAppid("KEM");
            message.setNotifyType(msgChannel);
            ctx = KemScript.getCtx(TargetHandle.getMapByJsonNode(nodeIn.getJsonNode()), info);
            msgTitle = TargetHandle.format(msgTitle, ctx);
            message.setMessageTitle((ILocaleString)new LocaleString(msgTitle));
            msgContent = TargetHandle.format(msgContent, ctx);
            message.setMessageContent((ILocaleString)new LocaleString(msgContent));
            String msgUserType = targetConfig.orElse("msg_user_type", (JsonNode)new TextNode("0")).asText();
            if ("0".equals(msgUserType)) {
                HashSet<Long> userIds = new HashSet<Long>(8);
                ArrayNode msgUser = targetConfig.withArray("msg_user");
                if (msgUser != null) {
                    Iterator elements = msgUser.elements();
                    while (elements.hasNext()) {
                        userIds.add(((JsonNode)elements.next()).asLong());
                    }
                }
                String paramUser = targetConfig.orElse("param_user", (JsonNode)new TextNode(null)).asText();
                Set<Long> userSet = TargetHandle.getParamUser(paramUser, nodeIn.getJsonNode(), info, Long.class, null, ResManager.loadKDString((String)"\u63a5\u6536\u4eba\u53d8\u91cf\uff1a", (String)"TargetHandle_4", (String)"isc-kem-core", (Object[])new Object[0]));
                userIds.addAll(userSet);
                message.setUserIds(new ArrayList(userIds));
            } else if ("1".equals(msgUserType)) {
                HashMap<String, ArrayList<String>> param;
                String paramUser = targetConfig.orElse("param_user_ext", (JsonNode)new TextNode(null)).asText();
                Set<String> set = TargetHandle.getParamUser(paramUser, nodeIn.getJsonNode(), info, String.class, message.getNotifyType(), ResManager.loadKDString((String)"\u63a5\u6536\u4eba\u53d8\u91cf\uff1a", (String)"TargetHandle_4", (String)"isc-kem-core", (Object[])new Object[0]));
                String msgUserExt = targetConfig.orElse("msg_user_ext", (JsonNode)new TextNode(null)).asText();
                if ("sms".equals(message.getNotifyType())) {
                    param = new HashMap<String, ArrayList<String>>(1);
                    set.addAll(TargetHandle.getPhoneOrEmail("userphone", msgUserExt, message.getNotifyType()));
                    param.put("phone", new ArrayList<String>(set));
                } else if ("email".equals(message.getNotifyType())) {
                    param = new HashMap(1);
                    set.addAll(TargetHandle.getPhoneOrEmail("useremail", msgUserExt, message.getNotifyType()));
                    param.put("email", new ArrayList<String>(set));
                } else {
                    throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"NotifyType: " + message.getNotifyType() + " not supported non-Ierp user."});
                }
                message.setParams(param);
                message.setUserIds(null);
            } else {
                throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"msg_user_type: " + msgUserType + " not supported."});
            }
            message.setContentUrl(TargetHandle.getUrlInfo(info.getSubInstanceId(), true));
            Map<String, Object> msgResult = MessageHelper.sendMessage(message);
            Boolean status = (Boolean)ObjectConverter.convert((Object)msgResult.get("success"), Boolean.class, (boolean)false);
            if (!status.booleanValue()) {
                throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{msgResult.toString()});
            }
            targetResult.setStatus(true);
            targetResult.setOutput(msgResult);
        }
        catch (Exception e) {
            targetResult.setStatus(false);
            targetResult.setException(e);
        }
        targetResult.getInput().getData().set("message", message);
        return targetResult;
    }

    private static Set<String> getPhoneOrEmail(String fieldName, String msgUserExt, String notifyType) {
        if (kd.isc.kem.common.util.StringUtil.isBlank((CharSequence)msgUserExt)) {
            return Collections.emptySet();
        }
        ArrayNode arrayNode = (ArrayNode)JacksonUtil.readTree((String)msgUserExt);
        Set<String> values = arrayNode.findValuesAsText(fieldName).stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        return values;
    }

    private static <T> Set<T> getParamUser(String paramUser, JsonNode node, SubscribeInfo info, Class<T> clz, String notifyType, String title) {
        HashSet<Object> set = new HashSet<Object>(8);
        if (kd.isc.kem.common.util.StringUtil.isBlank((CharSequence)paramUser)) {
            return set;
        }
        String[] scriptUsers = paramUser.split(",");
        HashMap data = (HashMap)JacksonUtil.convertValue((Object)node, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        HashMap<String, Object> ctx1 = KemScript.getCtx(data, info);
        for (String scriptUser : scriptUsers) {
            if (kd.isc.kem.common.util.StringUtil.isBlank((CharSequence)scriptUser)) continue;
            try {
                Object eval = KemScript.eval(scriptUser, (HashMap)SerializationUtils.clone(ctx1));
                Object value = ObjectConverter.convert((Object)eval, clz, (boolean)true);
                if (value == null) continue;
                if (String.class == clz) {
                    if ("sms".equals(notifyType)) {
                        new PhoneValidator(value.toString(), false).check();
                    } else if ("email".equals(notifyType) && !new EmailValidator().isValid((CharSequence)value.toString(), null)) {
                        throw new KDBizException("not a well-formed email address");
                    }
                }
                set.add(value);
            }
            catch (Exception e) {
                throw new KemException((Throwable)e, (KemErrorTemplate)KemCoreError.CoreError, new Object[]{title + scriptUser + "\uff0c Illegal parameters."});
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TargetResult scriptHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, SubscribeInfo info) {
        TargetResult targetResult = new TargetResult(nodeIn);
        HashMap<String, Object> inputData = null;
        try {
            String script = targetConfig.get("script").asText();
            inputData = TargetHandle.getMapByJsonNode(nodeIn.getJsonNode());
            HashMap<String, Object> ctx = KemScript.getCtx(inputData, info);
            ctx.putAll((Map<String, Object>)ScriptUsageScene.Script_Service.extFunctions());
            Object result = KemScript.eval(script, ctx);
            targetResult.setStatus(true);
            targetResult.setOutput(result);
        }
        catch (Exception e) {
            targetResult.setStatus(false);
            targetResult.setException(e);
        }
        finally {
            SqlRuntime.setCurrent(null);
        }
        targetResult.getInput().getData().set(ORIGINAL_DATA, inputData);
        return targetResult;
    }

    private static TargetResult webhookHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, SubscribeInfo info) {
        TargetResult targetResult = new TargetResult(nodeIn);
        KHashMap inputData = null;
        String signBody = null;
        String payload = null;
        HashMap<String, Object> header = null;
        try {
            String signTypeCode;
            KemSignType signType;
            String url = targetConfig.get("url").asText();
            HashMap<String, Object> data = TargetHandle.getMapByJsonNode(nodeIn.getJsonNode());
            inputData = KHashMap.create().set((Object)"entityNumber", data.remove("_$ENTITY_NUMBER")).set((Object)"operation", data.remove("_$OPERATION")).set((Object)"data", data).set((Object)"eventNumber", (Object)info.getEvent().getEventNumber()).set((Object)"msgId", (Object)info.getSubInstanceId());
            payload = JacksonUtil.writeValueAsString2((Object)MapSorter.sortNestedMapByKey((Map)inputData));
            header = new HashMap<String, Object>(4);
            String encryptTypeCode = targetConfig.orElse(ENCRYPT_TYPE, (JsonNode)new TextNode(null)).asText();
            if (kd.isc.kem.common.util.StringUtil.isNotBlank((CharSequence)encryptTypeCode) && !"0".equals(encryptTypeCode.trim())) {
                String encryptKey = targetConfig.get(ENCRYPT_SEC_KY).asText();
                if (kd.isc.kem.common.util.StringUtil.isBlank((CharSequence)encryptKey)) {
                    throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"encrypt_key is empty"});
                }
                EncryptModel encryptModel = KemEncryptType.getEncryptType((String)encryptTypeCode).encryptBase64(payload, KemSignEncryptHelper.decode((String)encryptKey));
                header.put(X_KEM_ENCRYPT_IV, encryptModel.getIv());
                payload = JacksonUtil.writeValueAsString2((Object)KHashMap.create().set((Object)ENCRYPT, encryptModel.getEncrypt()));
            }
            if (KemSignType.UNSIGN != (signType = KemSignType.getSignType((String)(signTypeCode = targetConfig.orElseGet(SIGN_TYPE, () -> new TextNode(KemSignType.UNSIGN.getCode())).asText())))) {
                String signKey = targetConfig.orElse(SIGN_SEC_KY, (JsonNode)new TextNode(null)).asText();
                if (kd.isc.kem.common.util.StringUtil.isBlank((CharSequence)signKey)) {
                    throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{signType + " sign_key must not be null"});
                }
                String timestamp = String.valueOf(System.currentTimeMillis());
                String nonce = UUID.randomUUID().toString();
                signBody = payload;
                String sha256Sign = signType.sign(KemSignEncryptHelper.decode((String)signKey), timestamp, nonce, signBody);
                header.put(X_KEM_REQUEST_TIMESTAMP, timestamp);
                header.put(X_KEM_REQUEST_NONCE, nonce);
                header.put(X_KEM_SIGNATURE, sha256Sign);
            }
            String result = HttpUtil.postData((String)url, (String)payload, TargetHandle.getNewHashMap(header));
            JsonNode output = JacksonUtil.readTree((String)result);
            targetResult.setOutput(output);
            HashMap<String, Object> ctx = KemScript.getCtx((Map)((Object)SerializationUtils.clone(data)), info);
            ctx.put("$result", JacksonUtil.treeToValue((TreeNode)output, Object.class));
            TargetHandle.checkAssert(targetConfig.orElse("request_script", (JsonNode)new TextNode(null)).asText(), TargetHandle.getNewHashMap(ctx));
            targetResult.setStatus(true);
        }
        catch (Exception e) {
            targetResult.setStatus(false);
            targetResult.setException(e);
        }
        targetResult.getInput().getData().set("requestBody", payload).set("requestHeader", header).set("signBody", signBody).set(ORIGINAL_DATA, inputData);
        return targetResult;
    }

    private static TargetResult pbcHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn) {
        TargetResult targetResult = new TargetResult(nodeIn);
        JsonNode jsonNode = nodeIn.getJsonNode();
        HashMap params = new HashMap(16);
        try {
            long defineId = targetConfig.get("pbc_flow").asLong();
            HashMap<String, Object> data = TargetHandle.getMapByJsonNode(jsonNode);
            long jobId = KemSpiHelper.getPbcFlowSpi().start(defineId, TargetHandle.getNewHashMap(data));
            targetResult.setStatus(true);
            targetResult.setOutput(jobId);
        }
        catch (Exception e) {
            targetResult.setStatus(false);
            targetResult.setException(e);
        }
        targetResult.getInput().getData().set("params", params);
        return targetResult;
    }

    private static String format(String script, HashMap<String, Object> ctx) {
        if (kd.isc.kem.common.util.StringUtil.isBlank((CharSequence)script)) {
            return "";
        }
        return Format.parse((String)script, new HashMap(1)).translate((Map)((Object)SerializationUtils.clone(ctx)));
    }

    private static String getUrlInfo(long pkId, boolean isModal) {
        StringBuilder url = new StringBuilder();
        String domain = UrlService.getDomainContextUrl();
        url.append(domain).append("?#/dform?formId=").append(KEM_LOG_DETAIL).append("&Id=").append(pkId);
        return url.toString();
    }

    protected static List<JsonNodeExt> toList(ArrayNode arrayNode) {
        if (arrayNode == null || arrayNode.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JsonNodeExt> list = new ArrayList<JsonNodeExt>(arrayNode.size());
        Iterator elements = arrayNode.elements();
        while (elements.hasNext()) {
            list.add(JsonNodeExt.of((JsonNode)elements.next()));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TargetResult iscSfHandle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, SubscribeInfo info) {
        TargetResult targetResult = new TargetResult(nodeIn);
        JsonNode jsonNode = nodeIn.getJsonNode();
        HashMap<String, Object> params = new HashMap(16);
        try {
            long defineId = targetConfig.get("service_flow").asLong();
            IscServiceFlowHelper.checkServiceFlowEnabled(defineId);
            List<JsonNodeExt> paramEntry = TargetHandle.toList(targetConfig.withArray("paramEntry"));
            params = TargetHandle.getBody(paramEntry, nodeIn, info);
            String script = targetConfig.get("script").asText();
            if (!kd.isc.kem.common.util.StringUtil.isBlank((CharSequence)script)) {
                HashMap<String, Object> ctx = KemScript.getCtx(TargetHandle.getMapByJsonNode(jsonNode), info);
                ctx.put("$param", params);
                ctx.putAll((Map<String, Object>)ScriptUsageScene.Script.extFunctions());
                KemScript.eval(script, ctx);
            }
            long flowId = ServiceFlowParser.findReleasedFlowId((long)defineId);
            ServiceFlowModel serviceFlowModel = new ServiceFlowModel();
            serviceFlowModel.setNoProcInst(targetConfig.get("no_proc_inst").asBoolean());
            serviceFlowModel.setAsync(targetConfig.get("asyn").asBoolean());
            Map<String, Object> output = IscServiceFlowHelper.invokeSf(flowId, TargetHandle.getNewHashMap(params), serviceFlowModel);
            targetResult.setStatus(true);
            targetResult.setOutput(output);
        }
        catch (Exception e) {
            targetResult.setStatus(false);
            targetResult.setException(e);
        }
        finally {
            SqlRuntime.setCurrent(null);
        }
        targetResult.getInput().getData().set("param", params);
        return targetResult;
    }

    private static void checkAssert(String assertScript, HashMap<String, Object> ctx) {
        if (kd.isc.kem.common.util.StringUtil.isNotBlank((CharSequence)assertScript)) {
            try {
                KemScript.eval(assertScript, ctx);
            }
            catch (Exception e) {
                throw new KemException((Throwable)e, (KemErrorTemplate)KemCoreError.ScriptError, new Object[]{ResManager.loadKDString((String)"\u65ad\u8a00\u811a\u672c\u6267\u884c\u9519\u8bef\uff1a", (String)"TargetHandle_3", (String)"isc-kem-core", (Object[])new Object[0])});
            }
        }
    }

    private static HashMap<String, Object> getNewHashMap(HashMap<String, Object> map) {
        if (map == null) {
            return new HashMap<String, Object>(1);
        }
        return (HashMap)SerializationUtils.clone(map);
    }

    public static HashMap<String, Object> getMapByObject(Object obj) {
        if (obj == null) {
            return new HashMap<String, Object>(1);
        }
        if (obj instanceof String) {
            return (HashMap)JacksonUtil.readValue((String)((String)obj), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        return (HashMap)JacksonUtil.convertValue((Object)obj, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
    }

    public static HashMap<String, Object> getMapByJsonNode(JsonNode jsonNode) {
        if (jsonNode == null || jsonNode instanceof NullNode) {
            return new HashMap<String, Object>(1);
        }
        return (HashMap)JacksonUtil.convertValue((Object)jsonNode, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
    }

    static HashMap<String, Object> getBody(List<JsonNodeExt> bodyParams, JsonNodeExt nodeIn, SubscribeInfo info) {
        if (CollectionUtil.isEmpty(bodyParams)) {
            return new HashMap<String, Object>(1);
        }
        HashMap listMap = bodyParams.stream().collect(Collectors.groupingBy(it -> it.get("parentId").asText(), HashMap::new, Collectors.toList()));
        LinkedList<Pair<String, Integer>> loopList = new LinkedList<Pair<String, Integer>>();
        return TargetHandle.getBody(listMap, "0", nodeIn, info, loopList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, Object> getBody(Map<String, List<JsonNodeExt>> listMap, String parentId, JsonNodeExt nodeIn, SubscribeInfo info, LinkedList<Pair<String, Integer>> loopList) {
        List<JsonNodeExt> nodeList = listMap.get(parentId);
        if (CollectionUtil.isEmpty(nodeList)) {
            return new HashMap<String, Object>(1);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(nodeList.size());
        for (JsonNodeExt node : nodeList) {
            String paramType = node.get("paramType").asText();
            IscFieldType fieldType = IscFieldType.getIscTypeByTypeName((String)paramType);
            boolean isMul = node.get("isArray").asBoolean();
            JsonNodeExt paramValueExt = JsonNodeExt.of(node.get(PARAM_VALUE));
            Object paramValue = KemJsonNodeType.getValue((JsonNode)paramValueExt.getJsonNode());
            Cloneable value = null;
            if (IscFieldType.STRUCT == fieldType) {
                String id = node.get("Id").asText();
                if (paramValue instanceof String) {
                    String valueExpr = (String)paramValue;
                    if (valueExpr.startsWith("#{") && valueExpr.endsWith("}")) {
                        Object val = TargetHandle.getNodeValue(node.get(PARAM_NAME).asText(), paramValueExt, nodeIn, info, loopList);
                        JsonNode jsonNode = JacksonUtil.valueToTree((Object)val);
                        if (val != null && isMul && jsonNode instanceof ArrayNode) {
                            ArrayNode arrayNode = (ArrayNode)jsonNode;
                            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(arrayNode.size());
                            int start = valueExpr.indexOf("#{");
                            int end = valueExpr.lastIndexOf(125);
                            String script = valueExpr.substring(start + 2, end);
                            for (int i = 0; i < arrayNode.size(); ++i) {
                                loopList.addFirst((Pair<String, Integer>)new Pair((Object)script, (Object)i));
                                try {
                                    list.add(TargetHandle.getBody(listMap, id, nodeIn, info, loopList));
                                    continue;
                                }
                                finally {
                                    loopList.removeFirst();
                                }
                            }
                            value = list;
                        } else {
                            value = TargetHandle.getBody(listMap, id, nodeIn, info, loopList);
                        }
                    } else {
                        value = TargetHandle.getBody(listMap, id, nodeIn, info, loopList);
                    }
                }
                if (isMul && value != null && !(value instanceof Collection)) {
                    value = Collections.singletonList(value);
                }
            } else {
                value = TargetHandle.getNodeValue(node.get(PARAM_NAME).asText(), paramValueExt, nodeIn, info, loopList);
            }
            result.put(node.get(PARAM_NAME).asText(), value);
        }
        return result;
    }

    private static Object getNodeValue(String paramName, JsonNodeExt nodeValue, JsonNodeExt nodeIn, SubscribeInfo info, LinkedList<Pair<String, Integer>> loopList) {
        if (nodeValue == null) {
            return null;
        }
        Object value = KemJsonNodeType.getValue((JsonNode)nodeValue.getJsonNode());
        if (value instanceof String) {
            try {
                value = KemExprUtil.eval((String)value, nodeIn, info, loopList);
            }
            catch (Exception e) {
                throw new KemException((Throwable)e, (KemErrorTemplate)KemCoreError.CoreError, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570 {0} \u503c {1} \u89e3\u6790\u5931\u8d25\u3002", (String)"TargetHandle_0", (String)"isc-kem-core", (Object[])new Object[0]), paramName, value});
            }
        }
        return value;
    }

    static HashMap<String, Object> getHeader(List<JsonNodeExt> reqHeaders, JsonNodeExt nodeIn, SubscribeInfo info) {
        if (CollectionUtil.isEmpty(reqHeaders)) {
            return new HashMap<String, Object>(16);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(reqHeaders.size());
        for (JsonNodeExt it : reqHeaders) {
            result.put(it.get(PARAM_NAME).asText(), TargetHandle.getNodeValue(it.get(PARAM_NAME).asText(), JsonNodeExt.of(it.get(PARAM_VALUE)), nodeIn, info, null));
        }
        return result;
    }

    static HashMap<String, Object> getQueryString(List<JsonNodeExt> urlParams, JsonNodeExt nodeIn, SubscribeInfo info) {
        if (CollectionUtil.isEmpty(urlParams)) {
            return new HashMap<String, Object>(16);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(urlParams.size());
        for (JsonNodeExt it : urlParams) {
            result.put(it.get(PARAM_NAME).asText(), TargetHandle.getNodeValue(it.get(PARAM_NAME).asText(), JsonNodeExt.of(it.get(PARAM_VALUE)), nodeIn, info, null));
        }
        return result;
    }

    abstract TargetResult doHandle(JsonNodeExt var1, JsonNodeExt var2, TargetRetryModel var3, SubscribeInfo var4);

    private TargetHandle(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static TargetResult handle(JsonNodeExt targetConfig, JsonNodeExt nodeIn, TargetRetryModel model, SubscribeInfo info) {
        try {
            return TargetHandle.getTargetHandle(targetConfig.get("targetType").asText()).doHandle(targetConfig, nodeIn, model, info);
        }
        catch (Exception e) {
            TargetResult targetResult = new TargetResult(nodeIn);
            targetResult.setStatus(false);
            targetResult.setException(e);
            return targetResult;
        }
    }

    public static TargetHandle getTargetHandle(String code) {
        return Arrays.stream(TargetHandle.values()).filter(it -> it.code.equals(code)).findFirst().orElseThrow(() -> new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"target type code \u201c" + code + "\u201d does not supported"}));
    }
}

