/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.handler;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.core.subscribe.handler.RetryType;
import kd.isc.kem.core.subscribe.model.SubscribeInfo;
import kd.isc.kem.core.subscribe.model.SubscriberContext;
import kd.isc.kem.core.subscribe.model.TargetResult;
import kd.isc.kem.core.subscribe.model.TargetRetryModel;

public class TargetRetryHandler {
    private static final Log LOG = LogFactory.getLog(TargetRetryHandler.class);

    public static boolean doRetry(DynamicObject target, SubscriberContext context, TargetResult targetResult, int retrySeq) {
        DynamicObject sub = BusinessDataServiceHelper.loadSingle((Object)context.getInfo().getSubId(), (String)"kem_subscribe", (String)"retry");
        int retryCode = sub.getInt("retry");
        long targetId = target.getLong("id");
        JsonHashMap input = context.getNodeIn().getOutput();
        SubscribeInfo info = context.getInfo().newInfo(input);
        String targetName = null;
        try {
            DynamicObject actionType = target.getDynamicObject("actiontype");
            targetName = "\u3010" + actionType.getString("name") + "\u3011" + target.getString("actionname");
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        TargetRetryModel model = new TargetRetryModel(info, targetId, retrySeq + 1, ID.genLongId(), targetName);
        return RetryType.retry(retryCode, model, context);
    }
}

