/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Supplier;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.core.exception.KemCoreError;

public class JsonNodeExt
implements Serializable {
    private final JsonNode jsonNode;

    private JsonNodeExt(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }

    public static JsonNodeExt of(JsonNode jsonNode) {
        return new JsonNodeExt(jsonNode);
    }

    public JsonNode get(String fieldName) {
        return this.orElseThrow(fieldName, this.getKemExceptionSupplier(fieldName));
    }

    public ArrayNode withArray(String propertyName) {
        Optional<JsonNode> optional = this.ofNullable(this.jsonNode.withArray(propertyName));
        return (ArrayNode)optional.orElseThrow(this.getKemExceptionSupplier(propertyName));
    }

    public JsonNode orElse(String fieldName, JsonNode other) {
        Optional<JsonNode> optional = this.ofNullable(this.jsonNode.get(fieldName));
        return optional.orElse(other);
    }

    public JsonNode orElseGet(String fieldName, Supplier<JsonNode> other) {
        Optional<JsonNode> optional = this.ofNullable(this.jsonNode.get(fieldName));
        return optional.orElseGet(other);
    }

    public JsonNode orElseThrow(String fieldName, Supplier<KemException> exceptionSupplier) {
        Optional<JsonNode> optional = this.ofNullable(this.jsonNode.get(fieldName));
        return optional.orElseThrow(exceptionSupplier);
    }

    private <T extends JsonNode> Optional<T> ofNullable(T jsonNode) {
        return Optional.ofNullable(jsonNode);
    }

    private Supplier<KemException> getKemExceptionSupplier(String fieldName) {
        return () -> new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{fieldName + " not found"});
    }
}

