/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.common.util.KemAssert;
import kd.isc.kem.core.event.Event;

public class SubscribeInfo
implements Serializable {
    private static final long serialVersionUID = 340933134092L;
    private final long subInstanceId;
    private final long subId;
    private final String subNumber;
    private final Event event;
    private final Date date;

    @JsonCreator
    public SubscribeInfo(@JsonProperty(value="subInstanceId") long subInstanceId, @JsonProperty(value="subId") long subId, @JsonProperty(value="subNumber") String subNumber, @JsonProperty(value="event") Event event, @JsonProperty(value="date") Date date) {
        KemAssert.isTrue((subInstanceId > 0L ? 1 : 0) != 0, (String)"subInstanceId must not be null");
        KemAssert.isTrue((subId > 0L ? 1 : 0) != 0, (String)"subId must not be null");
        KemAssert.notNull((Object)subNumber, (String)"subNumber must not be null");
        KemAssert.notNull((Object)event, (String)"event must not be null");
        KemAssert.notNull((Object)date, (String)"date must not be null");
        this.subInstanceId = subInstanceId;
        this.subId = subId;
        this.subNumber = subNumber;
        this.event = event;
        this.date = date;
    }

    public String toString() {
        return "SubscribeInfo{subInstanceId=" + this.subInstanceId + ", subId=" + this.subId + ", subNumber='" + this.subNumber + '\'' + ", event=" + this.event + ", date=" + this.date + '}';
    }

    public long getSubInstanceId() {
        return this.subInstanceId;
    }

    public long getSubId() {
        return this.subId;
    }

    public String getSubNumber() {
        return this.subNumber;
    }

    public Event getEvent() {
        return this.event;
    }

    public Date getDate() {
        return this.date;
    }

    public SubscribeInfo newInfo(JsonHashMap data) {
        Event infoEvent = this.getEvent();
        JsonHashMap map = data == null ? new JsonHashMap(1) : new JsonHashMap((Map)data);
        Event event = new Event(infoEvent.getEventId(), infoEvent.getEventNumber(), infoEvent.getDataSourceId(), infoEvent.getEventType(), map);
        SubscribeInfo info = new SubscribeInfo(this.getSubInstanceId(), this.getSubId(), this.getSubNumber(), event, this.getDate());
        return info;
    }
}

