/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.model;

import java.io.Serializable;
import kd.bos.id.ID;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.common.util.KemAssert;
import kd.isc.kem.core.event.Event;
import kd.isc.kem.core.subscribe.definition.NodeType;
import kd.isc.kem.core.subscribe.model.NodeOutput;
import kd.isc.kem.core.subscribe.model.SubscribeInfo;

public class SubscriberContext
implements Serializable {
    private final SubscribeInfo info;
    private NodeOutput nodeIn;
    private JsonHashMap input;
    private NodeOutput output;
    private ParentSubscriberContext parent;
    private NodeType nodeType;
    private long nodeId;
    private long cost;

    public SubscriberContext(SubscriberContext parentContext, NodeType nodeType) {
        this(parentContext.getInfo());
        this.parent = new ParentSubscriberContext(parentContext);
        this.nodeIn = this.parent.getOutput();
        this.nodeType = nodeType;
        this.nodeId = ID.genLongId();
    }

    public SubscriberContext(SubscribeInfo info) {
        KemAssert.notNull((Object)info, (String)"info must not be null");
        this.info = info;
    }

    public SubscribeInfo getInfo() {
        return this.info;
    }

    public Event getEvent() {
        return this.info.getEvent();
    }

    public ParentSubscriberContext getParent() {
        return this.parent;
    }

    public NodeOutput getNodeIn() {
        return this.nodeIn;
    }

    private JsonHashMap getInput() {
        return this.input;
    }

    private NodeOutput getOutput() {
        return this.output;
    }

    public void setInput(JsonHashMap input) {
        this.input = input;
    }

    public void setOutput(NodeOutput output) {
        this.output = output;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public long getCost() {
        return this.cost;
    }

    public void setCost(long cost) {
        this.cost = cost;
    }

    public String toString() {
        return "SubscriberContext{info=" + this.info + ", nodeId=" + this.nodeId + ", nodeIn=" + this.nodeIn + ", input=" + this.input + ", output=" + this.output + ", nodeType=" + (Object)((Object)this.nodeType) + '}';
    }

    public static class ParentSubscriberContext {
        private final SubscriberContext context;

        public ParentSubscriberContext(SubscriberContext context) {
            this.context = context;
        }

        public ParentSubscriberContext getParent() {
            return this.context.getParent();
        }

        public JsonHashMap getInput() {
            return this.context.getInput();
        }

        public NodeOutput getOutput() {
            return this.context.getOutput();
        }

        public NodeOutput getNodeIn() {
            return this.context.getNodeIn();
        }

        public long getNodeId() {
            return this.context.getNodeId();
        }

        public NodeType getNodeType() {
            return this.context.getNodeType();
        }

        public SubscribeInfo getSubscribeInfo() {
            return this.context.getInfo();
        }

        public long getCost() {
            return this.context.getCost();
        }

        public String toString() {
            return "ParentSubscriberContext{context=" + this.context + '}';
        }
    }
}

