/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.subscribe.subscriber;

import kd.isc.kem.core.subscribe.builder.SubscriberBuilder;
import kd.isc.kem.core.subscribe.model.FilterModel;
import kd.isc.kem.core.subscribe.model.LogModel;
import kd.isc.kem.core.subscribe.model.SourceModel;
import kd.isc.kem.core.subscribe.model.SubscribeInfo;
import kd.isc.kem.core.subscribe.model.SubscriberContext;
import kd.isc.kem.core.subscribe.model.TargetModel;
import kd.isc.kem.core.subscribe.model.TargetRetryModel;

public abstract class AbstractSubscriber
extends SubscriberBuilder {
    public AbstractSubscriber(SubscribeInfo info) {
        super(info);
    }

    @Override
    public void configure() {
        this.start().source(context -> new SourceModel()).log(this::createLogModel, true).filter(this::createFilterModel).log(this::createLogModel, true).targets(this::createTargetModel).ifPresent(targets -> targets.forEach().execute().log().endTarget());
    }

    @Override
    public void retryTarget(TargetRetryModel model, boolean isAutoRetry) {
        this.start().source(context -> new SourceModel()).retryTargets(this::createTargetModel, model, isAutoRetry).ifPresent(targets -> targets.forEach().execute().log().endTarget());
    }

    abstract LogModel createLogModel(SubscriberContext var1, boolean var2);

    abstract FilterModel createFilterModel(SubscriberContext var1);

    abstract TargetModel createTargetModel(SubscriberContext var1);
}

