/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.task;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.kem.common.exception.KemCommonError;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.core.task.KemCronDateType;
import org.quartz.CronExpression;

public class KemCronJobUtil {
    public static String getCronExpression(KemCronDateType cronDateType, int value) {
        switch (cronDateType) {
            case Sec: {
                return "0/" + value + " * * * * ?";
            }
            case Min: {
                return "0 0/" + value + " * * * ?";
            }
            case Hour: {
                return "0 0 0/" + value + " * * ?";
            }
            case Day: {
                return "0 0 0 1/" + value + " * ?";
            }
        }
        return "";
    }

    public static Date getNextScheduleTime(String schedule) {
        Date t;
        try {
            CronExpression cronExe = new CronExpression(schedule);
            t = cronExe.getNextValidTimeAfter(new Date(System.currentTimeMillis()));
        }
        catch (Exception ex) {
            String msg = ResManager.loadKDString((String)"Cron\u8868\u8fbe\u5f0f %1$s \u975e\u6cd5\uff0c\u9519\u8bef\u539f\u56e0\uff1a%2$s\u3002", (String)"CronExpress_1", (String)"isc-kem-core", (Object[])new Object[]{schedule, ex.getMessage()});
            throw new KemException((KemErrorTemplate)KemCommonError.CommonError, new Object[]{msg});
        }
        return t;
    }

    public static Date getNextScheduleTime(KemCronDateType cronDateType, int value) {
        String express = KemCronJobUtil.getCronExpression(cronDateType, value);
        return KemCronJobUtil.getNextScheduleTime(express);
    }
}

