/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.kem.common.constants.EventType;
import kd.isc.kem.common.constants.ParamType;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.model.SubscribeDto;
import kd.isc.kem.common.util.CollectionUtil;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.common.util.KemAssert;
import kd.isc.kem.common.util.StringUtil;
import kd.isc.kem.core.event.KemEventFactory;
import kd.isc.kem.core.exception.KemCoreError;
import kd.isc.kem.core.util.SubOperateEventUtil;

public class KemHelper {
    private static final Log LOGGER = LogFactory.getLog(KemHelper.class);
    private static final String FORM_KEM_SUBSCRIBE = "kem_subscribe";
    private static final String ID = "Id";
    private static final String KEY_TARGET_ENTRY = "target_entry";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_NAME = "name";
    private static final String KEY_DESC = "desc";
    private static final String KEY_RETRY = "retry";
    private static final String KEY_SUBID = "subid";
    private static final String KEY_TRIGGERTYPE = "triggertype";
    private static final String KEY_PBC_FLOW = "pbc_flow";
    private static final String KEY_TARGETAPPNAME = "targetappname";
    private static final String KEY_ACTIONTYPE = "actiontype";
    private static final String KEY_TARGETTYPE = "targetType";
    private static final String KEY_ACTIONNAME = "actionname";
    private static final String KEY_ACTION_BASETYPE = "action_basetype";
    private static final String KEY_ACTION_BASEDATA = "action_basedata";
    private static final String KEY_ACTIONCONFIG_TAG = "actionconfig_tag";
    private static final String KEY_ENABLE = "enable";
    private static final String KEY_EVENTID = "eventid";
    private static final String KEY_STATUS = "status";
    private static final String KEY_CREATOR = "creator";
    private static final String KEY_EVENTDATASOURCEID = "eventdatasourceid";
    private static final String KEY_SRCSUBTYPE = "srcsubtype";
    private static final String KEY_SRCSUBID = "srcsubid";
    private static final String KEY_ISVID = "isvid";

    public static long createSubscribeByPbc(SubscribeDto dto) {
        LOGGER.info("KEM_LOG:" + dto.toString());
        Map<DynamicObject, RuntimeException> error = null;
        DynamicObject flow = QueryServiceHelper.queryOne((String)"pbc_flow_def", (String)"Id,number,name,comment", (QFilter[])new QFilter("id", "=", (Object)dto.getPbcFlowDefineId()).toArray());
        if (flow == null) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"pbc flow def \u201c" + dto.getPbcFlowDefineId() + "\u201d not found"});
        }
        DynamicObject event = BusinessDataServiceHelper.loadSingleFromCache((String)"kem_event", (QFilter[])new QFilter(KEY_NUMBER, "=", (Object)dto.getEventNumber()).toArray());
        if (event == null) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"event \u201c" + dto.getEventNumber() + "\u201d not found"});
        }
        if (event.getString(KEY_ENABLE).equals("0")) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"event \u201c" + dto.getEventNumber() + "\u201d is disable"});
        }
        StringBuilder str = new StringBuilder();
        str.append(flow.getString(KEY_NUMBER));
        str.append('_');
        str.append(DBServiceHelper.genStringIds((String)FORM_KEM_SUBSCRIBE, (int)1)[0]);
        DynamicObject subData = null;
        subData = BusinessDataServiceHelper.loadSingle((String)FORM_KEM_SUBSCRIBE, (QFilter[])new QFilter(KEY_SRCSUBTYPE, "=", (Object)"2").and(new QFilter(KEY_SRCSUBID, "=", (Object)dto.getPbcFlowDefineId())).toArray());
        if (null == subData) {
            subData = BusinessDataServiceHelper.newDynamicObject((String)FORM_KEM_SUBSCRIBE);
            subData.set(KEY_SRCSUBID, (Object)dto.getPbcFlowDefineId());
            subData.set(KEY_SRCSUBTYPE, (Object)"2");
        } else if ("B".equals(subData.getString(KEY_STATUS))) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{ResManager.loadKDString((String)"\u8ba2\u9605\u53d1\u5e03\u5931\u8d25\uff1a\u5b58\u5728\u76f8\u540c\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"KemHelper_0", (String)"isc-kem-core", (Object[])new Object[0])});
        }
        subData.set(KEY_NUMBER, (Object)str.toString());
        subData.set(KEY_NAME, (Object)flow.getString(KEY_NAME));
        String isvid = ISVServiceHelper.getISVInfo().getId();
        subData.set(KEY_ISVID, (Object)isvid);
        subData.set(KEY_DESC, (Object)ResManager.loadKDString((String)"PBC\u540c\u6b65\u521b\u5efa\u4e8b\u4ef6\u8ba2\u9605", (String)"KemHelper_1", (String)"isc-kem-core", (Object[])new Object[0]));
        subData.set(KEY_RETRY, (Object)dto.getRetry().getCode());
        subData.set(KEY_TRIGGERTYPE, (Object)"1");
        subData.set("period", (Object)1);
        subData.set("triggerperiod", (Object)"0");
        subData.set(KEY_EVENTID, (Object)event);
        subData.set(KEY_TARGETAPPNAME, (Object)flow.getString(KEY_NAME));
        subData.set(KEY_STATUS, (Object)"A");
        subData.set(KEY_ENABLE, (Object)"1");
        subData.set(KEY_CREATOR, (Object)RequestContext.get().getUserId());
        DynamicObject dataSource = QueryServiceHelper.queryOne((String)"isc_data_source", (String)ID, (QFilter[])new QFilter(KEY_NUMBER, "=", (Object)dto.getDataSourceNumber()).toArray());
        subData.set(KEY_EVENTDATASOURCEID, dataSource != null ? dataSource.get(ID) : null);
        DynamicObjectCollection targets = subData.getDynamicObjectCollection(KEY_TARGET_ENTRY);
        targets.clear();
        DynamicObject target = new DynamicObject(targets.getDynamicObjectType());
        DynamicObject type = QueryServiceHelper.queryOne((String)"kem_actiontype", (String)"id", (QFilter[])new QFilter(KEY_NUMBER, "=", (Object)"pbc").toArray());
        target.set(KEY_ACTIONTYPE, type.get(ID));
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put(KEY_TARGETTYPE, "pbc");
        data.put(KEY_PBC_FLOW, dto.getPbcFlowDefineId());
        data.put(KEY_NUMBER, flow.get(KEY_NUMBER));
        data.put(KEY_NAME, flow.getString(KEY_NAME));
        data.put(KEY_DESC, flow.get("comment"));
        target.set(KEY_ACTIONCONFIG_TAG, (Object)JacksonUtil.writeValueAsString(data));
        target.set(KEY_ACTIONNAME, (Object)flow.getString(KEY_NAME));
        try {
            target.set(KEY_ACTION_BASETYPE, (Object)flow.getDynamicObjectType().getName());
            target.set(KEY_ACTION_BASEDATA, (Object)flow);
        }
        catch (Exception exception) {
            // empty catch block
        }
        targets.add((Object)target);
        Object id = null;
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)FORM_KEM_SUBSCRIBE, (DynamicObject[])new DynamicObject[]{subData}, (OperateOption)OperateOption.create());
        KemEventFactory.getEventService().clearCache();
        if (result.isSuccess()) {
            RuntimeException ex;
            id = result.getSuccessPkIds().get(0);
            if (event.getString("eventtype").equals("5") && (ex = (error = SubOperateEventUtil.attachEvents(new Object[]{id})).values().toArray(new RuntimeException[0])[0]) != null) {
                LOGGER.error("SubOperateEventUtil.attachEvents:", (Throwable)ex);
                DeleteServiceHelper.delete((IDataEntityType)subData.getDynamicObjectType(), (Object[])new Object[]{id});
                throw ex;
            }
            if ((result = OperationServiceHelper.executeOperate((String)"submit", (String)FORM_KEM_SUBSCRIBE, (Object[])new Object[]{result.getSuccessPkIds().get(0)}, (OperateOption)OperateOption.create())).isSuccess()) {
                return (Long)result.getSuccessPkIds().get(0);
            }
            try {
                SubOperateEventUtil.detachEvent(id);
            }
            catch (Exception e) {
                LOGGER.error("KEM_LOG:" + dto, (Throwable)e);
            }
            try {
                DeleteServiceHelper.delete((IDataEntityType)subData.getDynamicObjectType(), (Object[])new Object[]{id});
            }
            catch (Exception e) {
                LOGGER.error("KEM_LOG:" + dto, (Throwable)e);
            }
            LOGGER.error(result.getMessage());
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{String.format(ResManager.loadKDString((String)"\u8ba2\u9605\u53d1\u5e03\u5931\u8d25\uff1a%s", (String)"KemHelper_2", (String)"isc-kem-core", (Object[])new Object[0]), result.getMessage())});
        }
        LOGGER.error(result.getMessage());
        throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{String.format(ResManager.loadKDString((String)"\u8ba2\u9605\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"KemHelper_3", (String)"isc-kem-core", (Object[])new Object[0]), result.getMessage())});
    }

    public static void unSubmitSubscribeByPbc(SubscribeDto dto) {
    }

    public static void deleteSubscribeByPbc(SubscribeDto dto) {
        LOGGER.info("KEM_LOG:" + dto.toString());
        DynamicObject flow = QueryServiceHelper.queryOne((String)"pbc_flow_def", (String)"Id,number,name", (QFilter[])new QFilter("id", "=", (Object)dto.getPbcFlowDefineId()).toArray());
        if (flow == null) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"pbc flow def \u201c" + dto.getPbcFlowDefineId() + "\u201d not found"});
        }
        DynamicObject event = BusinessDataServiceHelper.loadSingleFromCache((String)"kem_event", (QFilter[])new QFilter(KEY_NUMBER, "=", (Object)dto.getEventNumber()).toArray());
        if (event == null) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"event \u201c" + dto.getEventNumber() + "\u201d not found"});
        }
        DynamicObject subData = BusinessDataServiceHelper.loadSingle((String)FORM_KEM_SUBSCRIBE, (QFilter[])new QFilter(KEY_SRCSUBTYPE, "=", (Object)"2").and(new QFilter(KEY_SRCSUBID, "=", (Object)dto.getPbcFlowDefineId())).toArray());
        if (subData == null) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"Subscribe \u201c" + dto + "\u201d not found"});
        }
        Exception ex = null;
        ArrayList<String> errMsg = new ArrayList<String>();
        try {
            if (EventType.ENTITY.getCode() == event.getInt("eventtype")) {
                SubOperateEventUtil.detachEvent(subData.get(ID));
            }
        }
        catch (Exception e) {
            LOGGER.error("KEM_LOG:" + dto, (Throwable)e);
            ex = e;
            errMsg.add(e.getMessage());
        }
        try {
            DeleteServiceHelper.delete((String)FORM_KEM_SUBSCRIBE, (QFilter[])new QFilter("id", "=", subData.get(ID)).toArray());
        }
        catch (Exception e) {
            LOGGER.error("KEM_LOG:" + dto, (Throwable)e);
            ex = e;
            errMsg.add(e.getMessage());
        }
        if (ex != null) {
            throw new KemException((Throwable)ex, (KemErrorTemplate)KemCoreError.CoreError, new Object[]{((Object)errMsg).toString()});
        }
    }

    public static Map<String, Object> getEventExample(long eventId) {
        KemAssert.isTrue((eventId > 0L ? 1 : 0) != 0, (String)"eventId must be not null");
        DynamicObject event = BusinessDataServiceHelper.loadSingle((Object)eventId, (String)"kem_event");
        KemAssert.notNull((Object)event, (String)"eventId not exist");
        DynamicObjectCollection treeEntry = event.getDynamicObjectCollection("data_entry");
        if (CollectionUtil.isEmpty((Collection)treeEntry)) {
            return Collections.emptyMap();
        }
        Map<Long, List<DynamicObject>> pidMap = treeEntry.stream().collect(Collectors.groupingBy(it -> it.getLong("pid")));
        return KemHelper.getEventExample(0L, pidMap);
    }

    private static Map<String, Object> getEventExample(Long pid, Map<Long, List<DynamicObject>> pidMap) {
        List<DynamicObject> roots = pidMap.remove(pid);
        if (CollectionUtils.isEmpty(roots)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(roots.size());
        for (DynamicObject root : roots) {
            Object value;
            ParamType paramType = ParamType.getParamType((String)root.getString("paratype"));
            String param = root.getString("paraname");
            boolean isMul = root.getBoolean("ismultivalue");
            switch (paramType) {
                case Struct: {
                    Map<String, Object> map = KemHelper.getEventExample(root.getLong(ID), pidMap);
                    value = isMul ? Collections.singletonList(map) : map;
                    break;
                }
                default: {
                    value = KemHelper.getExampleValue(param, isMul, root.getString("data_example"), paramType);
                }
            }
            result.put(param, value);
        }
        return result;
    }

    private static Object getExampleValue(String param, boolean isMul, String jsonValue, ParamType paramType) {
        if (StringUtil.isBlank((CharSequence)jsonValue)) {
            return paramType.getExample(isMul);
        }
        try {
            String json = JacksonUtil.isJson((String)jsonValue) ? jsonValue : JacksonUtil.writeValueAsString((Object)jsonValue);
            paramType.validator(param, json, isMul);
            return JacksonUtil.readTree((String)json);
        }
        catch (Exception e) {
            LOGGER.error("KEM_LOG:" + jsonValue, (Throwable)e);
            return paramType.getExample(isMul);
        }
    }
}

