/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.kem.common.constants.EventType;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.util.CollectionUtil;
import kd.isc.kem.common.util.KemAssert;
import kd.isc.kem.common.util.LambdaUtil;
import kd.isc.kem.common.util.StringUtil;
import kd.isc.kem.core.exception.KemCoreError;

public class SubOperateEventUtil {
    private static final Log LOG = LogFactory.getLog(SubOperateEventUtil.class);
    private static final String PARAM_NAME = "paraname";

    public static Map<DynamicObject, RuntimeException> attachEvents(Object[] subIds) {
        if (subIds == null || subIds.length < 1) {
            return Collections.emptyMap();
        }
        QFilter[] qFilters = QFilterUtil.builder().put("id", "in", (Object)subIds).build();
        Map map = BusinessDataServiceHelper.loadFromCache((String)"kem_subscribe", (QFilter[])qFilters);
        if (CollectionUtil.isEmpty((Map)map)) {
            return Collections.emptyMap();
        }
        HashMap<DynamicObject, RuntimeException> result = new HashMap<DynamicObject, RuntimeException>(map.size());
        for (DynamicObject sub : map.values()) {
            try {
                SubOperateEventUtil.attachEvents(sub);
                result.put(sub, null);
            }
            catch (KDException e) {
                LOG.error((Throwable)e);
                String msg = e.getMessage();
                if (msg != null && msg.contains("value too long for type character")) {
                    result.put(sub, (RuntimeException)((Object)new KemException((Throwable)e, (KemErrorTemplate)KemCoreError.CoreError, new Object[]{ResManager.loadKDString((String)"\u4e8b\u4ef6\u6ce8\u518c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e8b\u4ef6\u548c\u6570\u636e\u6e90\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"SubOperateEventUtil_0", (String)"isc-kem-core", (Object[])new Object[0])})));
                    continue;
                }
                result.put(sub, (RuntimeException)((Object)new KemException((Throwable)e, (KemErrorTemplate)KemCoreError.CoreError, new Object[]{"SubOperateEventUtil.attachEvents error"})));
            }
            catch (Throwable e) {
                LOG.error(e);
                result.put(sub, (RuntimeException)((Object)new KemException(e, (KemErrorTemplate)KemCoreError.CoreError, new Object[]{"SubOperateEventUtil.attachEvents error"})));
            }
        }
        return result;
    }

    private static void attachEvents(DynamicObject sub) {
        DynamicObject event = sub.getDynamicObject("eventid");
        long eventId = event.getLong("id");
        event = BusinessDataServiceHelper.loadSingleFromCache((Object)eventId, (String)"kem_event");
        if (EventType.ENTITY.getCode() != event.getInt("eventtype")) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"not a entity event"});
        }
        String entity = event.getString("bizobjectnumber");
        String operate = event.getString("operation");
        String[] ops = Arrays.stream(operate.split(",")).filter(it -> !StringUtil.isBlank((CharSequence)it)).collect(Collectors.toSet()).toArray(new String[0]);
        DynamicObjectCollection dataEntry = event.getDynamicObjectCollection("data_entry");
        if (CollectionUtil.isEmpty((Collection)dataEntry)) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"event data must not be empty"});
        }
        Map<Long, List<DynamicObject>> map = dataEntry.stream().collect(Collectors.groupingBy(it -> it.getLong("pid")));
        Map<String, Object> requires = SubOperateEventUtil.parseParamFlatten(map, 0L);
        long dataSourceId = sub.getLong("eventdatasourceid.id");
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source");
        long dblinkId = dataSource.getLong("dblink_id");
        LambdaUtil.connectionManager((boolean)true, () -> {
            try (ConnectionWrapper cn = ConnectionManager.getConnection((long)dblinkId);){
                String iscHub = ConnectorUtil.getIscHub((DynamicObject)cn.getConfig());
                cn.getFactory().attachEvents(cn, iscHub, EventBindingUtil.TriggerType.Event_Mesh, sub.getLong("id"), entity, ops, requires);
            }
            return null;
        });
    }

    private static Map<String, Object> parseParamFlatten(Map<Long, List<DynamicObject>> map, Long pid) {
        List<DynamicObject> currList = map.get(pid);
        if (CollectionUtil.isEmpty(currList)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> requires = new HashMap<String, Object>(16);
        for (DynamicObject curr : currList) {
            String paraName = curr.getString(PARAM_NAME);
            Map<String, Object> result = SubOperateEventUtil.parseParamFlatten(map, curr.getLong("id"));
            requires.put(paraName, result.isEmpty() ? Integer.valueOf(1) : result);
        }
        return requires;
    }

    public static void detachEvent(Object subId) {
        KemAssert.notNull((Object)subId, (String)"subId must be not null");
        Map<DynamicObject, RuntimeException> map = SubOperateEventUtil.detachEvents(new Object[]{subId});
        RuntimeException e = map.values().toArray(new RuntimeException[0])[0];
        if (e != null) {
            LOG.error("KEM_LOG:" + subId, (Throwable)e);
            throw e;
        }
    }

    public static Map<DynamicObject, RuntimeException> detachEvents(Object[] subIds) {
        if (subIds == null || subIds.length < 1) {
            return Collections.emptyMap();
        }
        QFilter[] qFilters = QFilterUtil.builder().put("id", "in", (Object)subIds).build();
        Map map = BusinessDataServiceHelper.loadFromCache((String)"kem_subscribe", (QFilter[])qFilters);
        if (CollectionUtil.isEmpty((Map)map)) {
            return Collections.emptyMap();
        }
        HashMap<DynamicObject, RuntimeException> result = new HashMap<DynamicObject, RuntimeException>(map.size());
        for (DynamicObject sub : map.values()) {
            try {
                SubOperateEventUtil.detachEvents(sub);
                result.put(sub, null);
            }
            catch (Throwable e) {
                LOG.error(e);
                result.put(sub, (RuntimeException)((Object)new KemException(e, (KemErrorTemplate)KemCoreError.CoreError, new Object[]{"SubOperateEventUtil.detachEvents error"})));
            }
        }
        return result;
    }

    private static void detachEvents(DynamicObject sub) {
        DynamicObject event = sub.getDynamicObject("eventid");
        long eventId = event.getLong("id");
        event = BusinessDataServiceHelper.loadSingleFromCache((Object)eventId, (String)"kem_event");
        if (EventType.ENTITY.getCode() != event.getInt("eventtype")) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"not a entity event"});
        }
        String entity = event.getString("bizobjectnumber");
        long dataSourceId = sub.getLong("eventdatasourceid.id");
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source");
        long dblinkId = dataSource.getLong("dblink_id");
        LambdaUtil.connectionManager((boolean)true, () -> {
            try (ConnectionWrapper cn = ConnectionManager.getConnection((long)dblinkId);){
                String iscHub = ConnectorUtil.getIscHub((DynamicObject)cn.getConfig());
                cn.getFactory().detachEvents(cn, iscHub, EventBindingUtil.TriggerType.Event_Mesh, sub.getLong("id"), entity);
            }
            return null;
        });
    }
}

