/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.opplugin;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.ShowStackTraceUtil;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.core.event.KemEventFactory;
import kd.isc.kem.core.queue.KemQueueFactory;
import kd.isc.kem.core.util.SubOperateEventUtil;

public class KemSubscribeOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(KemSubscribeOpPlugin.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (e.getOperationKey().equals("unsubmit") || e.getOperationKey().equals("submit")) {
            DynamicObject[] datas = e.getDataEntities();
            DynamicObject data = datas[0];
            Object pk = data.getPkValue();
            if (pk.equals(0L)) {
                return;
            }
            data = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"kem_subscribe");
            if (null == data) {
                return;
            }
            String eventNumber = null;
            if (data.getString("triggertype").equals("2")) {
                if (e.getOperationKey().equals("submit")) {
                    this.publishCronEvent(data, true);
                } else if (e.getOperationKey().equals("unsubmit")) {
                    this.publishCronEvent(data, false);
                }
            } else {
                DynamicObject event = data.getDynamicObject("eventid");
                eventNumber = event.getString("number");
                if (event != null && event.getString("eventtype").equals("5")) {
                    Map error = null;
                    if (e.getOperationKey().equals("submit")) {
                        error = SubOperateEventUtil.attachEvents((Object[])new Object[]{pk});
                    } else if (e.getOperationKey().equals("unsubmit")) {
                        error = SubOperateEventUtil.detachEvents((Object[])new Object[]{pk});
                    }
                    if (null != error && error.values().toArray()[0] != null) {
                        this.operationResult.setMessage(ShowStackTraceUtil.getErrorMsg((Throwable)((KemException)error.values().toArray()[0])));
                        this.operationResult.setShowMessage(false);
                        e.setCancel(true);
                        return;
                    }
                }
            }
            if (e.getOperationKey().equals("unsubmit")) {
                KemQueueFactory.getQueue((String)eventNumber).deleteBySubId(Long.parseLong(pk.toString()));
            }
        }
    }

    private void publishCronEvent(DynamicObject data, boolean isPub) {
        Long subId = data.getLong("id");
        String subNumber = data.getString("number");
        String cronExpress = data.getString("triggerperiod");
        KemEventFactory.getEventService().publishCronEvent(subId.longValue(), subNumber, cronExpress, null, isPub);
    }
}

