/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.dts;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.openapi.common.util.SysUtil;
import kd.bos.openapi.form.util.ApiDataSetOperater;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.ExportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.kem.common.util.CollectionUtil;
import kd.isc.kem.form.plugin.dts.KemEntityAndFieldsFilter;
import kd.isc.kem.form.plugin.dts.KemPostHandlerFactory;
import kd.isc.kem.form.plugin.dts.KemPreHandlerFactory;

public class KemImportExportPlugin
extends AbstractListPlugin {
    private static final Log LOG = LogFactory.getLog(KemImportExportPlugin.class);
    public static final String EXPORT_SQL = "export_sql";
    public static final String EXPORT_ZIP = "export_zip";
    public static final String EXPORT = "export";
    public static final String IMPORT = "import";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (SysUtil.isProdEnv()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{EXPORT_SQL});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{EXPORT_SQL});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection collection = args.getListSelectedData();
        if (args.getSource() instanceof AbstractOperate && collection.size() > 0) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            try {
                if (EXPORT.contains(operateKey) || EXPORT_ZIP.contains(operateKey) || EXPORT_SQL.contains(operateKey)) {
                    List ids;
                    DynamicObjectCollection query;
                    if ("kem_subscribe".equals(operate.getEntityId()) && !CollectionUtil.isEmpty((Collection)(query = QueryServiceHelper.query((String)"kem_subscribe", (String)"srcsubtype", (QFilter[])new QFilter("id", "in", ids = collection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList())).and("srcsubtype", "!=", (Object)"0").toArray())))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6765\u6e90\u4e3a\u975e \u201c\u624b\u5de5\u521b\u5efa\u201d \u7684\u8ba2\u9605\u4e0d\u5141\u8bb8\u5bfc\u51fa\u3002", (String)"KemImportExportPlugin_2", (String)"isc-kem-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (collection.size() > 20) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc720\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"KemImportExportPlugin_0", (String)"isc-kem-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                }
            }
            catch (Exception e) {
                args.setCancel(true);
                FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        try {
            if (evt.getOperationResult() == null || !evt.getOperationResult().isSuccess() || !(evt.getSource() instanceof AbstractOperate)) {
                return;
            }
            String entity = ((AbstractOperate)evt.getSource()).getEntityId();
            String operationKey = evt.getOperateKey();
            List pkIds = evt.getOperationResult().getSuccessPkIds();
            if (EXPORT.equals(operationKey)) {
                DynamicObject[] dObjects = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
                ExportAndImportFormUtil.export((IFormView)this.getView(), (DynamicObject[])dObjects);
            } else if (EXPORT_ZIP.equals(operationKey)) {
                ExportUtil.showExportForm((AbstractFormPlugin)this, (AfterDoOperationEventArgs)evt, (String)entity);
            } else if (EXPORT_SQL.equals(operationKey)) {
                this.exportSql(pkIds);
            } else if (IMPORT.equals(operationKey)) {
                FormOpener.openImportForm((IFormPlugin)this, (IFormView)this.getView(), (String)entity);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    private void exportSql(List<Object> pkIds) {
        try {
            ArrayList<String> urls = new ArrayList<String>(pkIds.size());
            String entityId = ((ListView)this.getView()).getBillFormId();
            ApiDataSetOperater operater = new ApiDataSetOperater(entityId);
            List sqlList = operater.getExpDataSetSqlWithIds(pkIds.stream().map(String::valueOf).collect(Collectors.toList()));
            for (Map map : sqlList) {
                String sql = (String)map.get("sql");
                String number = (String)map.get("number");
                String fileName = kd.bos.openapi.form.util.ExportUtil.removeIllegalChar((String)(entityId + "_" + number + "_" + Hash.mur16((Object[])new Object[]{System.currentTimeMillis()}))) + ".sql";
                String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, sql.getBytes(StandardCharsets.UTF_8), 300);
                urls.add(url);
            }
            String zipName = entityId + "_" + Hash.mur16((Object[])new Object[]{RequestContext.get().getGlobalSessionId()}) + ".zip";
            String zipUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().compress(zipName, urls.toArray(new String[0]), 300);
            this.getView().openUrl(zipUrl);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    static {
        KemEntityAndFieldsFilter.init();
        KemPreHandlerFactory.init();
        KemPostHandlerFactory.init();
    }
}

