/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.Modify;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.util.dt.D;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.form.util.DataHandler;
import kd.isc.kem.form.util.FormOpener;
import kd.isc.kem.form.util.ParamDataPreviewUtil;

public class AbstractKemEventBasePlugin
extends AbstractBasePlugIn {
    public static final String ID = "Id";
    public static final String PID = "pid";
    public static final String KEY_EVNT_TYPE = "eventtype";
    public static final String KEY_ISVID = "isvid";
    public static final String KEY_WEBAPIID = "webapiid";
    public static final String KEY_PARALEVEL = "paralevel";
    public static final String KEY_PARANAME = "paraname";
    public static final String KEY_PARANUMBER = "paranumber";
    public static final String KEY_DATA_ENTRY = "data_entry";
    public static final String KEY_WEB_URL_PARAMS = "web_url_params";
    public static final String KEY_URL_PARAM_NAME = "url_param_name";
    public static final String KEY_URL_PARAM_VALUE = "url_param_value";
    public static final String KEY_URL_PARAM_DESC = "url_param_desc";
    public static final String KEY_WEB_REQ_BODY = "web_req_body";
    public static final String KEY_REQ_B_PARAM_NAME = "req_b_param_name";
    public static final String KEY_REQ_B_PARAM_VALUE = "req_b_param_value";
    public static final String KEY_REQ_B_PARAM_TYPE = "req_b_param_type";
    public static final String KEY_REQ_B_PARAM_DESC = "req_b_param_desc";
    public static final String KEY_REQ_B_PARAM_IS_ARRAY = "req_b_param_is_array";
    public static final String KEY_REQ_B_PARAM_REQUIRED = "req_b_param_required";
    public static final String KEY_REQ_B_PARAM_EXAMPLE = "req_b_param_example";
    public static final String KEY_WEB_REQ_HEADER = "web_req_header";
    public static final String KEY_REQ_H_PARAM_NAME = "req_h_param_name";
    public static final String KEY_REQ_H_PARAM_VALUE = "req_h_param_value";
    public static final String KEY_REQ_H_PARAM_DESC = "req_h_param_desc";
    public static final String KEY_CODEEDITAP = "codeeditap";
    public static final String KEY_HTTPMETHOD = "httpmethod";
    public static final String KEY_URL = "url";
    public static final String KEY_NUMBER = "number";
    public static final String KEY_OPENAPI = "openapi";
    public static final String KEY_REQUESTCONFIG_TAG = "requestconfig_tag";
    public static final String KEY_API_SCRIPT = "api_script";
    public static final String KEY_REQUESTSCRIPT_TAG = "requestscript_tag";
    public static final String KEY_PARAMTYPE = "paramtype";
    public static final String KEY_TYPE = "type";
    public static final String KEY_PARAVALUE = "paravalue";
    public static final String KEY_ISC_BIZOBJECT = "isc_bizobject";
    public static final String KEY_ISC_OPERATION = "isc_operation";
    public static final String KEY_BIZ_TYPE = "biz_type";
    public static final String KEY_OPERATION = "operation";
    public static final String KEY_BIZOBJECTNUMBER = "bizobjectnumber";
    public static final String KEY_BIZOBJECTNAME = "bizobjectname";
    public static final String KEY_DATASOURCEID = "datasourceid";
    public static final String ISGROUPNODE = "isGroupNode";
    public static final String BTN_WEBHOOK = "changewebhook";
    public static final String BTN_OPEN = "open";
    public static final String BTN_CLOSE = "close";
    public static final String OP_SAVE = "save";
    public static final String OP_JSONIMPORT = "jsonimport";
    public static final String OP_PREVIEW = "preview";
    public static final String FORM_ISC_APIC_WEBAPI = "isc_apic_webapi";
    public static final String FORM_OPENAPI_APILIST = "openapi_apilist";
    public static final String FORM_KEM_PARAMS_VALUE = "kem_params_value";
    public static final String FORM_OPENAPI_IMPORT_JSON = "openapi_import_json";
    public static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isvid = ISVServiceHelper.getISVInfo().getId();
        this.getModel().setValue(KEY_ISVID, (Object)isvid);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!this.getModel().getDataEntity().getPkValue().equals(0L)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_NUMBER});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            if (this.getModel().getValue("enable").equals("1")) {
                args.setCancel(true);
                args.setCancelMessage("is already enable");
                return;
            }
            if (this.checkIsLocalIsv(args)) {
                return;
            }
            String number = this.getModel().getValue(KEY_NUMBER).toString();
            if (this.getModel().getDataEntity().getPkValue().equals(0L) && !number.matches("^[0-9_a-zA-Z]{3,40}$")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u7b26\u5408\u7f16\u7801\u8981\u6c42\uff083~40\u4f4d\u5b57\u7b26\uff0c\u5927\u5c0f\u5199\u53ca\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7ec4\u5408\uff09\u3002", (String)"KemEventBasePlugin_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!this.getModel().getValue(KEY_EVNT_TYPE).equals("3") && this.getModel().getEntryRowCount(KEY_DATA_ENTRY) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u6761\u4e8b\u4ef6\u4f20\u9012\u53c2\u6570\u3002", (String)"KemEventBasePlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.checkParamData(args)) {
                return;
            }
            if (this.checkHaveSub(args)) {
                return;
            }
            if (!((DynamicObject)this.getModel().getValue(KEY_DATASOURCEID)).getString(KEY_NUMBER).equals("KemOpenEvt")) {
                this.buildJsonDataByParams();
            }
        } else if (args.getSource() instanceof StatusConvert && ((StatusConvert)args.getSource()).getOperateKey().equals("disable")) {
            this.checkHaveSub(args);
        } else if (args.getSource() instanceof Modify) {
            if (this.checkIsLocalIsv(args)) {
                return;
            }
            Object id = this.getModel().getDataEntity().getPkValue();
            QFilter qFilter = new QFilter("eventid.id", "=", id);
            qFilter.and(new QFilter("status", "=", (Object)"B"));
            boolean isInSub = QueryServiceHelper.exists((String)"kem_subscribe", (QFilter[])qFilter.toArray());
            if (isInSub) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5df2\u7ecf\u88ab\u8ba2\u9605\uff0c\u8bf7\u64a4\u9500\u8ba2\u9605\u540e\u518d\u4fee\u6539\u3002", (String)"KemEventBasePlugin_8", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"KemEventBasePlugin_10", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("idDisable"));
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if (e.getInsertRow() > 0) {
            int index = this.getModel().getEntryCurrentRowIndex(KEY_DATA_ENTRY);
            Object paramLevel = this.getModel().getValue(KEY_PARALEVEL, index);
            int level = 0;
            if (null != paramLevel) {
                level = Integer.parseInt(paramLevel.toString()) + 1;
            }
            this.getModel().setValue(KEY_PARALEVEL, (Object)level, e.getInsertRow());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals(OP_SAVE)) {
            if (args.getOperationResult().isSuccess()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_NUMBER});
            }
        } else if (args.getOperateKey().equals(OP_JSONIMPORT)) {
            FormOpener.showForm((AbstractFormPlugin)this, "isc_data_content", ResManager.loadKDString((String)"\u5bfc\u5165\u8bf7\u6c42\u6a21\u578b\uff08json\u683c\u5f0f\uff09", (String)"KemEventBasePlugin_7", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), new HashMap<String, Object>(), "gen_req_model");
        } else if (args.getOperateKey().equals(OP_PREVIEW)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Object object = ParamDataPreviewUtil.getCustomParams(KEY_DATA_ENTRY, this.getModel().getEntryEntity(KEY_DATA_ENTRY));
            params.put("param", JacksonUtil.writeValueAsPrettyString((Object)object));
            FormOpener.showForm((AbstractFormPlugin)this, "kem_param_preview", null, params, null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (null != evt.getReturnData() && !OP_JSONIMPORT.equals(evt.getActionId()) && evt.getActionId().equals("gen_req_model")) {
            this.setDataBody(evt);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("idDisable") && evt.getResult().name().equals("Yes")) {
            this.getView().invokeOperation("disable");
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        String isvid = ISVServiceHelper.getISVInfo().getId();
        this.getModel().setValue(KEY_ISVID, (Object)isvid);
    }

    private boolean checkHaveSub(BeforeDoOperationEventArgs args) {
        Object pk = this.getModel().getDataEntity().getPkValue();
        if (!pk.equals(0L)) {
            QFilter qFilter = new QFilter("eventid.id", "=", pk);
            qFilter.and(new QFilter("status", "=", (Object)"B"));
            if (QueryServiceHelper.exists((String)"kem_subscribe", (QFilter[])qFilter.toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5df2\u7ecf\u88ab\u8ba2\u9605\uff0c\u8bf7\u64a4\u9500\u8ba2\u9605\u540e\u518d\u4fee\u6539\u3002", (String)"KemEventBasePlugin_8", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                return true;
            }
        }
        return false;
    }

    private boolean checkParamData(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection dataEntry = this.getModel().getEntryEntity(KEY_DATA_ENTRY);
        for (DynamicObject row : dataEntry) {
            if (row.getString(KEY_PARANAME).matches("^[a-zA-Z][a-zA-Z0-9_$]{0,30}$")) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u53c2\u6570\u7b2c%s\u884c\uff0c\u53c2\u6570\u4ec5\u652f\u6301\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\uff0c\u4e14\u53ea\u80fd\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"KemEventBasePlugin_6", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), row.getString("seq")));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private void buildJsonDataByParams() {
        JSONObject obj;
        JSONObject requestconfig = new JSONObject();
        CodeEdit Edit = (CodeEdit)this.getControl(KEY_CODEEDITAP);
        this.getModel().setValue(KEY_REQUESTSCRIPT_TAG, (Object)Edit.getText());
        requestconfig.put(KEY_HTTPMETHOD, this.getModel().getValue(KEY_HTTPMETHOD));
        requestconfig.put(KEY_URL, this.getModel().getValue(KEY_URL));
        DynamicObjectCollection urls = this.getModel().getEntryEntity(KEY_WEB_URL_PARAMS);
        JSONArray urlsArr = new JSONArray(urls.size());
        for (DynamicObject url : urls) {
            JSONObject obj2 = new JSONObject();
            obj2.put(KEY_URL_PARAM_NAME, url.get(KEY_URL_PARAM_NAME));
            obj2.put(KEY_URL_PARAM_VALUE, url.get(KEY_URL_PARAM_VALUE));
            obj2.put(KEY_URL_PARAM_DESC, url.get(KEY_URL_PARAM_DESC));
            urlsArr.add((Object)obj2);
        }
        requestconfig.put(KEY_WEB_URL_PARAMS, (Object)urlsArr.toString());
        DynamicObjectCollection headers = this.getModel().getEntryEntity(KEY_WEB_REQ_HEADER);
        JSONArray headersArr = new JSONArray(headers.size());
        for (DynamicObject header : headers) {
            obj = new JSONObject();
            obj.put(KEY_REQ_H_PARAM_NAME, header.get(KEY_REQ_H_PARAM_NAME));
            obj.put(KEY_REQ_H_PARAM_VALUE, header.get(KEY_REQ_H_PARAM_VALUE));
            obj.put(KEY_REQ_H_PARAM_DESC, header.get(KEY_REQ_H_PARAM_DESC));
            headersArr.add((Object)obj);
        }
        requestconfig.put(KEY_WEB_REQ_HEADER, (Object)headersArr.toString());
        DynamicObjectCollection bodys = this.getModel().getEntryEntity(KEY_WEB_REQ_BODY);
        JSONArray bodysArr = new JSONArray(bodys.size());
        obj = new JSONObject();
        for (DynamicObject body : bodys) {
            obj.put(body.getString(KEY_REQ_B_PARAM_NAME), body.get(KEY_REQ_B_PARAM_VALUE));
        }
        bodysArr.add((Object)obj);
        requestconfig.put(KEY_WEB_REQ_BODY, (Object)bodysArr.toString());
        this.getModel().setValue(KEY_REQUESTCONFIG_TAG, (Object)requestconfig);
    }

    private void setDataBody(ClosedCallBackEvent evt) {
        String reqData = D.s((Object)evt.getReturnData());
        if (reqData != null) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            obj.set(KEY_DATA_ENTRY, (Object)DataHandler.initDataBody(reqData, obj));
            this.getView().updateView(KEY_DATA_ENTRY);
        }
    }

    private boolean checkIsLocalIsv(BeforeDoOperationEventArgs args) {
        String isvid = ISVServiceHelper.getISVInfo().getId();
        if (!this.getModel().getValue(KEY_ISVID).equals(isvid)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u672c\u5f00\u53d1\u5546\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u8bf7\u590d\u5236\u521b\u5efa\u65b0\u7684\u4e8b\u4ef6\u6570\u636e\u8fdb\u884c\u4fee\u6539\u3002", (String)"KemEventBasePlugin_9", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private void rebuildNumber(BeforeDoOperationEventArgs e) {
        DynamicObject data = this.getModel().getDataEntity();
        if (!data.getPkValue().equals(0L)) {
            return;
        }
        StringBuilder number = new StringBuilder();
        String isvid = data.getString(KEY_ISVID);
        if (!isvid.equals("kingdee")) {
            number.append(isvid);
            number.append('.');
        }
        DynamicObject source = data.getDynamicObject(KEY_DATASOURCEID);
        number.append(source.getString(KEY_NUMBER));
        number.append('.');
        DynamicObject group = data.getDynamicObject("group");
        number.append(group.getString(KEY_NUMBER));
        number.append('.');
        number.append(data.getString(KEY_NUMBER));
        if (QueryServiceHelper.exists((String)"kem_event", (QFilter[])new QFilter(KEY_NUMBER, "=", (Object)number.toString().toLowerCase()).toArray())) {
            e.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e8b\u4ef6\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"KemOpenEventBasePlugin_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        data.set(KEY_NUMBER, (Object)number.toString().toLowerCase());
    }
}

