/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.event;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.kem.common.util.StringUtil;
import kd.isc.kem.form.plugin.event.AbstractKemEventBasePlugin;
import kd.isc.kem.form.util.DataTypeUtil;
import kd.isc.kem.form.util.FormOpener;

public class KemEventBasePlugin
extends AbstractKemEventBasePlugin
implements CellClickListener,
BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"changewebhook", "open", "close"});
        EntryGrid subcond = (EntryGrid)this.getView().getControl("web_req_body");
        subcond.addCellClickListener((CellClickListener)this);
        BasedataEdit group = (BasedataEdit)this.getControl("group");
        group.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit isc_bizobject = (BasedataEdit)this.getControl("isc_bizobject");
        isc_bizobject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object type = this.getView().getFormShowParameter().getCustomParam("eventtype");
        this.getModel().setValue("eventtype", (Object)(type + ""));
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.buildParamsByJson();
        this.buildBillEntityData();
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.buildParamsByJson();
        this.buildBillEntityData();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFieldMustInput();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (!name.equals("webapiid")) {
            if (name.equals("number")) {
                this.getPageCache().put("number", this.getModel().getValue("number").toString());
            } else if (name.equals("isc_bizobject")) {
                this.getModel().setValue("isc_operation", null);
                this.getModel().setValue("operation", null);
                this.buildOpMulCombo();
                this.getModel().deleteEntryData("data_entry");
            } else if (name.equals("isc_operation")) {
                this.getModel().setValue("operation", this.getModel().getValue("isc_operation"));
            } else if (name.equals("biz_type")) {
                this.setFieldMustInput();
                Object type = this.getModel().getValue("biz_type");
                if (type.equals("1")) {
                    this.getModel().setValue("isc_operation", null);
                } else {
                    this.getModel().setValue("isc_bizobject", null);
                    this.getModel().setValue("datasourceid", null);
                }
                this.getModel().setValue("operation", null);
                this.getModel().setValue("bizobjectnumber", (Object)"");
                this.getModel().setValue("bizobjectname", (Object)"");
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (operateKey.equals("getprop")) {
            Object bizobject = this.getModel().getValue("isc_bizobject");
            if (bizobject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u96c6\u6210\u5bf9\u8c61\u3002", (String)"KemEventBasePlugin_11", (String)"isc-kem-formplugin", (Object[])new Object[0]));
            } else {
                long e = ((DynamicObject)bizobject).getLong("id");
                if (e == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u96c6\u6210\u5bf9\u8c61\u3002", (String)"KemEventBasePlugin_11", (String)"isc-kem-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> param = new HashMap<String, Object>(3);
                param.put("id", e);
                param.put("$type", "reader_field");
                param.put("$row", 0);
                FormOpener.showForm((AbstractFormPlugin)this, "kem_isc_field_slected", null, param, "reader_field");
            }
        }
    }

    public void cellClick(CellClickEvent evt) {
        String field = evt.getFieldKey();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (field.equals("req_b_param_value") && evt.getRow() != -1) {
            params.put("paramtype", 1);
            params.put("type", 0);
            params.put("lab", 1);
            String value = String.valueOf(this.getModel().getValue("req_b_param_value", evt.getRow()));
            if (StringUtil.isNotEmpty((CharSequence)value)) {
                params.put("paravalue", value);
            }
            FormOpener.showForm((AbstractFormPlugin)this, "kem_params_value", ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u503c", (String)"KemSubscribeBasePlugin_2", (String)"isc-kem-formplugin", (Object[])new Object[0]), params, "kem_params_value");
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (!control.getKey().equals("changewebhook")) {
            if (control.getKey().equals("open")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"close", "api_script"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"open"});
            } else if (control.getKey().equals("close")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"close", "api_script"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"open"});
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (null != evt.getReturnData() && !"changewebhook".equals(evt.getActionId())) {
            if ("kem_params_value".equals(evt.getActionId())) {
                int index = this.getModel().getEntryCurrentRowIndex("web_req_body");
                String datas = (String)evt.getReturnData();
                this.getModel().setValue("req_b_param_value", (Object)datas, index);
            } else if ("reader_field".equals(evt.getActionId())) {
                this.buildParamEntry(evt.getReturnData());
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (name.equals("group")) {
            DynamicObject group = (DynamicObject)this.getModel().getValue("group");
            if (group != null) {
                QFilter qFilter = new QFilter("datasourceid.id", "=", (Object)group.getLong("datasourceid.id"));
                evt.getCustomQFilters().add(qFilter);
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.getTreeFilterParameter().getQFilters().add(qFilter);
            }
        } else if (name.equals("isc_bizobject")) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setFormId("bos_listf7");
            if (null != this.getModel().getValue("datasourceid")) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("group.id", "=", ((DynamicObject)this.getModel().getValue("datasourceid")).get("Id")));
            }
        }
    }

    private void buildDataEntryByApi(DynamicObject api) {
    }

    private static Object getParamExample(String paramName, String example, boolean isMul, String paramtype) {
        return null;
    }

    private Map<String, Integer> getParentRowIndex(DynamicObject resp) {
        return null;
    }

    private void buildParamsByJson() {
    }

    private void buildOpMulCombo() {
        if (null != this.getModel().getValue("isc_bizobject")) {
            DynamicObject entry = (DynamicObject)this.getModel().getValue("isc_bizobject");
            MulComboEdit ed = (MulComboEdit)this.getControl("isc_operation");
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            for (DynamicObject op : entry.getDynamicObjectCollection("event_entryentity")) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(op.getString("event_label")));
                item.setValue(op.getString("event_number"));
                items.add(item);
            }
            ed.setComboItems(items);
        }
    }

    private void setFieldMustInput() {
        BaseModel model = (BaseModel)this.getModel();
        if (model.getValue("eventtype").equals("5")) {
            TextEdit number = (TextEdit)this.getControl("bizobjectnumber");
            TextEdit name = (TextEdit)this.getControl("bizobjectname");
            number.setMustInput(true);
            name.setMustInput(true);
            String bizType = model.getValue("biz_type").toString();
            BasedataEdit edit = (BasedataEdit)this.getControl("isc_bizobject");
            ComboEdit iscOp = (ComboEdit)this.getControl("isc_operation");
            TextEdit op = (TextEdit)this.getControl("operation");
            boolean type = bizType.equals("1");
            edit.setMustInput(type);
            iscOp.setMustInput(type);
            op.setMustInput(!type);
        }
    }

    private void buildBillEntityData() {
        QFilter qFilter;
        DynamicObject meta;
        if (this.getModel().getValue("eventtype").equals("5") && this.getModel().getValue("biz_type").equals("1") && null != (meta = QueryServiceHelper.queryOne((String)"isc_metadata_schema", (String)"Id", (QFilter[])(qFilter = new QFilter("full_name", "=", this.getModel().getValue("bizobjectnumber")).and(new QFilter("name", "=", this.getModel().getValue("bizobjectname")).and(new QFilter("group.id", "=", ((DynamicObject)this.getModel().getValue("datasourceid")).get("Id"))))).toArray()))) {
            this.getModel().setValue("isc_bizobject", meta.get("Id"));
            this.buildOpMulCombo();
            this.getModel().setValue("isc_operation", this.getModel().getValue("operation"));
        }
    }

    private void buildParamEntry(Object data) {
        this.getView().updateView("data_entry");
    }

    private void buildTreeRowData(Map map, int index) {
        String number = map.get("number").toString();
        String is_primary_key = map.get("is_primary_key").toString();
        String full_name = map.get("full_name").toString();
        String name = map.get("name").toString();
        String data_type = map.get("data_type").toString();
        String data_schema = map.get("data_schema").toString();
        String remark = map.get("remark").toString();
        String value = map.get("value").toString();
        String full_number = map.get("full_number").toString();
        String required = map.get("required").toString();
        String type = DataTypeUtil.convertType(data_type);
        this.getModel().setValue("paratype", (Object)type, index);
        this.getModel().setValue("isrequired", (Object)(required.equals("true") ? "1" : "0"), index);
        this.getModel().setValue("paradesc", (Object)full_name, index);
        this.getModel().setValue("data_example", (Object)data_schema, index);
        this.getModel().setValue("full_number", (Object)full_number, index);
    }

    public void buildTreeRow(String full_number, Map map) {
        String input = full_number;
        Node root = this.generateHierarchy(input.split("\\."), 0);
        this.generateJavaCode(root, 0, -1, map);
    }

    private Node generateHierarchy(String[] parts, int index) {
        if (index >= parts.length) {
            return null;
        }
        Node node = new Node(parts[index]);
        node.children.add(this.generateHierarchy(parts, index + 1));
        return node;
    }

    private void generateJavaCode(Node node, int level, int index, Map map) {
        if (node == null) {
            return;
        }
        boolean isFirst = true;
        if (level == 0) {
            Map<String, Object> rowIndex = this.checkHasFieldFirst(node.name);
            if (rowIndex != null) {
                index = (Integer)rowIndex.get("rowIndex");
                this.getPageCache().put("fstid", rowIndex.get("Id").toString());
                isFirst = false;
            } else {
                index = this.getModel().createNewEntryRow("data_entry");
                this.buildTreeRowData(map, index);
            }
        } else if (null != this.getPageCache().get("fstid") || null != this.getPageCache().get("notfstid")) {
            Map<String, Object> rowIndex;
            Long pid = 0L;
            if (null != this.getPageCache().get("fstid")) {
                pid = Long.valueOf(this.getPageCache().get("fstid"));
                this.getPageCache().remove("fstid");
            }
            if (null != this.getPageCache().get("notfstid")) {
                pid = Long.valueOf(this.getPageCache().get("notfstid"));
                this.getPageCache().remove("notfstid");
            }
            if ((rowIndex = this.getRowIndexById(node.name, pid)) != null) {
                index = (Integer)rowIndex.get("rowIndex");
                this.getPageCache().put("notfstid", rowIndex.get("Id").toString());
                isFirst = false;
            } else {
                index = this.getModel().insertEntryRow("data_entry", index);
                this.buildTreeRowData(map, index);
            }
        } else {
            index = this.getModel().insertEntryRow("data_entry", index);
            this.buildTreeRowData(map, index);
        }
        if (index >= 0 && isFirst) {
            this.getModel().setValue("paraname", (Object)node.name, index);
            this.getModel().setValue("paranumber", (Object)node.name, index);
            this.getModel().setValue("paralevel", (Object)(level + 1), index);
            DynamicObject schema = this.getModel().getDataEntity().getDynamicObject("isc_bizobject");
            DynamicObjectCollection props = schema.getDynamicObjectCollection("prop_entryentity");
            for (DynamicObject prop : props) {
                if (!prop.getString("prop_name").equals(this.getModel().getValue("paraname", index))) continue;
                this.getModel().setValue("paratype", (Object)DataTypeUtil.convertType(prop.get("data_type")), index);
                this.getModel().setValue("paranumber", prop.get("prop_label"), index);
                this.getModel().setValue("paradesc", prop.get("prop_label"), index);
            }
        }
        for (Node child : node.children) {
            this.generateJavaCode(child, level + 1, index, map);
        }
    }

    private Map<String, Object> checkHasFieldFirst(String name) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("data_entry");
        List lvs = rows.stream().filter(a -> a.getInt("paralevel") == 1).collect(Collectors.toList());
        for (DynamicObject lv : lvs) {
            if (!lv.getString("paraname").equals(name)) continue;
            map.put("Id", lv.getLong("Id"));
            map.put("rowIndex", lv.getInt("seq") - 1);
            return map;
        }
        return null;
    }

    private Map<String, Object> getRowIndexById(String name, Long parentId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("data_entry");
        for (DynamicObject row : rows) {
            if (row.getLong("pid") != parentId.longValue() || !row.getString("paraname").equals(name)) continue;
            map.put("Id", row.getLong("Id"));
            map.put("rowIndex", row.getInt("seq") - 1);
            return map;
        }
        return null;
    }

    private void rebuildDataType() {
        DynamicObjectCollection datas = this.getModel().getEntryEntity("data_entry");
        for (int i = 0; i < datas.size(); ++i) {
            Long id = ((DynamicObject)datas.get(i)).getLong("Id");
            for (DynamicObject data : datas) {
                if (data.getLong("pid") != id.longValue()) continue;
            }
        }
    }

    private static class Node {
        private String name;
        private List<Node> children;

        Node(String name) {
            this.name = name;
            this.children = new ArrayList<Node>();
        }
    }
}

