/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.dc.meta.MetadataSchemaFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.meta.MetaSchemaUtil;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.form.util.DataTypeUtil;

public class KemSFFieldSelectedFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener,
RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static final String REMARK = "remark";
    private static final String DATA_TYPE = "data_type";
    private static final String PROP_LABEL = "prop_label";
    private static final String DATA_SCHEMA = "data_schema";
    private static final String PROP_NAME = "prop_name";
    private static final String PROP_ENTRYENTITY = "prop_entryentity";
    private static final String NAME_SUFFIX = "@TABLE";
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String PARAM_ROW = "$row";
    private static final String PARAM_TYPE = "$type";
    private static final String NUMBER = "number";
    private static final String FULL_NUMBER = "full_number";
    private static final String KEY_TREE = "treeviewap";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_SEARCH = "searchap";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_CANCEL = "btncancel";
    private static final String KEY_BTN_SYNC = "btn_sync";
    private static final Set<String> META_TYPES = new HashSet<String>(Arrays.asList("TABLE", "VIEW", "ENTITY", "STRUCT", "meta"));
    private static final Set<String> NODE_TYPES = new HashSet<String>(Arrays.asList("ENTRIES", "STRUCT", "REF", "SubHeadEntity", "meta", "list<meta>"));
    private static final String ROOT = "rootId";
    private static final String DATA_SOURCE = "data_source";
    public static final String KEY_PARALEVEL = "paralevel";
    public static final String KEY_PARANAME = "paraname";
    public static final String KEY_PARANUMBER = "paranumber";
    public static final String KEY_DATA_ENTRY = "data_entry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CANCEL, KEY_BTN_SYNC, KEY_ENTRY_ENTITY});
        EntryGrid entry = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        entry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        Pair<String, List<String>> checkedData = this.getCheckedData();
        this.buildTreeEntryBySelectRow(checkedData);
        this.setSelectedEntry(checkedData);
    }

    private void setSelectedEntry(Pair<String, List<String>> checkedData) {
        DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("selectedentry");
        HashSet<String> exists = new HashSet<String>();
        for (DynamicObject object : selectedentry) {
            exists.add(object.getString("selected_full_number"));
        }
        if ("increase".equals(checkedData.getKey())) {
            List addField = (List)checkedData.getValue();
            for (String f : addField) {
                if (exists.contains(f)) continue;
                Map<String, Object> fieldMap = this.getEntriesByRootId(f);
                DynamicObject selected = selectedentry.addNew();
                for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
                    if (entry.getKey().equals("id") || entry.getKey().equals("seq")) continue;
                    selected.set("selected_" + entry.getKey(), entry.getValue());
                }
            }
        }
        if ("decrease".equals(checkedData.getKey())) {
            final List decField = (List)checkedData.getValue();
            this.removeTreeEntryRowByDecField(decField);
            selectedentry.removeIf((Predicate)new Predicate<DynamicObject>(){

                @Override
                public boolean test(DynamicObject dynamicObject) {
                    return decField.contains(dynamicObject.getString("selected_full_number"));
                }
            });
        }
        this.getView().updateView("selectedentry");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DeleteEntry op;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof DeleteEntry && (op = (DeleteEntry)args.getSource()).getOperateKey().equals("deleteentry")) {
            EntryGrid grid = (EntryGrid)this.getControl("selectedentry");
            ArrayList<String> decField = new ArrayList<String>(grid.getSelectRows().length);
            for (int i : grid.getSelectRows()) {
                decField.add(this.getModel().getValue("selected_full_number", i).toString());
            }
            this.removeTreeEntryRowByDecField(decField);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            this.checkedFiledListFromSelected();
        }
    }

    private void checkedFiledListFromSelected() {
        DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("selectedentry");
        HashSet<String> exists = new HashSet<String>();
        for (DynamicObject object : selectedentry) {
            exists.add(object.getString("selected_full_number"));
        }
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
        ArrayList<Integer> rowIndex = new ArrayList<Integer>();
        for (int i = 0; i < entryentity.size(); ++i) {
            if (!exists.contains(((DynamicObject)entryentity.get(i)).getString(FULL_NUMBER))) continue;
            rowIndex.add(i);
        }
        int[] rowIndexArr = new int[rowIndex.size()];
        for (int i = 0; i < rowIndex.size(); ++i) {
            rowIndexArr[i] = (Integer)rowIndex.get(i);
        }
        if (rowIndexArr.length > 0) {
            entryGrid.selectRows(rowIndexArr, rowIndexArr[0]);
        } else {
            entryGrid.selectRows(rowIndexArr, 1);
        }
        this.putSelectedRowsInCache(entryentity, entryGrid);
    }

    private void putSelectedRowsInCache(DynamicObjectCollection entryentity, EntryGrid entryGrid) {
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<String> currSelected = new ArrayList<String>(selectRows.length);
        for (int index : selectRows) {
            DynamicObject row = (DynamicObject)entryentity.get(index);
            currSelected.add(row.getString(FULL_NUMBER));
        }
        this.getView().getPageCache().put("lastCheckedData", Json.toString(currSelected));
    }

    private void buildTreeEntryBySelectRow(Pair<String, List<String>> checkedData) {
        String rootId = this.getPageCache().get(ROOT);
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)rootId, (String)ISC_METADATA_SCHEMA);
        Map<String, Object> rowsKV = this.getCacheMap();
        DynamicObjectCollection dataEntrys = this.getModel().getEntryEntity(KEY_DATA_ENTRY);
        List addField = (List)checkedData.getValue();
        for (String f : addField) {
            this.buildTreeRows(dataEntrys, f, null, rowsKV, 0L, 0, meta.getDynamicObjectCollection(PROP_ENTRYENTITY));
        }
        this.resetIsauto(dataEntrys, addField);
        this.getView().updateView(KEY_DATA_ENTRY);
    }

    private void removeTreeEntryRowByDecField(List<String> decField) {
        DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_DATA_ENTRY);
        final ArrayList<String> newDecField = new ArrayList<String>(decField.size());
        DynamicObjectCollection dataEntrys = this.getModel().getEntryEntity(KEY_DATA_ENTRY);
        for (String field : decField) {
            for (DynamicObject dataEntry : dataEntrys) {
                if (!dataEntry.getString("confignumber").equals(field)) continue;
                if (this.findSonRow(dataEntrys, dataEntry)) {
                    dataEntry.set("isauto", (Object)"1");
                    continue;
                }
                newDecField.add(field);
            }
        }
        selectedentry.removeIf((Predicate)new Predicate<DynamicObject>(){

            @Override
            public boolean test(DynamicObject dynamicObject) {
                return newDecField.contains(dynamicObject.getString("confignumber"));
            }
        });
        if (!selectedentry.isEmpty()) {
            this.findParentRow(selectedentry);
        }
        this.getView().updateView(KEY_DATA_ENTRY);
    }

    private void findParentRow(DynamicObjectCollection selectedentry) {
        List delRows = selectedentry.stream().filter(row1 -> row1.getString("isauto").equals("1")).collect(Collectors.toList());
        if (delRows.isEmpty()) {
            return;
        }
        List remRows = delRows.stream().flatMap(row4 -> selectedentry.stream().filter(row3 -> row4.getLong("id") == row3.getLong("pid")).map(row3 -> row4)).collect(Collectors.toList());
        delRows.removeAll(remRows);
        selectedentry.removeAll(delRows);
        if (!delRows.isEmpty() && !selectedentry.isEmpty()) {
            this.findParentRow(selectedentry);
        }
    }

    private void buildTreeRows(DynamicObjectCollection dataEntrys, String field, String parentField, Map<String, Object> rowsKV, Long pid, int index, DynamicObjectCollection prop_entryentity) {
        QFilter filter;
        DynamicObject meta;
        ++index;
        String f = field;
        if (field.contains(".")) {
            f = field.split("\\.")[0];
        }
        Long id = 0L;
        DynamicObject hasRow = this.findExistingRow(dataEntrys, parentField == null ? f : parentField + "." + f, index);
        DynamicObject dataProp = this.getDataTypeFromParentPropEntrys(prop_entryentity, f);
        if (!dataProp.getString(DATA_SCHEMA).isEmpty() && null != (meta = BusinessDataServiceHelper.loadSingleFromCache((String)ISC_METADATA_SCHEMA, (QFilter[])new QFilter[]{filter = new QFilter(NUMBER, "=", (Object)dataProp.getString(DATA_SCHEMA)).and("group", "=", (Object)Long.parseLong(this.getPageCache().get(DATA_SOURCE)))})) && null != meta.get(PROP_ENTRYENTITY)) {
            prop_entryentity = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        }
        String parentFullnumber = null;
        if (hasRow != null) {
            id = hasRow.getLong("id");
            parentFullnumber = hasRow.getString("confignumber");
        } else {
            DynamicObject row = dataEntrys.addNew();
            row.set("paratype", (Object)DataTypeUtil.convertType(dataProp.getString(DATA_TYPE)));
            row.set(KEY_PARANUMBER, (Object)dataProp.getString(PROP_LABEL));
            row.set("isrequired", (Object)(dataProp.getBoolean("required") ? "1" : "0"));
            row.set("paradesc", (Object)dataProp.getString(PROP_LABEL));
            row.set(KEY_PARANAME, (Object)f);
            row.set("isauto", (Object)"1");
            id = IDService.get().genLongId();
            row.set("id", (Object)id);
            row.set("pid", (Object)pid);
            row.set("confignumber", (Object)(parentField == null ? f : parentField + "." + f));
            parentFullnumber = row.getString("confignumber");
            row.set(KEY_PARALEVEL, (Object)index);
            row.set("ismultivalue", (Object)("ENTRIES".equals(dataProp.getString(DATA_TYPE)) ? "1" : "0"));
            if (row.getString("paratype").equals("ENUM")) {
                row.set("paratype", (Object)"string");
            }
        }
        if (f.equals(field)) {
            return;
        }
        this.buildTreeRows(dataEntrys, StringUtils.substringAfter((String)field, (String)(f + ".")), parentFullnumber, rowsKV, id, index, prop_entryentity);
    }

    private DynamicObject getDataTypeFromParentPropEntrys(DynamicObjectCollection prop_entryentity, String f) {
        return prop_entryentity.stream().filter(item -> item.getString(PROP_NAME).equals(f)).findFirst().get();
    }

    private DynamicObject findExistingRow(DynamicObjectCollection datas, String paranumber, int level) {
        for (DynamicObject row : datas) {
            if (!row.getString("confignumber").equals(paranumber)) continue;
            return row;
        }
        return null;
    }

    private boolean findSonRow(DynamicObjectCollection datas, DynamicObject parent) {
        for (DynamicObject row : datas) {
            if (row.getLong("pid") != parent.getLong("id")) continue;
            return true;
        }
        return false;
    }

    private void resetIsauto(DynamicObjectCollection dataEntrys, List<String> addField) {
        for (DynamicObject row : dataEntrys) {
            if (!addField.contains(row.getString("confignumber"))) continue;
            row.set("isauto", (Object)"0");
        }
    }

    private void putRowsKVInCache(DynamicObjectCollection entryentity) {
        Map<String, Object> rowsKV = this.getCacheMap();
        for (DynamicObject row : entryentity) {
            String data_schema = row.getString(DATA_SCHEMA);
            if (StringUtil.isEmpty((String)data_schema)) continue;
            rowsKV.put(row.getString(PROP_NAME), data_schema);
        }
        this.getView().getPageCache().put("rowsKV", Json.toString(rowsKV));
    }

    private Map<String, Object> getCacheMap() {
        Map<String, Object> rowsKV = new HashMap<String, Object>();
        if (null != this.getView().getPageCache().get("rowsKV")) {
            rowsKV = (Map)Json.toObject((String)this.getView().getPageCache().get("rowsKV"));
        }
        return rowsKV;
    }

    private Map<String, Object> getEntriesByRootId(String full_number) {
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (DynamicObject object : entryentity) {
            if (!full_number.equals(object.getString(FULL_NUMBER))) continue;
            for (IDataEntityProperty property : object.getDataEntityType().getProperties()) {
                map.put(property.getName(), object.get(property));
            }
        }
        return map;
    }

    private Pair<String, List<String>> getCheckedData() {
        String json = this.getView().getPageCache().get("lastCheckedData");
        List lastSelected = new ArrayList();
        if (json != null) {
            lastSelected = (List)Json.toObject((String)json);
        }
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<String> currSelected = new ArrayList<String>(selectRows.length);
        for (int index : selectRows) {
            DynamicObject row = (DynamicObject)entryentity.get(index);
            currSelected.add(row.getString(FULL_NUMBER));
        }
        this.getView().getPageCache().put("lastCheckedData", Json.toString(currSelected));
        ArrayList<String> intersection = new ArrayList<String>();
        for (String last : lastSelected) {
            for (String curr : currSelected) {
                if (!last.equals(curr)) continue;
                intersection.add(last);
            }
        }
        if (intersection.isEmpty()) {
            if (currSelected.size() > lastSelected.size()) {
                return new Pair((Object)"increase", currSelected);
            }
            return new Pair((Object)"decrease", lastSelected);
        }
        currSelected.removeAll(intersection);
        lastSelected.removeAll(intersection);
        if (currSelected.size() > lastSelected.size()) {
            return new Pair((Object)"increase", currSelected);
        }
        return new Pair((Object)"decrease", lastSelected);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        this.getView().updateView(KEY_ENTRY_ENTITY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        String text = searchEnterEvent.getText();
        if (entryEntity.size() == 0 || StringUtil.isEmpty((String)text)) {
            return;
        }
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject o = (DynamicObject)entryEntity.get(i);
            if (!o.getString(FULL_NUMBER).contains(text) && !o.getString("name").contains(text)) continue;
            indexs.add(i);
        }
        if (indexs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"ServiceFlowFieldSelectedFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] rows = indexs.stream().mapToInt(Integer::valueOf).toArray();
        grid.setRowBackcolor("#eff3fd", rows);
        grid.focusCell(rows[0], NUMBER);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            IFormView parentView = this.getView().getParentView();
            IDataModel parentModel = parentView.getModel();
            DynamicObjectCollection dataEntrys1 = parentModel.getEntryEntity(KEY_DATA_ENTRY);
            DynamicObjectCollection dataEntrys = this.getModel().getEntryEntity(KEY_DATA_ENTRY);
            for (DynamicObject data : dataEntrys1) {
                DynamicObject row = dataEntrys.addNew();
                row.set("id", data.get("id"));
                row.set("pid", data.get("pid"));
                row.set("paratype", (Object)data.getString("paratype"));
                row.set(KEY_PARANUMBER, data.get(KEY_PARANUMBER));
                row.set("isrequired", data.get("isrequired"));
                row.set("paradesc", (Object)data.getString("paradesc"));
                row.set(KEY_PARANAME, data.get(KEY_PARANAME));
                row.set("confignumber", data.get("confignumber"));
                row.set(KEY_PARALEVEL, data.get(KEY_PARALEVEL));
                row.set("ismultivalue", data.get("ismultivalue"));
                row.set("isauto", data.get("isauto"));
            }
            this.getModel().updateEntryCache(dataEntrys);
            this.getView().updateView(KEY_DATA_ENTRY);
            DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("selectedentry");
            for (DynamicObject entry : dataEntrys) {
                if (entry == null || entry.getString("isauto") == null || !entry.getString("isauto").equals("0")) continue;
                DynamicObject sel = selectedentry.addNew();
                sel.set("selected_name", entry.get(KEY_PARANUMBER));
                sel.set("selected_full_number", entry.get("confignumber"));
            }
            this.getView().updateView("selectedentry");
        }
        catch (KemException kemException) {
            // empty catch block
        }
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params == null || !params.containsKey("id")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u5143\u6570\u636eid\uff0c\u65e0\u6cd5\u83b7\u53d6\u5143\u6570\u636e\u5c5e\u6027\u3002", (String)"ServiceFlowFieldSelectedFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        String type = D.s(params.get(PARAM_TYPE));
        if (type != null) {
            this.getPageCache().put(PARAM_ROW, D.s(params.get(PARAM_ROW)));
            this.getPageCache().put(PARAM_TYPE, type);
        }
        String id = D.s(params.get("id"));
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA);
        this.getPageCache().put(ROOT, params.get("id").toString());
        this.getPageCache().put(DATA_SOURCE, meta.getString("group_id"));
        this.initTree(id, meta.getString("name"));
    }

    private void initTree(String id, String text) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.deleteAllNodes();
        treeView.setMulti(false);
        TreeNode root = new TreeNode("", id + "@REF", text);
        root.setExpend(true);
        root.setType("REF");
        root.setChildren(new ArrayList());
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand(id + "@REF");
        treeView.focusNode(root);
        this.initRootEntry();
        this.getPageCache().put("treerootnode", SerializationUtils.toJsonString((Object)root));
    }

    private void initRootEntry() {
        String rootId = this.getPageCache().get(ROOT);
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)rootId, (String)ISC_METADATA_SCHEMA);
        this.showCollection(rootId + "@REF", "", meta);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("selectedentry");
                List toList = DynamicObjectUtil.objectCollection2List((DynamicObjectCollection)selectedentry);
                ArrayList resultList = new ArrayList(toList.size());
                for (Map map : toList) {
                    HashMap e = new HashMap();
                    for (Map.Entry entry : map.entrySet()) {
                        if (!((String)entry.getKey()).contains("selected_")) continue;
                        e.put(((String)entry.getKey()).substring(9), entry.getValue());
                    }
                    resultList.add(e);
                }
                Map params = this.getView().getFormShowParameter().getCustomParams();
                params.put("resultList", resultList);
                IFormView parentView = this.getView().getParentView();
                IDataModel parentModel = parentView.getModel();
                DynamicObjectCollection dataEntrys = parentModel.getEntryEntity(KEY_DATA_ENTRY);
                dataEntrys.clear();
                DynamicObjectCollection dataEntrys1 = this.getModel().getEntryEntity(KEY_DATA_ENTRY);
                for (DynamicObject data : dataEntrys1) {
                    DynamicObject row = dataEntrys.addNew();
                    row.set("id", data.get("id"));
                    row.set("pid", data.get("pid"));
                    row.set("paratype", (Object)data.getString("paratype"));
                    row.set(KEY_PARANUMBER, data.get(KEY_PARANUMBER));
                    row.set("isrequired", data.get("isrequired"));
                    row.set("paradesc", (Object)data.getString("paradesc"));
                    row.set(KEY_PARANAME, data.get(KEY_PARANAME));
                    row.set("confignumber", data.get("confignumber"));
                    row.set(KEY_PARALEVEL, data.get(KEY_PARALEVEL));
                    row.set("ismultivalue", data.get("ismultivalue"));
                    row.set("isauto", data.get("isauto"));
                }
                parentModel.updateEntryCache(dataEntrys);
                this.getView().returnDataToParent((Object)params);
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    private Map<String, Object> getSelectedRowData(int row) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(KEY_ENTRY_ENTITY, row);
        Map map = DynamicObjectUtil.object2Map((DynamicObject)rowEntity);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("resultList", Collections.singletonList(map));
        return params;
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        try {
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
            String pNodeId = evt.getNodeId().toString();
            DynamicObject meta = pNodeId.contains(NAME_SUFFIX) ? BusinessDataServiceHelper.loadSingle((Object)pNodeId.replace(NAME_SUFFIX, ""), (String)ISC_METADATA_SCHEMA) : BusinessDataServiceHelper.loadSingle((Object)this.getPageCache().get(ROOT), (String)ISC_METADATA_SCHEMA);
            int index = pNodeId.indexOf(46);
            if (index > 0) {
                String number = pNodeId.substring(index + 1).replace("@REF", "");
                StringBuilder sb = new StringBuilder();
                DynamicObject childMeta = this.getChildMeta(meta, number, sb.append(meta.getString("name")));
                this.addTreeNodes(treeView, pNodeId, childMeta);
            } else {
                this.addTreeNodes(treeView, pNodeId, meta);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    public DynamicObject getChildMeta(DynamicObject parent, String number, StringBuilder title) {
        int index;
        String propName;
        int lastSpotIndex;
        if (!number.contains("ml_string") || (lastSpotIndex = (propName = number.substring(0, index = number.indexOf("@ml_string"))).lastIndexOf(46)) < 0) {
            // empty if block
        }
        if ((index = number.indexOf(46)) < 0) {
            boolean isMeta = number.endsWith("@meta");
            if (isMeta) {
                number = number.replace("@meta", "");
            }
            return this.getMetaPropertyEntry(parent, number, title, isMeta);
        }
        String childNumber = number.substring(0, index);
        boolean isMeta = childNumber.contains("@meta");
        if (isMeta) {
            childNumber = childNumber.replace("@meta", "");
        }
        DynamicObjectCollection properties = parent.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject property : properties) {
            if (!property.getString(PROP_NAME).equals(childNumber)) continue;
            String dataSchema = property.getString(DATA_SCHEMA);
            DynamicObject childMeta = this.getMetaBySchema(dataSchema, isMeta, parent.getLong("group_id"));
            if (title.length() > 0) {
                title.append('.');
            }
            title.append(property.getString(PROP_LABEL));
            return this.getChildMeta(childMeta, number.substring(index + 1), title);
        }
        return null;
    }

    private void buildTitleByPropEntryEntity(DynamicObject parent, StringBuilder title, String propName) {
        DynamicObjectCollection collection = parent.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject c : collection) {
            if (!propName.equals(c.getString(PROP_NAME))) continue;
            if (title.length() > 0) {
                title.append('.');
            }
            title.append(c.getString(PROP_LABEL));
            break;
        }
    }

    private DynamicObject getMetaPropertyEntry(DynamicObject parent, String number, StringBuilder title, boolean isMeta) {
        DynamicObjectCollection properties = parent.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject property : properties) {
            String propName = property.getString(PROP_NAME);
            if (!propName.equals(number)) continue;
            String schema = property.getString(DATA_SCHEMA);
            String type = property.getString(DATA_TYPE);
            if (NODE_TYPES.contains(type)) {
                DynamicObject meta = this.getMetaBySchema(schema, isMeta, parent.getLong("group_id"));
                meta.set(REMARK, (Object)type);
                String label = property.getString(PROP_LABEL);
                if (title.length() > 0) {
                    title.append('.');
                }
                title.append(StringUtil.isEmpty((String)label) ? propName : label);
                return meta;
            }
            return property;
        }
        return null;
    }

    public DynamicObject getMetaBySchema(String dataSchema, boolean isMeta, long dataSourceId) {
        if (isMeta) {
            return BusinessDataServiceHelper.loadSingle((Object)D.l((Object)dataSchema), (String)ISC_METADATA_SCHEMA);
        }
        QFilter filter = new QFilter(NUMBER, "=", (Object)dataSchema).and("group", "=", (Object)dataSourceId);
        DynamicObject meta = BusinessDataServiceHelper.loadSingleFromCache((String)ISC_METADATA_SCHEMA, (QFilter[])new QFilter[]{filter});
        if (meta != null) {
            return meta;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff08%s\uff09\u7684\u96c6\u6210\u5bf9\u8c61\u672a\u627e\u5230\uff0c\u8bf7\u540c\u6b65\u5168\u90e8\u5143\u6570\u636e\u6216\u4eba\u5de5\u6dfb\u52a0\u8be5\u96c6\u6210\u5bf9\u8c61\uff01", (String)"MetaPropertyTreePlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dataSchema));
    }

    private boolean isRoot(String id) {
        return id.equals(this.getPageCache().get(ROOT) + "@REF");
    }

    private void addTreeNodes(TreeView treeView, String pNodeId, DynamicObject childMeta) {
        String type = childMeta.getString("type");
        if (this.isRoot(pNodeId) || childMeta.getString(REMARK).equals("ENTRIES") || META_TYPES.contains(type) || pNodeId.contains("@ml_string") || pNodeId.contains("@meta")) {
            List<TreeNode> nodes = this.getMetaNodes(pNodeId, childMeta);
            treeView.addNodes(nodes);
            TreeNode root = new TreeNode();
            root.addChildren(nodes);
        }
    }

    private DynamicObject getMlStringMeta(String number) {
        long id = MetaSchemaUtil.getHashId((MetaType)MetaType.ENUM, (long)0L, (String)"ml_string");
        boolean exist = QueryServiceHelper.exists((String)ISC_METADATA_SCHEMA, (Object)id);
        if (!exist) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)ISC_METADATA_SCHEMA);
            object.set("id", (Object)id);
            DynamicObjectCollection properties = object.getDynamicObjectCollection(PROP_ENTRYENTITY);
            DynamicObject p1 = properties.addNew();
            p1.set(PROP_NAME, (Object)"zh_CN");
            p1.set(PROP_LABEL, (Object)ResManager.loadKDString((String)"\u7b80\u4f53\u4e2d\u6587", (String)"ServiceFlowFieldSelectedFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            p1.set(DATA_TYPE, (Object)"string");
            DynamicObject p2 = properties.addNew();
            p2.set(PROP_NAME, (Object)"zh_TW");
            p2.set(PROP_LABEL, (Object)ResManager.loadKDString((String)"\u7e41\u4f53\u4e2d\u6587", (String)"ServiceFlowFieldSelectedFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            p2.set(DATA_TYPE, (Object)"string");
            DynamicObject p3 = properties.addNew();
            p3.set(PROP_NAME, (Object)"en_US");
            p3.set(PROP_LABEL, (Object)ResManager.loadKDString((String)"\u82f1\u6587", (String)"ServiceFlowFieldSelectedFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            p3.set(DATA_TYPE, (Object)"string");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            return object;
        }
        if (number.contains("@ml_string.")) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA);
            DynamicObjectCollection properties = object.getDynamicObjectCollection(PROP_ENTRYENTITY);
            properties.clear();
            DynamicObject p = properties.addNew();
            if (number.contains("zh_TW")) {
                p.set(PROP_NAME, (Object)"zh_TW");
                p.set(PROP_LABEL, (Object)ResManager.loadKDString((String)"\u7e41\u4f53\u4e2d\u6587", (String)"ServiceFlowFieldSelectedFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                p.set(DATA_TYPE, (Object)"string");
            } else if (number.contains("zh_CN")) {
                p.set(PROP_NAME, (Object)"zh_CN");
                p.set(PROP_LABEL, (Object)ResManager.loadKDString((String)"\u7b80\u4f53\u4e2d\u6587", (String)"ServiceFlowFieldSelectedFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                p.set(DATA_TYPE, (Object)"string");
            } else if (number.contains("en_US")) {
                p.set(PROP_NAME, (Object)"en_US");
                p.set(PROP_LABEL, (Object)ResManager.loadKDString((String)"\u82f1\u6587", (String)"ServiceFlowFieldSelectedFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                p.set(DATA_TYPE, (Object)"string");
            }
            return object;
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA);
    }

    private List<TreeNode> getMetaNodes(String pNodeId, DynamicObject schema) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection properties = schema.getDynamicObjectCollection(PROP_ENTRYENTITY);
        this.putRowsKVInCache(properties);
        for (DynamicObject o : properties) {
            String text;
            TreeNode childNode = new TreeNode();
            String type = o.getString(DATA_TYPE);
            String name = o.getString(PROP_NAME);
            if (NODE_TYPES.contains(type)) {
                if (type.contains("meta")) {
                    String metaId = pNodeId.replace("@REF", "");
                    childNode.setId(metaId + "." + name + "@meta");
                    this.getPageCache().put(name, o.getString(DATA_SCHEMA));
                } else {
                    childNode.setId(pNodeId.replace("@REF", "") + "." + name + "@REF");
                }
                childNode.setChildren(new ArrayList());
            } else {
                childNode.setId(pNodeId.replace("@REF", "") + "." + name);
            }
            childNode.setType(type);
            childNode.setParentid(pNodeId);
            String label = o.getString(PROP_LABEL);
            String string = text = StringUtil.isEmpty((String)label) ? name : label;
            if (!StringUtil.isEmpty((String)type) && ("ENTRIES".equals(type) || type.contains("list"))) {
                text = text + " [ ]";
            }
            childNode.setText(text);
            childNodes.add(childNode);
        }
        return childNodes;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        try {
            String nodeId = evt.getNodeId().toString();
            String parentNode = evt.getParentNodeId().toString();
            if (this.isRoot(nodeId)) {
                this.initRootEntry();
            } else {
                StringBuilder sb;
                String number = nodeId.substring(nodeId.indexOf(46) + 1).replace("@REF", "");
                String metaId = nodeId.substring(0, nodeId.indexOf(46)).replace("@REF", "").replace("@meta", "").replace(NAME_SUFFIX, "");
                DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)ISC_METADATA_SCHEMA);
                DynamicObject childMeta = this.getChildMeta(parent, number, sb = new StringBuilder());
                if (childMeta == null) {
                    return;
                }
                String entryType = childMeta.getDynamicObjectType().getName();
                if (entryType.equals(PROP_ENTRYENTITY)) {
                    this.showOne(parentNode, sb.toString(), childMeta);
                } else {
                    this.showCollection(nodeId, sb.toString(), childMeta);
                }
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    private void showOne(String parentNode, String parentName, DynamicObject meta) {
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY);
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        DynamicObject row = entry.addNew();
        boolean isSelected = false;
        if (meta.getDynamicObjectType().getName().equals(PROP_ENTRYENTITY)) {
            this.copyProperty2Entry(parentNode, parentName, meta, row);
            Set<String> selectedFullName = this.getSelectedFullName();
            if (selectedFullName.contains(row.getString(FULL_NUMBER))) {
                isSelected = true;
            }
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
        EntryGrid entry_c = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
        if (isSelected) {
            entry_c.selectRows(0);
        }
        this.putSelectedRowsInCache(entry, entry_c);
    }

    private void showCollection(String currentNode, String currentName, DynamicObject meta) {
        Set<String> selectedFullName = this.getSelectedFullName();
        ArrayList<Integer> arr = new ArrayList<Integer>();
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY);
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        DynamicObjectCollection properties = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        int j = 0;
        for (DynamicObject p : properties) {
            DynamicObject row = entry.addNew();
            this.copyProperty2Entry(currentNode, currentName, p, row);
            if (selectedFullName.contains(row.getString(FULL_NUMBER))) {
                arr.add(j);
            }
            ++j;
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
        EntryGrid entry_c = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
        if (!arr.isEmpty()) {
            int[] integers = new int[arr.size()];
            for (int i = 0; i < arr.size(); ++i) {
                integers[i] = (Integer)arr.get(i);
            }
            entry_c.selectRows(integers, integers[0]);
        }
        this.putSelectedRowsInCache(entry, entry_c);
    }

    private Set<String> getSelectedFullName() {
        HashSet<String> selected = new HashSet<String>();
        DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("selectedentry");
        for (DynamicObject object : selectedentry) {
            selected.add(object.getString("selected_full_number"));
        }
        return selected;
    }

    private void copyProperty2Entry(String parentNode, String parentName, DynamicObject p, DynamicObject row) {
        row.set(NUMBER, (Object)p.getString(PROP_NAME));
        row.set("name", (Object)p.getString(PROP_LABEL));
        row.set(DATA_TYPE, (Object)p.getString(DATA_TYPE));
        row.set(DATA_SCHEMA, (Object)p.getString(DATA_SCHEMA));
        row.set("is_primary_key", p.get("is_primary_key"));
        row.set("required", p.get("required"));
        row.set(REMARK, p.get("prop_remark"));
        row.set("full_name", (Object)this.getFullName(parentName, p));
        String rootId = this.getPageCache().get(ROOT);
        if (this.isRoot(parentNode)) {
            row.set(FULL_NUMBER, (Object)p.getString(PROP_NAME));
        } else if (parentNode.contains("@REF")) {
            row.set(FULL_NUMBER, (Object)(parentNode.replace(rootId + ".", "").replace("@REF", "").replace("@meta", "") + "." + p.getString(PROP_NAME)));
        } else if (parentNode.contains("@ml_string")) {
            if (parentNode.endsWith("@ml_string")) {
                row.set(FULL_NUMBER, (Object)(parentNode.replace(rootId + ".", "").replace("@ml_string", "") + "." + p.getString(PROP_NAME)));
            } else {
                row.set(FULL_NUMBER, (Object)parentNode.replace(rootId + ".", "").replace("@ml_string", ""));
            }
        } else if (parentNode.contains("@meta")) {
            int index = parentNode.indexOf(46);
            row.set(FULL_NUMBER, (Object)(parentNode.substring(index + 1).replace("@meta", "") + "." + p.getString(PROP_NAME)));
        }
    }

    private String getFullName(String parentName, DynamicObject p) {
        return (StringUtil.isEmpty((String)parentName) ? "" : parentName + ".") + p.getString(PROP_LABEL);
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Map<String, Object> data = this.getSelectedRowData(evt.getRow());
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (DATA_SCHEMA.equals(evt.getFieldName()) && evt.getRowIndex() >= 0) {
            Object dataSourceId;
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
            DynamicObject entry = (DynamicObject)collection.get(evt.getRowIndex());
            String dataSchema = entry.getString(DATA_SCHEMA);
            String dataType = entry.getString(DATA_TYPE);
            String fullNumber = entry.getString(FULL_NUMBER);
            int index = fullNumber.indexOf(46);
            String parentNumber = index > 0 ? fullNumber.substring(0, index) : fullNumber;
            long metaId = D.l((Object)this.getPageCache().get(parentNumber));
            if (metaId > 0L) {
                DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)ISC_METADATA_SCHEMA);
                dataSourceId = parent.getLong("group_id");
            } else {
                dataSourceId = this.getPageCache().get(DATA_SOURCE);
            }
            MetadataSchemaFormPlugin.openRefMeta((AbstractFormPlugin)this, (Object)dataSourceId, (String)dataSchema, (String)dataType);
        }
    }
}

