/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.event.doc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeBuildTreeNodeEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.isc.kem.common.constants.ParamType;
import kd.isc.kem.form.util.ParamDataPreviewUtil;

public class KemEventDocPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    private static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";
    private static final String FORM_KEM_EVENT = "kem_event";
    private static final String KEY_APP_TREE = "treeview";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildAnchorCtl();
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1,btnnew,btnedit,btndel"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (null == this.getPageCache().get("new")) {
            this.getPageCache().put("new", "0");
            this.buildTree();
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void beforeBuildTreeNode(BeforeBuildTreeNodeEvent e) {
        super.beforeBuildTreeNode(e);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString().replace("evt_", "");
        try {
            if (QueryServiceHelper.exists((String)FORM_KEM_EVENT, (Object)Long.valueOf(nodeId))) {
                DynamicObject event = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(nodeId), (String)FORM_KEM_EVENT);
                this.buildMdText(event);
            }
        }
        catch (Exception e2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"KemEventDocPlugin_20", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void buildMdText(DynamicObject data) {
        Markdown mk = (Markdown)this.getView().getControl("markdownap");
        StringBuilder str = new StringBuilder();
        str.append("# ");
        str.append(data.get("name"));
        str.append("  \n");
        str.append(ResManager.loadKDString((String)"## \u57fa\u672c\u4fe1\u606f", (String)"KemEventDocPlugin_4", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        str.append('\n');
        str.append(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u7f16\u7801\uff1a%s", (String)"KemEventDocPlugin_5", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), data.get("number")));
        str.append("  \n");
        str.append(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u7c7b\u578b\uff1a%s", (String)"KemEventDocPlugin_6", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), this.getEventtypeName(data.getInt("eventtype"))));
        str.append("  \n");
        str.append(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u8bf4\u660e\uff1a%s", (String)"KemEventDocPlugin_7", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), data.get("describe")));
        str.append("  \n");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = data.getDate("modifytime");
        str.append(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u65f6\u95f4\uff1a%s", (String)"KemEventDocPlugin_8", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), sdf1.format(date)));
        str.append("  \n");
        mk.setText(str.toString());
        str.append("  \n");
        Markdown mk1 = (Markdown)this.getView().getControl("markdown_header");
        StringBuilder mkheader = new StringBuilder();
        mkheader.append(ResManager.loadKDString((String)"## Headers\u53c2\u6570\u8bf4\u660e", (String)"KemEventDocPlugin_9", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        mkheader.append('\n');
        mkheader.append(ResManager.loadKDString((String)"| \u53c2\u6570\u540d\u79f0 | \u5b57\u6bb5\u7c7b\u578b  | \u5fc5\u586b | \u793a\u4f8b\u503c  | \u8bf4\u660e  | ", (String)"KemEventDocPlugin_10", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        mkheader.append("  \n");
        mkheader.append("| :----  |  :----  |  :----  |  :----  |  :----  |");
        mkheader.append("  \n");
        DynamicObjectCollection contextEntry = data.getDynamicObjectCollection("context_entry");
        for (DynamicObject row : contextEntry) {
            mkheader.append("| ");
            mkheader.append(row.get("hd_paraname"));
            mkheader.append(" | ");
            mkheader.append(ParamType.getParamType((String)row.getString("hd_paratype")).getTypeName());
            mkheader.append(" | ");
            mkheader.append(row.get("hd_isrequired"));
            mkheader.append(" | ");
            mkheader.append(row.get("hd_example"));
            mkheader.append(" | ");
            mkheader.append(row.get("hd_paradesc"));
            mkheader.append(" |");
            mkheader.append("  \n");
        }
        mk1.setText(mkheader.toString());
        Markdown mk2 = (Markdown)this.getView().getControl("markdown_data");
        StringBuilder mkbody = new StringBuilder();
        mkbody.append(ResManager.loadKDString((String)"## \u4e8b\u4ef6\u53c2\u6570\u8bf4\u660e", (String)"KemEventDocPlugin_11", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        mkbody.append('\n');
        mkbody.append(ResManager.loadKDString((String)"| \u53c2\u6570\u540d\u79f0    | \u53c2\u6570\u7c7b\u578b    | \u591a\u503c  | \u8bf4\u660e  | \u5c42\u7ea7  | \u793a\u4f8b  | ", (String)"KemEventDocPlugin_12", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        mkbody.append("  \n");
        mkbody.append("| :----  |  :----  |  :----  |  :----  |  :----  |  :----  |");
        mkbody.append("  \n");
        DynamicObjectCollection dataEntry = data.getDynamicObjectCollection("data_entry");
        DynamicObjectCollection dataEntry1 = (DynamicObjectCollection)dataEntry.clone();
        for (DynamicObject row : dataEntry) {
            mkbody = this.paramterListBuilder(mkbody, row);
        }
        mk2.setText(mkbody.toString());
        Markdown mk3 = (Markdown)this.getView().getControl("markdown_json");
        StringBuilder str3 = new StringBuilder();
        str3.append(ResManager.loadKDString((String)"## \u53c2\u6570\u793a\u4f8b", (String)"KemEventDocPlugin_13", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        str3.append('\n');
        StringBuilder jsonbody = new StringBuilder();
        jsonbody.append("```json");
        jsonbody.append(" \n");
        Map<String, Object> result = KemEventDocPlugin.getResultData(data.getDynamicObjectCollection("data_entry"), "paratype", "paraname", "data_example");
        String bodyExample = "";
        Object object = ParamDataPreviewUtil.getCustomParams("data_entry", dataEntry1);
        bodyExample = JSON.toJSONString((Object)JSONObject.toJSON((Object)object), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        jsonbody.append(bodyExample);
        jsonbody.append(" \n");
        jsonbody.append("```");
        str3.append((CharSequence)jsonbody);
        mk3.setText(str3.toString());
    }

    private void buildAnchorCtl() {
        AnchorControl anchorCtl = (AnchorControl)this.getView().getControl("anchorcontrolap");
        ArrayList<AnchorItems> items = new ArrayList<AnchorItems>();
        items.add(new AnchorItems("markdownap", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"KemEventDocPlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), null));
        items.add(new AnchorItems("markdown_data", ResManager.loadKDString((String)"\u4e8b\u4ef6\u53c2\u6570\u8bf4\u660e", (String)"KemEventDocPlugin_2", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), null));
        items.add(new AnchorItems("markdown_json", ResManager.loadKDString((String)"\u53c2\u6570\u793a\u4f8b", (String)"KemEventDocPlugin_3", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), null));
        anchorCtl.addItems(items);
    }

    private void buildTree() {
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        List nodes = root.getChildren();
        if (nodes == null) {
            return;
        }
        DynamicObjectCollection events = QueryServiceHelper.query((String)FORM_KEM_EVENT, (String)"Id,name,number,group.id", (QFilter[])new QFilter("enable", "=", (Object)"1").toArray());
        if (events.size() <= 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"no_data_flex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"no_data_flex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
        }
        Map<String, List<DynamicObject>> groupMap = events.stream().collect(Collectors.groupingBy(it -> it.getString("group.id")));
        block0: for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
            String groupId = entry.getKey();
            List<DynamicObject> groupList = entry.getValue();
            for (TreeNode node : nodes) {
                if (node.getChildren() != null) {
                    this.addChildNode(node, groupId, groupList);
                }
                if (!node.getId().equals(groupId)) continue;
                node.addChildren(this.buildNodeByGroup(groupId, groupList));
                continue block0;
            }
        }
        ArrayList<TreeNode> nodesR = new ArrayList<TreeNode>();
        for (TreeNode node : nodes) {
            if (node.getChildren() != null) {
                this.removeNodeByList(node);
                continue;
            }
            nodesR.add(node);
        }
        for (TreeNode treeNode : nodesR) {
            nodes.remove(treeNode);
        }
        for (TreeNode trNode : nodes) {
            if (trNode.getChildren() != null) {
                this.rebuildEvtNode(trNode);
                continue;
            }
            if (!trNode.getId().contains("evt_")) continue;
            trNode.setId(trNode.getId().replace("evt_", ""));
        }
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getTreeModel().setRoot(root);
        this.getView().updateView(KEY_APP_TREE);
        this.defaultClickFirstNode(root.getChildren());
    }

    private void addChildNode(TreeNode node, String groupId, List<DynamicObject> groupList) {
        for (TreeNode child : node.getChildren()) {
            if (child.getChildren() != null) {
                this.addChildNode(child, groupId, groupList);
            }
            if (!child.getId().equals(groupId)) continue;
            child.addChildren(this.buildNodeByGroup(groupId, groupList));
            break;
        }
    }

    private void removeNodeByList(TreeNode node) {
        if (null == node.getChildren() && node.getId().contains("evt_")) {
            return;
        }
        List nodes = node.getChildren();
        ArrayList<TreeNode> nodesR = new ArrayList<TreeNode>();
        for (TreeNode node1 : nodes) {
            if (node1.getChildren() == null && !node1.getId().contains("evt_")) {
                nodesR.add(node1);
                continue;
            }
            this.removeNodeByList(node1);
        }
        for (TreeNode treeNode : nodesR) {
            nodes.remove(treeNode);
        }
    }

    private void rebuildEvtNode(TreeNode node) {
        if (null == node.getChildren() && node.getId().contains("evt_")) {
            node.setId(node.getId().replace("evt_", ""));
            return;
        }
        List nodes = node.getChildren();
        for (TreeNode trNode : nodes) {
            if (trNode.getChildren() != null) {
                this.rebuildEvtNode(trNode);
                continue;
            }
            if (!trNode.getId().contains("evt_")) continue;
            trNode.setId(trNode.getId().replace("evt_", ""));
        }
    }

    private void defaultClickFirstNode(List<TreeNode> nodes) {
        if (null != this.getPageCache().get("focusId")) {
            return;
        }
        for (TreeNode node : nodes) {
            List childNodes = node.getChildren();
            if (!CollectionUtils.isEmpty((Collection)childNodes)) {
                this.defaultClickFirstNode(childNodes);
                continue;
            }
            TreeNode showApiInfoNode = nodes.get(0);
            TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
            if (null == showApiInfoNode || null == showApiInfoNode.getParentid() || null == showApiInfoNode.getId() || null != showApiInfoNode.getChildren()) continue;
            treeView.showNode(showApiInfoNode.getParentid());
            this.getPageCache().put("focusId", showApiInfoNode.getId());
            treeView.focusNode(showApiInfoNode);
            this.getTreeListView().getTreeView().treeNodeClick(showApiInfoNode.getParentid(), showApiInfoNode.getId());
            break;
        }
    }

    private List<TreeNode> buildNodeByGroup(String groupId, List<DynamicObject> events) {
        ArrayList<TreeNode> groupChildren = new ArrayList<TreeNode>(events.size());
        for (DynamicObject event : events) {
            TreeNode node = new TreeNode(groupId, "evt_" + event.getString("Id"), event.getString("name"));
            node.setIcon("kdfont kdfont-shijianyuan");
            groupChildren.add(node);
        }
        return groupChildren;
    }

    public static Map<String, Object> getResultData(DynamicObjectCollection collection, String typeKey, String nameKey, String valueKey) {
        Iterator iterator = collection.iterator();
        ArrayList<DynamicObject> tops = new ArrayList<DynamicObject>(10);
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            if (0L != dynamicObject.getLong("pid")) continue;
            tops.add(dynamicObject);
            iterator.remove();
        }
        Map<String, Object> resultMap = KemEventDocPlugin.packageJsonFormat(collection, tops, typeKey, nameKey, valueKey);
        return resultMap;
    }

    private static Map<String, Object> packageJsonFormat(DynamicObjectCollection dynamicObjects, List<DynamicObject> tops, String typeKey, String nameKey, String valueKey) {
        LinkedHashMap<String, Object> responseMap = new LinkedHashMap<String, Object>(16);
        for (DynamicObject top : tops) {
            String key = top.getString(nameKey).trim();
            String type = top.getString(typeKey).trim();
            if (!type.equals("STRUCT")) {
                responseMap.put(key, top.getString(valueKey));
                continue;
            }
            if (type.equals("STRUCT")) {
                responseMap.put(key, KemEventDocPlugin.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, top));
                continue;
            }
            responseMap.put(key, KemEventDocPlugin.packageJsonFormat(dynamicObjects, top, typeKey, nameKey, valueKey));
        }
        return responseMap;
    }

    private static Map<String, Object> packageJsonFormat(DynamicObjectCollection dynamicObjects, DynamicObject object, String typeKey, String nameKey, String valueKey) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(16);
        for (DynamicObject response : dynamicObjects) {
            String type = response.getString(typeKey);
            String key = response.getString(nameKey);
            String value = response.getString(valueKey);
            if (!object.getPkValue().toString().equals(response.getString("pid"))) continue;
            if (type.equals("STRUCT")) {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
                data.putAll(KemEventDocPlugin.packageJsonFormat(dynamicObjects, response, typeKey, nameKey, valueKey));
                result.put(key, data);
                continue;
            }
            if (type.equals("")) {
                result.put(key, value);
                continue;
            }
            result.put(key, KemEventDocPlugin.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, response));
        }
        return result;
    }

    private static List<Object> getArrayFormatData(DynamicObjectCollection dynamicObjects, String typeKey, String nameKey, String valueKey, DynamicObject parent) {
        ArrayList<Object> list = new ArrayList<Object>(1);
        int filedCount = 0;
        int subFiledCount = 0;
        for (DynamicObject response : dynamicObjects) {
            String type = response.getString(typeKey);
            String key = response.getString(nameKey);
            if (!parent.getPkValue().toString().equals(response.getString("pid"))) continue;
            ++subFiledCount;
            if (!StringUtils.isBlank((CharSequence)key)) continue;
            ++filedCount;
            if (type.equals("STRUCT")) {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
                data.putAll(KemEventDocPlugin.packageJsonFormat(dynamicObjects, response, typeKey, nameKey, valueKey));
                list.add(data);
                continue;
            }
            if (type.equals("")) {
                list.add("a");
                continue;
            }
            list.add(KemEventDocPlugin.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, response));
        }
        if (filedCount == subFiledCount) {
            return list;
        }
        list.clear();
        list.add(KemEventDocPlugin.packageJsonFormat(dynamicObjects, parent, typeKey, nameKey, valueKey));
        return list;
    }

    private String getEventtypeName(int type) {
        String eventtypeName = "";
        switch (type) {
            case 0: {
                eventtypeName = ResManager.loadKDString((String)"\u5185\u90e8\u4e8b\u4ef6", (String)"KemEventDocPlugin_14", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
            case 1: {
                eventtypeName = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u4e8b\u4ef6", (String)"KemEventDocPlugin_15", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
            case 2: {
                eventtypeName = "Webhook";
                break;
            }
            case 3: {
                eventtypeName = ResManager.loadKDString((String)"\u8f6e\u8be2\u4e8b\u4ef6", (String)"KemEventDocPlugin_16", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
            case 4: {
                eventtypeName = ResManager.loadKDString((String)"MQ\u6d88\u606f", (String)"KemEventDocPlugin_17", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
            case 5: {
                eventtypeName = ResManager.loadKDString((String)"\u64cd\u4f5c\u4e8b\u4ef6", (String)"KemEventDocPlugin_21", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]);
                break;
            }
        }
        return eventtypeName;
    }

    private StringBuilder paramterListBuilder(StringBuilder str, DynamicObject data) {
        str.append("| ");
        for (int i = 1; i < data.getInt("paralevel"); ++i) {
            str.append("&nbsp;&nbsp;");
        }
        str.append(data.get("paraname"));
        str.append(" | ");
        str.append(ParamType.getParamType((String)data.getString("paratype")).getTypeName());
        str.append(" | ");
        str.append(data.get("ismultivalue").equals("1") ? ResManager.loadKDString((String)"\u662f", (String)"KemEventDocPlugin_18", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"KemEventDocPlugin_19", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        str.append(" | ");
        str.append(data.getLocaleString("paradesc").getLocaleValue() == null ? "" : data.getLocaleString("paradesc").getLocaleValue());
        str.append(" | ");
        str.append(data.get("paralevel"));
        str.append(" | ");
        str.append(data.get("data_example"));
        str.append(" |");
        str.append("  \n");
        return str;
    }
}

