/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.home;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.EventObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.PieChart;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.isc.kem.form.plugin.home.util.KemCustomChartHelper;

public class KemEventCardPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.drawChart();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.drawChart();
    }

    private void drawChart() {
        String time = (String)this.getModel().getValue("time");
        LocalDateTime dateTime = LocalDateTime.now();
        LocalDateTime dateTimeY = null;
        if (time.equals("3")) {
            dateTimeY = dateTime.plusMonths(-1L);
        } else if (time.equals("2")) {
            dateTimeY = dateTime.plusWeeks(-1L);
        } else if (time.equals("1")) {
            dateTimeY = dateTime.plusDays(-1L);
        } else if (time.equals("4")) {
            dateTimeY = dateTime.plusYears(-1L);
        } else if (time.equals("5")) {
            dateTimeY = null;
        }
        QFilter qFilter = new QFilter("opdate", "<", (Object)Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant()));
        if (dateTimeY != null) {
            qFilter.and(new QFilter("opdate", ">", (Object)Date.from(dateTimeY.atZone(ZoneId.systemDefault()).toInstant())));
        }
        qFilter.and(new QFilter("nodetype", "=", (Object)"4"));
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        KemCustomChartHelper chartHelper = new KemCustomChartHelper();
        KemCustomChartHelper.drawChart(pieChart, qFilter);
        pieChart.refresh();
    }
}

