/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.home;

import java.time.LocalDate;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.kem.form.plugin.home.util.KemCustomChartHelper;

public class KemLogCardPlugin
extends AbstractFormPlugin {
    private static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LocalDate now = LocalDate.now();
        this.getModel().setValue("dateend", (Object)new Date());
        this.getModel().setValue("datestart", (Object)KemCustomChartHelper.localDateToDate(now.minusDays(14L)));
        this.drawChart();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.drawChart();
    }

    private void drawChart() {
        PointLineChart customchart = (PointLineChart)this.getControl("pointlinechartap");
        Date datestart = (Date)this.getModel().getValue("datestart");
        Date dateend = (Date)this.getModel().getValue("dateend");
        LocalDate now = LocalDate.now();
        KemCustomChartHelper chartHelper = new KemCustomChartHelper();
        if (null != datestart && null != dateend) {
            LocalDate datestart_l = KemCustomChartHelper.dateToLocalDate(datestart);
            LocalDate dateend_l = KemCustomChartHelper.dateToLocalDate(dateend);
            Long days = dateend_l.toEpochDay() - datestart_l.toEpochDay();
            if (datestart_l.isAfter(now) || dateend_l.isAfter(now)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u65e5\u671f\u4e4b\u524d\u65e5\u671f", (String)"KemLogCardPlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                KemCustomChartHelper.drawChart(customchart, null, null, 7, 14);
            } else if (days > 14L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c11\u4e8e15\u65e5", (String)"KemLogCardPlugin_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                KemCustomChartHelper.drawChart(customchart, null, null, 7, 14);
            } else {
                KemCustomChartHelper.drawChart(customchart, datestart_l, dateend_l, 7, Integer.parseInt(String.valueOf(days)));
            }
        } else {
            KemCustomChartHelper.drawChart(customchart, null, null, 7, 14);
        }
    }
}

