/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.home;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;

public class KemRuntimeCardPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.buildData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.buildData();
    }

    private void buildData() {
        Label num1 = (Label)this.getControl("num_event_trigger");
        Label num2 = (Label)this.getControl("num_event_send");
        Label num3 = (Label)this.getControl("num_success_send");
        Label num4 = (Label)this.getControl("num_fail_send");
        Label num5 = (Label)this.getControl("num_failure_rate");
        String time = (String)this.getModel().getValue("time");
        LocalDateTime dateTime = LocalDateTime.now();
        LocalDateTime dateTimeY = null;
        if (time.equals("3")) {
            dateTimeY = dateTime.plusMonths(-1L);
        } else if (time.equals("2")) {
            dateTimeY = dateTime.plusWeeks(-1L);
        } else if (time.equals("1")) {
            dateTimeY = dateTime.plusDays(-1L);
        } else if (time.equals("4")) {
            dateTimeY = dateTime.plusYears(-1L);
        } else if (time.equals("5")) {
            dateTimeY = null;
        }
        QFilter qFilter = new QFilter("opdate", "<", (Object)Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant()));
        if (dateTimeY != null) {
            qFilter.and(new QFilter("opdate", ">", (Object)Date.from(dateTimeY.atZone(ZoneId.systemDefault()).toInstant())));
        }
        QFilter qFilter1 = new QFilter("nodetype", "=", (Object)"1");
        qFilter1.and(qFilter);
        DynamicObjectCollection coll = LogORM.create().query("kem_nodelog", "id,status", qFilter1.toArray(), 100000, 0);
        num1.setText(coll.size() + "");
        qFilter.and(new QFilter("nodetype", "=", (Object)"4"));
        DynamicObjectCollection nodecoll = LogORM.create().query("kem_nodelog", "id,status", qFilter.toArray(), 100000, 0);
        BigDecimal allDecimal = new BigDecimal(nodecoll.size());
        num2.setText(allDecimal.toString());
        Map<Object, List<DynamicObject>> nodeLogs = nodecoll.stream().collect(Collectors.groupingBy(it -> it.getString("status")));
        num3.setText(nodeLogs.get("1") == null ? "0" : nodeLogs.get("1").size() + "");
        int failNum = nodeLogs.get("0") == null ? 0 : nodeLogs.get("0").size();
        BigDecimal failDecimal = new BigDecimal(failNum);
        num4.setText(failDecimal.toString());
        String pr = failDecimal.compareTo(BigDecimal.ZERO) == 0 ? "0" : failDecimal.divide(allDecimal, 2, 4).multiply(new BigDecimal("100")).toString();
        num5.setText(pr);
    }
}

