/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.home.util;

import java.lang.constant.Constable;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.BindingContext;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;

public class KemCustomChartHelper {
    private static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";

    public static void drawChart(PieChart pieChart, QFilter qFilter) {
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        pieChart.setMargin(Position.right, "30px");
        pieChart.setMargin(Position.top, "30px");
        pieChart.setMargin(Position.bottom, "10px");
        pieChart.setMargin(Position.left, "20px");
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u6570\u91cf", (String)"KemCustomChartHelper_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        series.setRadius("50%");
        ItemValue[] data = new ItemValue[6];
        Integer restapi = 0;
        Integer msg = 0;
        Integer iscsf = 0;
        Integer script = 0;
        Integer webhook = 0;
        Integer PBC = 0;
        int count = LogORM.create().count("kem_nodelog", qFilter.toArray());
        DynamicObjectCollection subs = LogORM.create().query("kem_nodelog", "id,nodetype,status,opdate,actiontypeid", qFilter.toArray(), count + 1000, 0);
        if (null != subs && subs.size() > 0) {
            for (DynamicObject sub : subs) {
                String type = sub.getString("actiontypeid");
                if (null == type) continue;
                switch (type) {
                    case "1747936013336003584": {
                        restapi = restapi + 1;
                        break;
                    }
                    case "1750762895362253824": {
                        msg = msg + 1;
                        break;
                    }
                    case "1748459576048512000": {
                        iscsf = iscsf + 1;
                        break;
                    }
                    case "1778927783993473024": {
                        script = script + 1;
                        break;
                    }
                    case "1807312232040634368": {
                        webhook = webhook + 1;
                        break;
                    }
                    case "1827503781483471872": {
                        PBC = PBC + 1;
                        break;
                    }
                }
            }
        }
        List<Integer> numbers = new ArrayList<Integer>();
        numbers.add(restapi);
        numbers.add(msg);
        numbers.add(iscsf);
        numbers.add(script);
        numbers.add(webhook);
        numbers.add(PBC);
        numbers = numbers.stream().sorted(Comparator.comparing(Number::floatValue)).collect(Collectors.toList());
        ItemValue data1 = new ItemValue("WebAPI", (Number)restapi, "#40A9FF");
        ItemValue data2 = new ItemValue(ResManager.loadKDString((String)"\u6d88\u606f\u6e20\u9053", (String)"KemCustomChartHelper_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), (Number)msg, "#FFC53D");
        ItemValue data3 = new ItemValue(ResManager.loadKDString((String)"\u6d41\u7a0b\u670d\u52a1", (String)"KemCustomChartHelper_2", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), (Number)iscsf, "#ffd52e");
        ItemValue data4 = new ItemValue(ResManager.loadKDString((String)"\u811a\u672c\u670d\u52a1", (String)"KemCustomChartHelper_3", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), (Number)script, "#701df0");
        ItemValue data5 = new ItemValue("WebHook", (Number)webhook, "#73D13D");
        ItemValue data6 = new ItemValue("PBC", (Number)PBC, "#45DAD1");
        data[0] = data1;
        data[1] = data2;
        data[2] = data3;
        data[3] = data4;
        data[4] = data5;
        data[5] = data6;
        series.setData(data);
        series.setPropValue("selectedMode", (Object)"single");
        pieChart.setLegendVertical(true);
        pieChart.setLegendPropValue("itemHeight", (Object)10);
        pieChart.setLegendPropValue("itemWidth", (Object)10);
        pieChart.setLegendAlign(XAlign.right, YAlign.center);
        pieChart.setShowLegend(true);
    }

    public static void drawChart(PointLineChart customchart, LocalDate datestart, LocalDate dateend, int type, int days) {
        QFilter qFilter = null;
        if (null != datestart && null != dateend) {
            qFilter = new QFilter("opdate", ">=", (Object)KemCustomChartHelper.localDateToDate(datestart));
            qFilter.and(new QFilter("opdate", "<=", (Object)KemCustomChartHelper.localDateToDate(dateend.plusDays(1L))));
        } else {
            LocalDate now = LocalDate.now();
            qFilter = new QFilter("opdate", ">=", (Object)KemCustomChartHelper.localDateToDate(now.plusDays(-15L)));
            qFilter.and(new QFilter("opdate", "<=", (Object)KemCustomChartHelper.localDateToDate(now.plusDays(1L))));
            dateend = now;
        }
        int count = LogORM.create().count("kem_nodelog", qFilter.toArray());
        DynamicObjectCollection datas = LogORM.create().query("kem_nodelog", "id,nodetype,status,opdate", qFilter.toArray(), count + 1000, 0);
        customchart.clearData();
        KemCustomChartHelper.setHandlechartXaxisTick(customchart, type, days, dateend);
        KemCustomChartHelper.setHandleChartData(customchart, (List<DynamicObject>)datas, type, days, dateend);
        customchart.setMargin(Position.right, "30px");
        customchart.setMargin(Position.top, "90px");
    }

    private static Axis setHandlechartXaxisTick(PointLineChart customchart, int type, int days, LocalDate dateend) {
        LocalDate date = LocalDate.now();
        if (null != dateend) {
            date = dateend;
        }
        ArrayList<String> xDimensions = new ArrayList<String>(days);
        Axis xAxis = null;
        xAxis = customchart.createXAxis(ResManager.loadKDString((String)"\u65e5", (String)"KemCustomChartHelper_5", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), AxisType.category);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM.dd");
        for (int i = days; i >= 0; --i) {
            xDimensions.add(date.minusDays(i).format(formatter) + "");
        }
        if (xAxis != null) {
            xAxis.setCategorys(xDimensions);
            HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
            axisTick.put("interval", Integer.valueOf(0));
            axisTick.put("show", Boolean.FALSE);
            xAxis.setPropValue("axisTick", axisTick);
            KemCustomChartHelper.setLineColor(xAxis, "#999999");
        }
        return xAxis;
    }

    private static void setHandleChartData(PointLineChart customchart, List<DynamicObject> datas, int type, int days, LocalDate dateend) {
        Axis yAxis = customchart.createYAxis(ResManager.loadKDString((String)"\u6570\u91cf/\u6b21", (String)"KemCustomChartHelper_6", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisTick", axisTick);
        List<DynamicObject> collection = datas;
        LineSeries expireSeries = customchart.createSeries(ResManager.loadKDString((String)"\u89e6\u53d1\u6570", (String)"KemCustomChartHelper_7", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        expireSeries.setItemColor("#45DAD1");
        Number[] handleData = KemCustomChartHelper.getTrendChartData(collection, 1, days, dateend);
        expireSeries.setData(handleData);
        LineSeries expireSeries1 = customchart.createSeries(ResManager.loadKDString((String)"\u6295\u9012\u6570", (String)"KemCustomChartHelper_8", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        Number[] handleTaskData1 = KemCustomChartHelper.getTrendChartData(collection, 4, days, dateend);
        expireSeries1.setItemColor("#40A9FF");
        expireSeries1.setData(handleTaskData1);
        LineSeries expireSeries2 = customchart.createSeries(ResManager.loadKDString((String)"\u5931\u8d25\u6570", (String)"KemCustomChartHelper_9", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        Number[] handleTaskData2 = KemCustomChartHelper.getTrendChartData(collection, 0, days, dateend);
        expireSeries2.setItemColor("#f90d58");
        expireSeries2.setData(handleTaskData2);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("splitLine", splitLine);
        KemCustomChartHelper.setLineColor(yAxis, "#999999");
        customchart.setShowLegend(true);
        customchart.setLegendAlign(XAlign.center, YAlign.top);
        customchart.setShowTooltip(true);
        customchart.setLegendVertical(false);
        int[] padding = new int[]{10, 100, 0, 0};
        customchart.setLegendPropValue("padding", (Object)padding);
        customchart.bindData((BindingContext)null);
    }

    private static Double[] getTrendChartData(List<DynamicObject> collection, int type, int days, LocalDate dateend) {
        LinkedHashMap<String, Double> dataMap = new LinkedHashMap<String, Double>();
        Map<String, List<DynamicObject>> groupByNodetypeMap = null;
        if (collection != null) {
            groupByNodetypeMap = collection.stream().collect(Collectors.groupingBy(it -> it.getString("nodetype")));
        }
        if (null == groupByNodetypeMap || groupByNodetypeMap.size() <= 0) {
            return new Double[0];
        }
        List<Object> datas = null;
        if (type == 1) {
            datas = groupByNodetypeMap.get("1");
        } else if (type == 4) {
            datas = groupByNodetypeMap.get("4");
        } else {
            List<DynamicObject> datas4 = groupByNodetypeMap.get("4");
            if (null != datas4) {
                datas = datas4.stream().filter(a -> a.getString("status").equals("0")).collect(Collectors.toList());
            }
        }
        KemCustomChartHelper.setXYaxis(dataMap, type, days, dateend);
        if (null != groupByNodetypeMap && groupByNodetypeMap.size() > 0 && datas != null) {
            String finalTimeForMat = KemCustomChartHelper.getTimeFormatByType(type);
            Map<String, Integer> countMap = datas.stream().map(it -> KemCustomChartHelper.convertToStr(finalTimeForMat, it.getDate("opdate"))).collect(Collectors.toList()).stream().collect(Collectors.toMap(key -> key, value -> 1, (value1, value2) -> value1 + value2));
            for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
                if (!dataMap.containsKey(entry.getKey())) continue;
                dataMap.put(entry.getKey(), (double)entry.getValue());
            }
        }
        Collection datasColl = dataMap.values();
        Double[] doubles = datasColl.toArray(new Double[datasColl.size()]);
        return doubles;
    }

    private static void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private static void setXYaxis(Map<String, Double> dataMap, int type, int days, LocalDate dateend) {
        String timeForMat = null;
        LinkedList<String> list = new LinkedList<String>();
        timeForMat = "MM.dd";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(timeForMat);
        for (int i = days; i >= 0; --i) {
            list.add(dateend.minusDays(i).format(formatter) + "");
        }
        for (String day : list) {
            dataMap.put(day, 0.0);
        }
    }

    private static String getTimeFormatByType(int type) {
        String timeForMat = null;
        timeForMat = "MM.dd";
        return timeForMat;
    }

    public static String convertToStr(String format, Date date) {
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(format);
        String dateStr = simpleDateFormat2.format(date);
        return dateStr;
    }

    public static LocalDate dateToLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDate();
    }

    public static Date localDateToDate(LocalDate date) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = date.atStartOfDay().atZone(zone).toInstant();
        return Date.from(instant);
    }
}

