/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.log;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.logbill.LogBillListPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ConfigurationUtil;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.core.subscribe.SubscriberManager;
import kd.isc.kem.core.subscribe.model.NodeOutput;

public class KemLogListPlugin
extends LogBillListPlugin {
    private static final Log LOG = LogFactory.getLog(KemLogListPlugin.class);
    public static final String ID = "Id";
    private static final String id = "id";
    private static final String KEY_SUBID = "subid";
    private static final String KEY_LOGID = "logid";
    private static final String KEY_NODETYPE = "nodetype";
    private static final String KEY_OUTPUT_TAG = "output_tag";
    private static final String KEY_ISDEFAULT = "isDefault";
    private static final String KEY_OPDATE = "opdate";
    private static final String BTN_LOG_DETAIL = "log_detail";
    private static final String BTN_SHOWLOG = "showlog";
    private static final String BTN_REEXCUTE = "reexcute";
    public static final String FORM_KEM_LOG_DETAIL = "kem_log_detail";
    private static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.getParameter().setCustomParam(KEY_ISDEFAULT, (Object)0);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (ConfigurationUtil.getString((String)"env.type").equals("prod")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"opdesc"});
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Object subid = this.getView().getFormShowParameter().getCustomParam(KEY_SUBID);
        if (null != subid) {
            for (FilterColumn col : args.getFastFilterColumns()) {
                if (!col.getFieldName().equals("subnumber")) continue;
                col.setDefaultValue(subid.toString());
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object subid = this.getView().getFormShowParameter().getCustomParam(KEY_SUBID);
        if (null != subid) {
            e.getQFilters().add(new QFilter("subnumber", "ftlike", subid));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals(BTN_LOG_DETAIL)) {
            if (this.getSelectedRows().size() > 0) {
                this.showLogDetail();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u6761\u6570\u636e\u3002", (String)"KemLogListPlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if (evt.getItemKey().equals(BTN_SHOWLOG)) {
            if (this.getSelectedRows().size() == 1) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("kem_log");
                ListView view = (ListView)this.getView();
                showParameter.setPkId(view.getCurrentSelectedRowInfo().getPrimaryKeyValue());
                showParameter.setCustomParam(KEY_ISDEFAULT, (Object)0);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setBillStatus(BillOperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u6761\u6570\u636e\u3002", (String)"KemLogListPlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if (evt.getItemKey().equals(BTN_REEXCUTE)) {
            if (this.getSelectedRows().size() > 0) {
                this.retrySub();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u6761\u6570\u636e\u3002", (String)"KemLogListPlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (showParameter.getBillFormId() != null && showParameter.getBillFormId().equals("kem_log_open")) {
            return;
        }
        if (args.getFieldName().equals(KEY_OPDATE) || args.getFieldName().equals(id)) {
            args.setCancel(true);
            this.showLogDetail();
        }
    }

    private void showLogDetail() {
        ListView view = (ListView)this.getView();
        KemLogListPlugin.showLogDetail(this.getView(), view.getCurrentSelectedRowInfo().getPrimaryKeyValue());
    }

    public static void showLogDetail(IFormView view, Object id) {
        if (id == null) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ID, id);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORM_KEM_LOG_DETAIL);
        showParameter.setCustomParams(params);
        showParameter.setPageId(view.getPageId() + id);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(showParameter);
    }

    private void retrySub() {
        ListSelectedRowCollection coll = this.getSelectedRows();
        DynamicObjectCollection logs = LogORM.create().query("kem_log", "id,subid,status", new QFilter(id, "in", (Object)coll.getPrimaryKeyValues()).toArray(), coll.size(), 0);
        for (DynamicObject log : logs) {
            if (log.getString("status").equals("0")) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\u5931\u8d25\u7684\u6570\u636e\u624d\u53ef\u4ee5\u91cd\u8bd5\u3002", (String)"KemLogListPlugin_3", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Map<Object, Object> subMap = logs.stream().collect(Collectors.toMap(a -> a.get(id), i -> i.get(KEY_SUBID)));
        DynamicObjectCollection nodelogs = LogORM.create().query("kem_nodelog", "logid,output_tag", new QFilter(KEY_LOGID, "in", (Object)coll.getPrimaryKeyValues()).and(new QFilter(KEY_NODETYPE, "=", (Object)"1")).toArray(), coll.size(), 0);
        HashMap<String, String> map1 = new HashMap<String, String>();
        for (DynamicObject nodelog : nodelogs) {
            Object logid = nodelog.get(KEY_LOGID);
            map1.put(logid + "_" + subMap.get(logid), nodelog.getString(KEY_OUTPUT_TAG));
        }
        int successcnt = 0;
        int failcnt = 0;
        for (Map.Entry entry : map1.entrySet()) {
            Object value = entry.getValue();
            String temp1 = ((String)entry.getKey()).split("_")[1];
            long subid = Long.parseLong(temp1);
            NodeOutput sourceNodeOutput = (NodeOutput)JacksonUtil.readValue((String)value.toString(), NodeOutput.class);
            try {
                SubscriberManager.retrySub((long)subid, (NodeOutput)sourceNodeOutput);
                ++successcnt;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                ++failcnt;
            }
        }
        if (failcnt == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"KemLogDetailFormPlugin_6", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5931\u8d25\u3002\u6210\u529f%1s\u6761\uff0c\u5931\u8d25%2s\u6761\u3002", (String)"KemLogListPlugin_2", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), successcnt, failcnt));
        }
        this.getView().invokeOperation("refresh");
    }
}

