/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.open.event;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.kem.form.plugin.event.AbstractKemEventBasePlugin;
import kd.isc.kem.form.util.FormOpener;

public class KemOpenEventBasePlugin
extends AbstractKemEventBasePlugin {
    public static final String GET_PROP_FROM_OBJ = "getPropFromObj";
    public static final String ENTITY_ID = "entityId";
    private static final String IS_BATCH = "$isBatch";
    private static final String PARAM_TYPE = "$type";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object addType = this.getView().getFormShowParameter().getCustomParam("addType");
        if (addType != null && addType.equals("cus")) {
            this.getModel().setValue("eventtype", (Object)"1");
            if (this.getModel().getDataEntity().getDynamicObject("group") == null) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"bizapp"});
            } else {
                DynamicObject app = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (QFilter[])new QFilter("number", "=", (Object)this.getModel().getDataEntity().getDynamicObject("group").getString("number")).toArray());
                if (null != app) {
                    this.getModel().setValue("bizapp", (Object)app);
                }
            }
        }
    }

    public void afterLoadData(EventObject e) {
        DynamicObject app;
        super.afterLoadData(e);
        DynamicObject group = this.getModel().getDataEntity().getDynamicObject("group");
        if (group != null && this.getModel().getDataEntity().get("bizapp") == null && (app = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter("number", "=", (Object)group.getString("number")).toArray())) != null) {
            this.getModel().setValue("bizapp", app.get("id"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bizapp"});
        }
        this.checkDataParamRep();
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.checkDataParamRep();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("bizobjectid")) {
            if (null == this.getModel().getValue("bizobjectid")) {
                this.getModel().deleteEntryData("data_entry");
                this.getModel().setValue("bizobjectnumber", null);
                this.getModel().setValue("bizobjectname", null);
            }
            this.getModel().setValue("operation", null);
            this.getModel().deleteEntryData("data_entry");
            this.buildMulComb();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private void buildMulComb() {
        if (null != this.getModel().getValue("bizobjectid")) {
            DynamicObject bizObject = (DynamicObject)this.getModel().getValue("bizobjectid");
            List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)bizObject.getString("number"));
            Predicate<Map> predicate = operationMeta -> {
                String operationType = (String)operationMeta.get("type");
                boolean isEntityOperation = OperationTypeCache.isEntityOperation((String)operationType);
                return isEntityOperation;
            };
            Function<Map, ComboItem> mapper = operationMeta -> {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(LocaleString.fromMap((Map)((Map)operationMeta.get("name"))) + "(" + operationMeta.get("key") + ")"));
                comboItem.setValue((String)operationMeta.get("key"));
                return comboItem;
            };
            ArrayList tempList = new ArrayList(10);
            List opList = dataEntityOperate.stream().filter(predicate).map(mapper).collect(Collectors.toList());
            tempList.addAll(opList);
            MulComboEdit edit = (MulComboEdit)this.getControl("operation");
            edit.setComboItems(tempList);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.buildMulComb();
        if (this.getModel().getValue("eventtype").equals("1")) {
            BasedataEdit edit = (BasedataEdit)this.getControl("bizapp");
            edit.setMustInput(true);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            if ((((Donothing)args.getSource()).getOperateKey().equals("api_addformobj") || ((Donothing)args.getSource()).getOperateKey().equals("add_ref")) && null == this.getModel().getValue("bizobjectid")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"KemOpenEventBasePlugin_0", (String)"isc-kem-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (args.getSource() instanceof Save) {
            String operation;
            if (!this.getModel().getValue("eventtype").equals("1") && (operation = this.getModel().getValue("operation").toString()).length() > 200) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u64cd\u4f5c\u201d\u4ec5\u652f\u6301200\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"KemOpenEventBasePlugin_2", (String)"isc-kem-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.updataGroup(args);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (!opKey.equals("save")) {
            if (opKey.equals("api_addformobj")) {
                DynamicObject entity = (DynamicObject)this.getModel().getValue("bizobjectid");
                String entityNumber = entity.getString("number");
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("kem_eventconfigs");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCustomParam("entitynumber", (Object)entityNumber);
                formShowParameter.setCustomParam("configfields", this.getConfigFields());
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eventConfigCallback"));
                DynamicObject bizObj = (DynamicObject)this.getModel().getValue("bizobjectid");
                ArrayList data = new ArrayList();
                HashMap<String, Object> aMap = new HashMap<String, Object>();
                aMap.put("_Type_", bizObj.getString("modeltype").contains("bill") ? "RefbillField" : "BasedataField");
                aMap.put("Id", bizObj.get("id"));
                aMap.put("Name", bizObj.getString("name"));
                aMap.put("BaseEntityId", bizObj.getString("dentityid"));
                data.add(aMap);
                formShowParameter.setCustomParam("context", data);
                this.getView().showForm(formShowParameter);
            } else if (opKey.equals("add_ref")) {
                DynamicObject bizObj = (DynamicObject)this.getModel().getValue("bizobjectid");
                ArrayList data = new ArrayList();
                HashMap<String, Object> aMap = new HashMap<String, Object>();
                aMap.put("_Type_", bizObj.getString("modeltype").contains("bill") ? "RefbillField" : "BasedataField");
                aMap.put("Id", bizObj.get("id"));
                aMap.put("Name", bizObj.getString("name"));
                aMap.put("BaseEntityId", bizObj.getString("dentityid"));
                HashMap<String, Object> cusMap = new HashMap<String, Object>();
                cusMap.put("context", data);
                data.add(aMap);
                FormOpener.showForm((AbstractFormPlugin)this, "kem_basepropertyref", null, cusMap, "add_ref");
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String callBackID = event.getActionId();
        if ("eventConfigCallback".equals(callBackID)) {
            this.getView().updateView("data_entry");
        } else if (callBackID.equals("add_ref")) {
            // empty if block
        }
    }

    private List<Map<String, Object>> getConfigFields() {
        ArrayList<Map<String, Object>> configFields = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection fields = this.getModel().getEntryEntity("data_entry");
        for (DynamicObject field : fields) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (!field.getBoolean("iscustom")) {
                map.put("configname", field.get("configname") == null ? null : field.get("configname").toString());
                map.put("confignumber", field.get("confignumber"));
                map.put("istransfer", field.get("istransfer"));
            }
            configFields.add(map);
        }
        return configFields;
    }

    private void updataGroup(BeforeDoOperationEventArgs args) {
        DynamicObject bizapp = null;
        if (this.getModel().getValue("eventtype").equals("1")) {
            bizapp = this.getModel().getDataEntity().getDynamicObject("bizapp");
        } else {
            DynamicObject bizObject = (DynamicObject)this.getModel().getValue("bizobjectid");
            bizapp = bizObject.getDynamicObject("bizappid");
        }
        OperationResult groupOperationResult = null;
        DynamicObject groupData = QueryServiceHelper.queryOne((String)"kem_eventgroup", (String)"id,number,longnumber", (QFilter[])new QFilter("number", "=", bizapp.get("number")).toArray());
        if (null == groupData || groupData.get("Id").equals(0L)) {
            long id;
            String longnumber;
            DynamicObject group;
            DynamicObject app = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"bizcloud.number,bizcloud.name", (QFilter[])new QFilter("Id", "=", bizapp.getPkValue()).toArray());
            String cloudNumber = app.getString("bizcloud.number");
            String cloudName = app.getString("bizcloud.name");
            DynamicObject cloud = QueryServiceHelper.queryOne((String)"kem_eventgroup", (String)"id,number", (QFilter[])new QFilter("number", "=", (Object)cloudNumber).toArray());
            Object cloudGroupId = null;
            DynamicObject source = (DynamicObject)this.getModel().getValue("datasourceid");
            if (cloud == null) {
                group = BusinessDataServiceHelper.newDynamicObject((String)"kem_eventgroup");
                group.set("number", (Object)cloudNumber);
                group.set("name", (Object)cloudName);
                group.set("datasourceid", (Object)source);
                longnumber = "KemOpenEvt." + cloudNumber;
                group.set("longnumber", (Object)longnumber);
                id = Math.abs(Hash.mur64((byte[])longnumber.getBytes()));
                group.set("id", (Object)id);
                DynamicObject groupid = QueryServiceHelper.queryOne((String)"kem_eventgroup", (String)"id,number", (QFilter[])new QFilter("number", "=", (Object)"KemOpenEvt").toArray());
                group.set("parent", groupid.get("id"));
                group.set("status", (Object)"C");
                group.set("enable", (Object)"1");
                group.set("isleaf", (Object)Boolean.FALSE);
                Object[] operationResult = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{group});
                cloudGroupId = operationResult[0];
            }
            if (cloudGroupId == null && null != cloud) {
                cloudGroupId = cloud.get("Id");
            }
            group = BusinessDataServiceHelper.newDynamicObject((String)"kem_eventgroup");
            group.set("number", bizapp.get("number"));
            group.set("name", bizapp.get("name"));
            longnumber = "KemOpenEvt." + cloudNumber + bizapp.get("number");
            group.set("longnumber", (Object)longnumber);
            id = Math.abs(Hash.mur64((byte[])longnumber.getBytes()));
            group.set("id", (Object)id);
            group.set("datasourceid", (Object)source);
            if (cloudGroupId instanceof Long) {
                cloudGroupId = BusinessDataServiceHelper.loadSingle((Object)cloudGroupId, (String)"kem_eventgroup");
            }
            group.set("parent", cloudGroupId);
            group.set("status", (Object)"C");
            group.set("enable", (Object)"1");
            group.set("isleaf", (Object)Boolean.FALSE);
            groupOperationResult = SaveServiceHelper.saveOperate((String)"kem_eventgroup", (DynamicObject[])new DynamicObject[]{group}, null);
            System.out.println(groupOperationResult.getSuccessPkIds());
        }
        Object id = null;
        if (null != groupOperationResult && groupOperationResult.isSuccess()) {
            id = groupOperationResult.getSuccessPkIds().get(0);
        } else if (null != groupData) {
            id = groupData.get("Id");
        }
        this.getModel().setValue("group", id);
    }

    private void checkDataParamRep() {
        DynamicObjectCollection data_entrys = this.getModel().getEntryEntity("data_entry");
        List datas = data_entrys.stream().filter(node -> node.getString("confignumber").isEmpty()).collect(Collectors.toList());
        if (datas.size() <= 0) {
            return;
        }
        KemOpenEventBasePlugin.generateFullNumbers(data_entrys);
        this.getModel().updateEntryCache(data_entrys);
        this.getView().updateView("data_entry");
    }

    private static void generateFullNumbers(DynamicObjectCollection data) {
        for (DynamicObject node : data) {
            KemOpenEventBasePlugin.generateFullNumber(node, data);
        }
    }

    private static void generateFullNumber(DynamicObject node, DynamicObjectCollection data) {
        if (node.getLong("pid") == 0L) {
            node.set("confignumber", (Object)node.getString("paraname"));
            if (node.getString("paraname").equals("id")) {
                node.set("confignumber", (Object)"PrimaryKey");
            }
        } else {
            DynamicObject parent = KemOpenEventBasePlugin.findParent(node.getLong("pid"), data);
            if (parent != null) {
                if (parent.getString("confignumber") == null) {
                    KemOpenEventBasePlugin.generateFullNumber(parent, data);
                }
                node.set("confignumber", (Object)(parent.getString("confignumber") + "." + node.getString("paraname")));
            }
        }
    }

    private static DynamicObject findParent(Long pid, DynamicObjectCollection data) {
        for (DynamicObject node : data) {
            if (node.getLong("id") != pid.longValue()) continue;
            return node;
        }
        return null;
    }
}

