/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.open.event;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.license.GrayFeatureUtil;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.kem.common.util.KemLicenseUtil;
import kd.isc.kem.common.util.ObjectUtil;
import kd.isc.kem.core.event.KemEventFactory;

public class KemOpenEventListPlugin
extends AbstractTreeListPlugin {
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_DEL = "btndel";
    private static final String BTN_DEDIT = "btnedit";
    private static final String TBL_CHANGEGROUP = "changegroup";
    private static final String ID = "Id";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_LEVEL = "level";
    private static final String KEY_NEW = "new";
    private static final String KEY_GROUP = "group";
    private static final String FORM_KEM_EVENTGROUP = "kem_eventgroup";
    private static final String FORM_KEM_EVENTGUIDE = "kem_eventguide";
    private static final String FORM_KEM_EVENT = "kem_event";
    private static final String TREE_PARENT_ID = "tree_parent_id";
    private static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";
    private static final String FEATURE_NUMBER = "KemOpenEvent";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_DEL, BTN_DEDIT});
        this.getTreeModel().getTreeFilter().add(new QFilter("datasourceid.number", "=", (Object)"KemOpenEvt"));
    }

    public void beforeShowBill(BeforeShowBillFormEvent arg0) {
        super.beforeShowBill(arg0);
        if (this.getPageCache().get("addType") != null && this.getPageCache().get("addType").equals("cus")) {
            arg0.getParameter().setCustomParam("addType", (Object)"cus");
            this.getPageCache().remove("addType");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.doExistsDataBase();
        if (KemLicenseUtil.isEnableOpenEventGrayLicense()) {
            try {
                GrayFeatureUtil.checkLicenseState((String)FEATURE_NUMBER);
            }
            catch (IscBizException e1) {
                this.getView().showTipNotification(e1.getLocalizedMessage());
                GrayFeatureUtil.showApplyFormWhenNoLicense((AbstractFormPlugin)this, (String)FEATURE_NUMBER, (String)ResManager.loadKDString((String)"\u5f00\u653e\u4e8b\u4ef6", (String)"KemOpenEventListPlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5f00\u653e\u4e8b\u4ef6\u7070\u5ea6\u7279\u6027\u7533\u8bf7", (String)"KemOpenEventListPlugin_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        String id = e.getNodeId().toString();
        if (id.equals("8609760E-EF83-4775-A9FF-CCDEC7C0B689")) {
            return;
        }
        if (id.equals("9")) {
            this.getTreeModel().getTreeListFilter().add(new QFilter("datasourceid.number", "=", (Object)"KemOpenEvt"));
        }
        this.getTreeListView().getTreeModel();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        TreeView treeView = this.getTreeListView().getTreeView();
        if (!showParameter.getFormId().equals("kem_event_doc") && null != showParameter.getCustomParam(KEY_NUMBER)) {
            TreeNode root = this.getTreeModel().getRoot();
            if (null == this.getPageCache().get(KEY_NEW)) {
                this.getPageCache().put(KEY_NEW, "1");
                if (null != root.getChildren() && root.getChildren().size() > 0) {
                    treeView.treeNodeClick(root.getId(), ((TreeNode)root.getChildren().get(0)).getId());
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (evt.getItemKey().equals("tbldisable")) {
            Object[] pks = this.getSelectedRows().getPrimaryKeyValues();
            if (pks.length == 1) {
                QFilter qFilter = new QFilter("eventid.id", "=", pks[0]);
                qFilter.and(new QFilter("status", "=", (Object)"B"));
                if (QueryServiceHelper.exists((String)"kem_subscribe", (QFilter[])qFilter.toArray())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e8b\u4ef6\u5df2\u88ab\u8ba2\u9605\u4e0d\u53ef\u7981\u7528\uff0c\u8bf7\u5148\u64a4\u9500\u5bf9\u5e94\u8ba2\u9605\u6570\u636e\u3002", (String)"KemEventBasePlugin_2", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            } else if (pks.length > 1) {
                QFilter qFilter = new QFilter("eventid.id", "in", (Object)pks);
                qFilter.and(new QFilter("status", "=", (Object)"B"));
                DynamicObjectCollection subs = QueryServiceHelper.query((String)"kem_subscribe", (String)"Id,eventid.number,eventid.id", (QFilter[])qFilter.toArray());
                if (null != subs && subs.size() > 0) {
                    Map<Long, List<DynamicObject>> map = subs.stream().collect(Collectors.groupingBy(it -> it.getLong("eventid.id")));
                    StringBuilder msg = new StringBuilder();
                    for (Map.Entry<Long, List<DynamicObject>> row : map.entrySet()) {
                        msg.append(row.getValue().get(0).getString("eventid.number"));
                        msg.append('\u3001');
                    }
                    String msgStr = String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u7f16\u7801:%s\u7684\u4e8b\u4ef6\u5df2\u7ecf\u5728\u8ba2\u9605\u4e2d\uff0c\u8bf7\u5148\u64a4\u9500\u8ba2\u9605\u6570\u636e\u4fee\u6539\u4e8b\u4ef6\u4fe1\u606f\u3002", (String)"KemEventListPlugin_6", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), msg.toString());
                    evt.setCancel(true);
                    this.getView().showMessage(msgStr);
                }
            }
        } else if (evt.getItemKey().equals("tblnew_cus")) {
            this.getPageCache().put("addType", "cus");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ((args.getOperateKey().equals("disable") || args.getOperateKey().equals("enable") || args.getOperateKey().equals("delete")) && args.getOperationResult().isSuccess()) {
            KemEventFactory.getEventService().clearCache();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Refresh) {
            TreeView treeView = this.getTreeListView().getTreeView();
            treeView.treeNodeClick(null, "8609760E-EF83-4775-A9FF-CCDEC7C0B689");
        }
    }

    private void doExistsDataBase() {
        if (!QueryServiceHelper.exists((String)"isc_database_link", (QFilter[])new QFilter("id", "=", (Object)896143281933550592L).toArray())) {
            boolean isExists;
            DynamicObject link = QueryServiceHelper.queryOne((String)"isc_database_link", (String)"id", (QFilter[])new QFilter("database_type", "=", (Object)"self").toArray());
            DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)1838491180434783232L, (String)"isc_data_source");
            if (!ObjectUtil.isEmpty((Object)dataSource.get("dblink")) && (isExists = QueryServiceHelper.exists((String)"isc_database_link", (QFilter[])new QFilter("id", "=", (Object)dataSource.getDynamicObject("dblink").getLong("id")).toArray()))) {
                return;
            }
            if (null != link && 0L != link.getLong("id")) {
                dataSource.set("dblink", link.get("id"));
            } else {
                DynamicObject linkNew = BusinessDataServiceHelper.newDynamicObject((String)"isc_database_link");
                linkNew.set("id", (Object)896143281933550592L);
                linkNew.set(KEY_NUMBER, (Object)"PREINS_SELF");
                linkNew.set("name", (Object)new LocaleString(ResManager.loadKDString((String)"\u9884\u7f6e\u5f53\u524d\u8d26\u5957\u8fde\u63a5", (String)"KemOpenEventListPlugin_2", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0])));
                linkNew.set("database_type", (Object)"self");
                linkNew.set("isv", (Object)ResManager.loadKDString((String)"kingdee.\u96c6\u6210\u670d\u52a1\u4e91", (String)"KemOpenEventListPlugin_3", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                linkNew.set("creator", (Object)0L);
                linkNew.set("status", (Object)Character.valueOf('C'));
                linkNew.set("enable", (Object)Character.valueOf('1'));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{linkNew});
                dataSource.set("dblink", (Object)896143281933550592L);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataSource});
        }
    }
}

