/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.open.log;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.core.subscribe.SubscriberManager;
import kd.isc.kem.core.subscribe.model.NodeOutput;
import kd.isc.kem.form.util.KemParamsBuildUtil;

public class KemOpenLogDetailPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(KemOpenLogDetailPlugin.class);
    private static final String ID = "Id";
    private static final String KEY_LOGID = "logid";
    private static final String KEY_MESSAGE_TAG = "message_tag";
    private static final String KEY_INPUT_TAG = "input_tag";
    private static final String KEY_OUTPUT_TAG = "output_tag";
    private static final String KEY_NODETYPE = "nodetype";
    private static final String KEY_EVENTNAME = "eventname";
    private static final String KEY_EVENTNUMBER = "eventnumber";
    private static final String KEY_SUBNUMBER = "subnumber";
    private static final String KEY_SUBNAME = "subname";
    private static final String KEY_SUBVERSION = "sub_version";
    private static final String KEY_EVENTID = "eventid";
    private static final String KEY_OPDATE = "opdate";
    private static final String KEY_RETRYSEQ = "retryseq";
    private static final String KEY_RETRYTYPE = "retrytype";
    private static final String KEY_COST = "cost";
    private static final String KEY_WEBHOOKNAME = "webhookname";
    private static final String KEY_WEBHOOKURL = "webhookurl";
    private static final String KEY_STATUS = "status";
    private static final String KEY_MSGID = "msgid";
    private static final String KEY_SUBID = "subid";
    private static final String FORM_KEM_SUBSCRIBE = "kem_subscribe";
    private static final String KEY_EVT_OUTPUT_TAG = "evt_output_tag";
    private static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";
    private static final String KEY_NODEID = "nodeid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (evt.getItemKey().equals("reexecute") && !this.getModel().getValue(KEY_STATUS).equals("0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\u5931\u8d25\u624d\u53ef\u4ee5\u91cd\u8bd5\u3002", (String)"KemOpenLogDetailPlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals("reexecute")) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u6b63\u5728\u91cd\u65b0\u63a8\u9001\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u64cd\u4f5c\u65e0\u8bef\u3002", (String)"KemOpenLogDetailPlugin_2", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("reexecute"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("reexecute") && evt.getResultValue().equals("Yes")) {
            this.reExecute();
        }
    }

    private void reExecute() {
        Long subId = Long.valueOf(this.getPageCache().get(KEY_SUBID));
        DynamicObject sub = QueryServiceHelper.queryOne((String)FORM_KEM_SUBSCRIBE, (String)"id,target_entry.id", (QFilter[])new QFilter("id", "=", (Object)subId).and(new QFilter(KEY_STATUS, "=", (Object)"B")).toArray());
        if (null != sub) {
            long targetId = sub.getLong("target_entry.id");
            Long subInstanceId = (Long)this.getView().getFormShowParameter().getCustomParam(ID);
            NodeOutput sourceNodeOutput = (NodeOutput)JacksonUtil.readValue((String)this.getModel().getValue(KEY_EVT_OUTPUT_TAG).toString(), NodeOutput.class);
            try {
                SubscriberManager.retryTarget((long)subInstanceId, (long)subId, (NodeOutput)sourceNodeOutput, (long)targetId, (int)0);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"KemLogDetailFormPlugin_6", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                this.buildData();
            }
            catch (Exception e) {
                LOGGER.warn((Throwable)e);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002", (String)"KemLogDetailFormPlugin_7", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u8be5\u8ba2\u9605\u53ef\u80fd\u672a\u542f\u7528\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"KemLogDetailFormPlugin_8", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void buildData() {
        DynamicObject log = this.getLogDataById();
        if (log != null) {
            IDataModel model = this.getModel();
            model.setValue(KEY_MSGID, log.get(KEY_MSGID));
            model.setValue(KEY_STATUS, log.get(KEY_STATUS));
            model.setValue(KEY_EVENTNUMBER, log.get(KEY_EVENTNUMBER));
            model.setValue(KEY_EVENTNAME, log.get(KEY_EVENTNAME));
            model.setValue(KEY_SUBNUMBER, log.get(KEY_SUBNUMBER));
            model.setValue(KEY_SUBNAME, log.get(KEY_SUBNAME));
            model.setValue(KEY_SUBVERSION, log.get(KEY_SUBVERSION));
            DynamicObject subOpen = QueryServiceHelper.queryOne((String)"kem_sub_open", (String)"id,webhookname,webhookurl", (QFilter[])new QFilter("openeventsubdetl.subid.id", "=", log.get(KEY_SUBID)).toArray());
            if (null != subOpen) {
                model.setValue(KEY_WEBHOOKNAME, subOpen.get(KEY_WEBHOOKNAME));
                model.setValue(KEY_WEBHOOKURL, subOpen.get(KEY_WEBHOOKURL));
            }
            this.getPageCache().put(KEY_SUBID, log.get(KEY_SUBID).toString());
            DynamicObjectCollection nodeLogs = this.getNodeLogsByLogId(log.getLong("id"), null);
            ArrayList<DynamicObject> targetLogs = new ArrayList<DynamicObject>();
            if (null != nodeLogs && nodeLogs.size() > 0) {
                for (DynamicObject nodeLog : nodeLogs) {
                    String nodeType = nodeLog.getString(KEY_NODETYPE).trim();
                    if (nodeType.equals("4")) {
                        targetLogs.add(nodeLog);
                        continue;
                    }
                    if (!nodeType.equals("1")) continue;
                    model.setValue(KEY_EVT_OUTPUT_TAG, nodeLog.get(KEY_OUTPUT_TAG));
                }
                if (targetLogs.size() > 0) {
                    this.targetDataBuilder(targetLogs);
                }
            }
        }
    }

    private DynamicObject getLogDataById() {
        if (null != this.getView().getFormShowParameter().getCustomParam(ID)) {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"kem_log");
            HashSet fields = new HashSet(type.getAllFields().keySet());
            fields.add(type.getPrimaryKey().getName());
            QFilter filter = new QFilter("id", "=", this.getView().getFormShowParameter().getCustomParam(ID));
            DynamicObjectCollection objects = LogORM.create().query("kem_log", String.join((CharSequence)",", fields), new QFilter[]{filter}, 1, 0);
            if (objects.size() > 0) {
                return (DynamicObject)objects.get(0);
            }
            return null;
        }
        return null;
    }

    private DynamicObjectCollection getNodeLogsByLogId(Long logId, Long nodeId) {
        if (null != logId) {
            QFilter qFilter = new QFilter(KEY_LOGID, "=", (Object)logId);
            if (null != nodeId) {
                qFilter.and(new QFilter(KEY_NODEID, "=", (Object)nodeId));
            }
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"kem_nodelog");
            HashSet fields = new HashSet(type.getAllFields().keySet());
            fields.add(type.getPrimaryKey().getName());
            fields.add(KEY_MESSAGE_TAG);
            fields.add(KEY_INPUT_TAG);
            fields.add(KEY_OUTPUT_TAG);
            DynamicObjectCollection logs = LogORM.create().query("kem_nodelog", String.join((CharSequence)",", fields), qFilter.toArray(), 20, 0);
            if (logs.size() > 0) {
                return logs;
            }
            return null;
        }
        return null;
    }

    private void targetDataBuilder(List<DynamicObject> targetLogs) {
        String text;
        CodeEdit codeEdit;
        List sortsLogs = targetLogs.stream().sorted(Comparator.comparing(a -> a.getDate(KEY_OPDATE), Comparator.reverseOrder())).collect(Collectors.toList());
        DynamicObject data = (DynamicObject)sortsLogs.get(0);
        if (!ObjectUtils.isEmpty((Object)data.getString(KEY_MESSAGE_TAG))) {
            codeEdit = (CodeEdit)this.getControl("codeeditap");
            codeEdit.setText(data.getString(KEY_MESSAGE_TAG));
        }
        if (!ObjectUtils.isEmpty((Object)data.getString(KEY_INPUT_TAG))) {
            codeEdit = (CodeEdit)this.getControl("codeinput");
            text = data.getString(KEY_INPUT_TAG);
            try {
                text = KemParamsBuildUtil.toInputJSONString(data.getString(KEY_INPUT_TAG));
            }
            catch (Exception exception) {
                // empty catch block
            }
            codeEdit.setText(text);
            this.getModel().setValue(KEY_INPUT_TAG, (Object)data.getString(KEY_INPUT_TAG));
        }
        if (!ObjectUtils.isEmpty((Object)data.getString(KEY_OUTPUT_TAG))) {
            codeEdit = (CodeEdit)this.getControl("codeoutput");
            text = data.getString(KEY_OUTPUT_TAG);
            try {
                text = KemParamsBuildUtil.toJSONString(data.getString(KEY_OUTPUT_TAG));
            }
            catch (Exception exception) {
                // empty catch block
            }
            codeEdit.setText(text);
        }
        this.getModel().setValue(KEY_OPDATE, data.get(KEY_OPDATE));
        this.getModel().setValue(KEY_RETRYSEQ, (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u6b21", (String)"KemOpenLogDetailPlugin_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), data.getString(KEY_RETRYSEQ)));
        this.getModel().setValue(KEY_RETRYTYPE, data.get(KEY_RETRYTYPE));
        this.getModel().setValue(KEY_COST, data.get(KEY_COST));
    }
}

