/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.open.log;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.license.GrayFeatureUtil;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.common.util.KemLicenseUtil;
import kd.isc.kem.core.subscribe.SubscriberManager;
import kd.isc.kem.core.subscribe.model.NodeOutput;

public class KemOpenLogListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(KemOpenLogListPlugin.class);
    private static final String ID = "Id";
    private static final String KEY_OPDATE = "opdate";
    private static final String KEY_STATUS = "status";
    private static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";
    private static final String id = "id";
    private static final String KEY_SUBID = "subid";
    private static final String KEY_NODETYPE = "nodetype";
    private static final String KEY_LOGID = "logid";
    private static final String FEATURE_NUMBER = "KemOpenEvent";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (KemLicenseUtil.isEnableOpenEventGrayLicense()) {
            try {
                GrayFeatureUtil.checkLicenseState((String)FEATURE_NUMBER);
            }
            catch (IscBizException e1) {
                this.getView().showTipNotification(e1.getLocalizedMessage());
                GrayFeatureUtil.showApplyFormWhenNoLicense((AbstractFormPlugin)this, (String)FEATURE_NUMBER, (String)ResManager.loadKDString((String)"\u5f00\u653e\u4e8b\u4ef6", (String)"KemOpenEventListPlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5f00\u653e\u4e8b\u4ef6\u7070\u5ea6\u7279\u6027\u7533\u8bf7", (String)"KemOpenEventListPlugin_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        this.showLogDetail();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("reexcute_target") && args.getOperationResult().isSuccess()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u6b63\u5728\u91cd\u65b0\u63a8\u9001\u6240\u9009\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u64cd\u4f5c\u65e0\u8bef\u3002", (String)"KemOpenLogListPlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("reexcute_target"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("reexcute_target") && evt.getResultValue().equals("Yes")) {
            this.retryTargets();
        }
    }

    private void showLogDetail() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ListView view = (ListView)this.getView();
        params.put(ID, view.getCurrentSelectedRowInfo().getPrimaryKeyValue());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("kem_log_open_detail");
        showParameter.setCustomParams(params);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private void retryTargets() {
        ListSelectedRowCollection coll = this.getSelectedRows();
        DynamicObjectCollection logs = LogORM.create().query("kem_log", "id,subid,status", new QFilter(id, "in", (Object)coll.getPrimaryKeyValues()).toArray(), coll.size(), 0);
        for (DynamicObject log : logs) {
            if (log.get(KEY_STATUS).equals("0")) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\u5931\u8d25\u624d\u53ef\u4ee5\u91cd\u8bd5\u3002", (String)"KemOpenLogDetailPlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        int successcnt = 0;
        int failcnt = 0;
        for (DynamicObject log : logs) {
            DynamicObjectCollection nodelogs = LogORM.create().query("kem_nodelog", "logid,input_tag,nodetype,output_tag", new QFilter(KEY_LOGID, "=", log.get(id)).toArray(), 2000, 0);
            String paramData = "";
            for (DynamicObject nodelog : nodelogs) {
                if (!nodelog.getString(KEY_NODETYPE).equals("1")) continue;
                paramData = nodelog.getString("output_tag");
            }
            DynamicObjectCollection subs = QueryServiceHelper.query((String)"kem_subscribe", (String)"id,target_entry.id", (QFilter[])new QFilter(id, "=", log.get(KEY_SUBID)).and(new QFilter(KEY_STATUS, "=", (Object)"B")).toArray());
            if (null != subs && subs.size() > 0) {
                for (DynamicObject sub : subs) {
                    long targetId = sub.getLong("target_entry.id");
                    Long subId = sub.getLong(id);
                    Long subInstanceId = log.getLong(id);
                    NodeOutput sourceNodeOutput = (NodeOutput)JacksonUtil.readValue((String)paramData, NodeOutput.class);
                    try {
                        SubscriberManager.retryTarget((long)subInstanceId, (long)subId, (NodeOutput)sourceNodeOutput, (long)targetId, (int)0);
                        ++successcnt;
                    }
                    catch (Exception e) {
                        LOGGER.warn((Throwable)e);
                        ++failcnt;
                    }
                }
                continue;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u8be5\u8ba2\u9605\u53ef\u80fd\u672a\u542f\u7528\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"KemLogDetailFormPlugin_8", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (failcnt == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"KemLogDetailFormPlugin_6", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5931\u8d25\u3002\u6210\u529f%1s\u6761\uff0c\u5931\u8d25%2s\u6761\u3002", (String)"KemLogListPlugin_2", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), successcnt, failcnt));
        }
        this.getView().invokeOperation("refresh");
    }
}

