/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.open.sub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.isc.iscb.platform.core.license.GrayFeatureUtil;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.kem.common.util.KemLicenseUtil;

public class KemOpenSubListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(KemOpenSubListPlugin.class);
    private static final String ID = "Id";
    private static final String KEY_NUMBER = "number";
    private static final String FORM_KEM_SUBSCRIBE = "kem_subscribe";
    private static final String FORM_KEM_SUB_OPEN = "kem_sub_open";
    private static final String FEATURE_NUMBER = "KemOpenEvent";
    private static final String KEY_STATUS = "status";
    public static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (KemLicenseUtil.isEnableOpenEventGrayLicense()) {
            try {
                GrayFeatureUtil.checkLicenseState((String)FEATURE_NUMBER);
            }
            catch (IscBizException e1) {
                this.getView().showTipNotification(e1.getLocalizedMessage());
                GrayFeatureUtil.showApplyFormWhenNoLicense((AbstractFormPlugin)this, (String)FEATURE_NUMBER, (String)ResManager.loadKDString((String)"\u5f00\u653e\u4e8b\u4ef6", (String)"KemOpenEventListPlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5f00\u653e\u4e8b\u4ef6\u7070\u5ea6\u7279\u6027\u7533\u8bf7", (String)"KemOpenEventListPlugin_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Object subid = this.getView().getFormShowParameter().getCustomParam("sub_openid");
        if (null != subid) {
            for (FilterColumn col : args.getFastFilterColumns()) {
                if (!col.getFieldName().equals("founderid")) continue;
                col.setDefaultValue(subid.toString());
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object subid = this.getView().getFormShowParameter().getCustomParam("sub_openid");
        if (null != subid) {
            e.getQFilters().add(new QFilter("founderid", "=", subid));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (evt.getItemKey().equals("tbldel")) {
            this.buildSubIdsForDelete();
        } else if (evt.getItemKey().equals("hisversion") || evt.getItemKey().equals("log")) {
            Object[] pks = this.getSelectedRows().getPrimaryKeyValues();
            if (pks.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"KemEventListPlugin_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            } else if (pks.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5355\u6761\u8bb0\u5f55\u3002", (String)"KemSubscribeListPlugin_1", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        Object[] pks = this.getSelectedRows().getPrimaryKeyValues();
        if (evt.getItemKey().equals("hisversion")) {
            if (pks.length == 1) {
                DynamicObject sub = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getSelectedRows().get(0).getPrimaryKeyValue(), (String)FORM_KEM_SUB_OPEN);
                if (sub.get("founderid") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5386\u53f2\u6570\u636e\u3002", (String)"KemSubscribeListPlugin_4", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("kem_sub_open_his");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setPageId(this.getView().getPageId() + pks[0]);
                showParameter.setCustomParam("sub_openid", sub.get("founderid"));
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if (evt.getItemKey().equals("log") && pks.length == 1) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("kem_log_open");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPageId(this.getView().getPageId() + pks[0]);
            showParameter.setCustomParam("subid", (Object)this.getSelectedRows().get(0).getNumber());
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (!key.equals("submit") || !args.getOperationResult().isSuccess()) {
            if (key.equals("unsubmit")) {
                if (args.getOperationResult().isSuccess()) {
                    // empty if block
                }
            } else if (key.equals("delete")) {
                if (args.getOperationResult().isSuccess()) {
                    List<Long> subIds1 = this.buildSubIdsForDelete();
                    if (subIds1 != null) {
                        DeleteServiceHelper.delete((String)FORM_KEM_SUBSCRIBE, (QFilter[])new QFilter(ID, "in", subIds1).toArray());
                        this.getPageCache().remove("subids");
                    }
                } else {
                    this.getPageCache().remove("subids");
                }
            }
        }
    }

    private List<Long> buildSubIdsForDelete() {
        if (null != this.getPageCache().get("subids") && !this.getPageCache().get("subids").equals("")) {
            String ids = this.getPageCache().get("subids");
            List<String> subIds = Arrays.asList(ids.split(","));
            ArrayList<Long> subids = new ArrayList<Long>(subIds.size());
            for (String subId : subIds) {
                subids.add(Long.valueOf(subId));
            }
            return subids;
        }
        ListSelectedRowCollection coll = this.getSelectedRows();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)FORM_KEM_SUB_OPEN, (String)"id,openeventsubdetl.subid.id", (QFilter[])new QFilter(ID, "in", (Object)coll.getPrimaryKeyValues()).toArray());
        ArrayList<String> subIds = new ArrayList<String>(collection.size());
        for (DynamicObject sub : collection) {
            String subid = sub.getString("openeventsubdetl.subid.id");
            if (subid.equals("0")) continue;
            subIds.add(subid);
        }
        this.getPageCache().put("subids", String.join((CharSequence)",", subIds));
        return null;
    }

    private List<Long> buildSubIds(AfterDoOperationEventArgs args) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)FORM_KEM_SUB_OPEN, (String)"id,openeventsubdetl.subid.id", (QFilter[])new QFilter(ID, "in", (Object)args.getOperationResult().getSuccessPkIds()).toArray());
        ArrayList<Long> subIds = new ArrayList<Long>();
        for (DynamicObject sub : collection) {
            Long subid = sub.getLong("openeventsubdetl.subid.id");
            if (subid == 0L) continue;
            subIds.add(subid);
        }
        return subIds;
    }
}

