/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.sub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ValueTextItem;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.isc.kem.common.constants.TargetParamFormat;
import kd.isc.kem.form.util.KemHeaderParam;
import kd.isc.kem.form.util.KemParamsBuildUtil;

public class KemSubParamsFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
F7SelectedListRemoveListener {
    private static final String KEY_PARAMTYPE = "paramtype";
    private static final String KEY_PARAMTYPE_LAB = "lab";
    private static final String KEY_TYPE = "type";
    private static final String KEY_DATA_ENTRY = "data_entry";
    private static final String KEY_CONTEXT_ENTRY = "context_entry";
    private static final String KEY_EVENTID = "eventid";
    private static final String KEY_F7SELECTEDLISTAP = "f7selectedlistap";
    private static final String KEY_PARANAME = "paraname";
    private static final String KEY_PARATYPE = "paratype";
    private static final String KEY_PARADESC = "paradesc";
    private static final String KEY_HD_PARANAME = "hd_paraname";
    private static final String KEY_HD_EXAMPLE = "hd_example";
    private static final String KEY_HD_PARAVALUE = "hd_paravalue";
    private static final String KEY_HD_PARATYPE = "hd_paratype";
    private static final String KEY_HD_PARADESC = "hd_paradesc";
    private static final String KEY_CODEEDIT_COM = "codeedit_com";
    private static final String KEY_CODEEDIT_SCRIPT = "codeedit_script";
    private static final String VALUETEXTITEMSMAP = "valueTextItemsMap";
    private static final String FORM_KEM_EVENT = "kem_event";
    private static final String BTN_OK = "btnok";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        EntryGrid dataEntry = (EntryGrid)this.getControl(KEY_DATA_ENTRY);
        EntryGrid contextEntry = (EntryGrid)this.getControl(KEY_CONTEXT_ENTRY);
        dataEntry.addRowClickListener((RowClickEventListener)this);
        contextEntry.addRowClickListener((RowClickEventListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(KEY_F7SELECTEDLISTAP);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object paramValue;
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object type = showParameter.getCustomParam(KEY_PARAMTYPE_LAB);
        if (type != null) {
            HashMap<String, Boolean> ismul;
            if ((Integer)type == 2) {
                this.getModel().setValue(KEY_PARAMTYPE, (Object)2);
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            } else if ((Integer)type == 1) {
                this.getModel().setValue(KEY_PARAMTYPE, (Object)1);
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap", "sub_rule"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"radiofield1", "target_api", "sf"});
            } else if ((Integer)type == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3", "sub_rule", "sf"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"target_api"});
                ismul = new HashMap<String, Boolean>();
                ismul.put("ismul", Boolean.FALSE);
                this.getView().updateControlMetadata(KEY_DATA_ENTRY, ismul);
                this.getView().updateControlMetadata(KEY_CONTEXT_ENTRY, ismul);
            } else if ((Integer)type == 4) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3", "sub_rule", "target_api"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"sf"});
                ismul = new HashMap();
                ismul.put("ismul", Boolean.FALSE);
                this.getView().updateControlMetadata(KEY_DATA_ENTRY, ismul);
                this.getView().updateControlMetadata(KEY_CONTEXT_ENTRY, ismul);
            }
            this.buildParamsData();
        }
        if (null != (paramValue = showParameter.getCustomParam("paravalue"))) {
            KemParamsBuildUtil.buildParamValue(String.valueOf(paramValue), this.getView());
        }
        if (showParameter.getCustomParam(KEY_TYPE).toString().equals("1")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap", BTN_OK});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(BTN_OK)) {
            Integer type = (Integer)this.getView().getFormShowParameter().getCustomParam(KEY_PARAMTYPE);
            if (this.getModel().getValue(KEY_PARAMTYPE).equals("2")) {
                ArrayList<Map<String, Object>> selectDatas = new ArrayList<Map<String, Object>>();
                this.returnToParentDataByKey(KEY_DATA_ENTRY, selectDatas);
                this.returnToParentDataByKey(KEY_CONTEXT_ENTRY, selectDatas);
                if (type == 0) {
                    if (selectDatas.size() > 0) {
                        this.getView().returnDataToParent((Object)TargetParamFormat.format((String)String.valueOf(((Map)selectDatas.get(0)).get(KEY_PARANAME)), (String)"2"));
                    }
                } else {
                    this.getView().returnDataToParent(selectDatas);
                }
            } else if (this.getModel().getValue(KEY_PARAMTYPE).equals("1")) {
                CodeEdit edit = (CodeEdit)this.getControl(KEY_CODEEDIT_COM);
                this.getView().returnDataToParent((Object)TargetParamFormat.format((String)edit.getText(), (String)"1"));
            } else {
                CodeEdit edit = (CodeEdit)this.getControl(KEY_CODEEDIT_SCRIPT);
                this.getView().returnDataToParent((Object)TargetParamFormat.format((String)edit.getText(), (String)"3"));
            }
            this.getView().close();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Object type = this.getView().getFormShowParameter().getCustomParam(KEY_PARAMTYPE);
        EntryGrid grid = (EntryGrid)evt.getSource();
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(grid.getEntryKey());
        int rowIndex = evt.getRow();
        String entryKey = grid.getEntryKey();
        boolean isDataEntry = entryKey.equals(KEY_DATA_ENTRY);
        int currIndex = this.getModel().getEntryCurrentRowIndex(entryKey);
        if ((Integer)type == 0) {
            if (isDataEntry) {
                EntryGrid conGrid = (EntryGrid)this.getControl(KEY_CONTEXT_ENTRY);
                conGrid.selectRows(-1);
            } else {
                EntryGrid dataGrid = (EntryGrid)this.getControl(KEY_DATA_ENTRY);
                dataGrid.selectRows(-1);
            }
            if (-1 != rowIndex) {
                this.buildF7SelectList(this.buildf7ParamMap(isDataEntry, entryDatas, currIndex, entryKey));
            }
            return;
        }
        if (grid.getSelectRows().length == entryDatas.size()) {
            for (int i = 0; i < entryDatas.size(); ++i) {
                Map<String, String> map = this.buildf7ParamMap(isDataEntry, entryDatas, i, entryKey);
                map.put("isAll", "1");
                this.buildF7SelectList(map);
            }
        } else if (rowIndex == -1 && grid.getSelectRows().length == 0) {
            for (int i = 0; i < entryDatas.size(); ++i) {
                Map<String, String> map = this.buildf7ParamMap(isDataEntry, entryDatas, i, entryKey);
                map.put("isRemove", "1");
                this.buildF7SelectList(map);
            }
        } else {
            for (int i = 0; i < grid.getSelectRows().length; ++i) {
                Map<String, String> map = this.buildf7ParamMap(isDataEntry, entryDatas, grid.getSelectRows()[i], entryKey);
                map.put("isAll", "1");
                this.buildF7SelectList(map);
            }
            List rows = Arrays.stream(grid.getSelectRows()).boxed().collect(Collectors.toList());
            ArrayList<Integer> removeRows = new ArrayList<Integer>();
            for (int i = 0; i < entryDatas.size(); ++i) {
                if (rows.contains(i)) continue;
                removeRows.add(i);
            }
            for (Integer removeRow : removeRows) {
                Map<String, String> map = this.buildf7ParamMap(isDataEntry, entryDatas, removeRow, entryKey);
                map.put("isRemove", "1");
                this.buildF7SelectList(map);
            }
        }
    }

    public void RemoveClick(F7SelectedListRemoveEvent evt) {
        if (null != evt.getParam()) {
            String param = evt.getParam().toString();
            this.f7ListRemoveSetting(param);
        } else {
            this.clearAllEntrySelect();
        }
    }

    private Map<String, String> buildf7ParamMap(boolean isDataEntry, DynamicObjectCollection entryDatas, int currIndex, String entryKey) {
        HashMap<String, String> param = new HashMap<String, String>();
        DynamicObject rowData = this.getModel().getEntryRowEntity(entryKey, currIndex);
        String value = this.getParamName(isDataEntry, entryDatas, currIndex);
        String f7Key = (isDataEntry ? rowData.getString("id") : rowData.getString(KEY_HD_PARANAME)) + "_" + entryKey;
        param.put("f7Key", f7Key);
        param.put("value", value);
        return param;
    }

    private void buildParamsData() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (null != showParameter.getCustomParam(KEY_EVENTID)) {
            Long id = (Long)this.getView().getFormShowParameter().getCustomParam(KEY_EVENTID);
            DynamicObject evnt = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)FORM_KEM_EVENT);
            this.getModel().deleteEntryData(KEY_DATA_ENTRY);
            this.getModel().deleteEntryData(KEY_CONTEXT_ENTRY);
            DynamicObjectCollection datas = evnt.getDynamicObjectCollection(KEY_DATA_ENTRY);
            DynamicObjectCollection paramDatas = this.getModel().getEntryEntity(KEY_DATA_ENTRY);
            if (!CollectionUtils.isEmpty((Collection)datas)) {
                for (DynamicObject data : datas) {
                    DynamicObject newRow = paramDatas.addNew();
                    newRow.set("id", data.get("id"));
                    newRow.set("pid", data.get("pid"));
                    newRow.set("paranumber", data.get("paranumber"));
                    newRow.set(KEY_PARANAME, data.get(KEY_PARANAME));
                    newRow.set(KEY_PARATYPE, data.get(KEY_PARATYPE));
                    newRow.set("ismultivalue", data.get("ismultivalue"));
                    newRow.set(KEY_PARADESC, data.get(KEY_PARADESC));
                    newRow.set("paralevel", data.get("paralevel"));
                    newRow.set("data_example", data.get("data_example"));
                }
            }
            for (KemHeaderParam param : KemHeaderParam.values()) {
                int index = this.getModel().createNewEntryRow(KEY_CONTEXT_ENTRY);
                this.getModel().setValue(KEY_HD_PARANAME, (Object)param.getName(), index);
                this.getModel().setValue(KEY_HD_PARAVALUE, (Object)param.getValue(), index);
                this.getModel().setValue(KEY_HD_EXAMPLE, (Object)param.getDefaultValue(), index);
                this.getModel().setValue(KEY_HD_PARADESC, (Object)param.getDesc(), index);
                this.getModel().setValue(KEY_HD_PARATYPE, (Object)param.getType(), index);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"radiofield1"});
        }
    }

    private void f7ListRemoveSetting(String param) {
        Map<String, String> valueTextItemsMap = this.getf7ListData();
        EntryGrid entry = null;
        boolean isData = param.contains(KEY_DATA_ENTRY);
        entry = isData ? (EntryGrid)this.getControl(KEY_DATA_ENTRY) : (EntryGrid)this.getControl(KEY_CONTEXT_ENTRY);
        List rows = Arrays.stream(entry.getSelectRows()).boxed().collect(Collectors.toList());
        DynamicObject[] rowData = entry.getEntryData().getDataEntitys();
        for (int i = 0; i < rowData.length; ++i) {
            String param1 = param.split("_" + (isData ? KEY_DATA_ENTRY : KEY_CONTEXT_ENTRY))[0];
            if (!(isData ? rowData[i].getString("id").equals(param1) : rowData[i].getString(KEY_HD_PARANAME).equals(param1))) continue;
            rows.remove((Object)i);
        }
        if (rows.size() == 0) {
            entry.selectRows(new int[0], 0);
        } else {
            entry.selectRows(rows.stream().mapToInt(Integer::valueOf).toArray(), ((Integer)rows.get(0)).intValue());
        }
        valueTextItemsMap.remove(param);
        this.setf7ListData(valueTextItemsMap);
    }

    private Map<String, String> getf7ListData() {
        IPageCache pageCache = this.getView().getPageCache();
        Map<String, String> valueTextItemsMap = null;
        if (null != pageCache.get(VALUETEXTITEMSMAP)) {
            String str = pageCache.get(VALUETEXTITEMSMAP);
            valueTextItemsMap = KemParamsBuildUtil.mapStringToMap(str);
        } else {
            valueTextItemsMap = new LinkedHashMap<String, String>();
        }
        return valueTextItemsMap;
    }

    private void setf7ListData(Map<String, String> valueTextItemsMap) {
        IPageCache pageCache = this.getView().getPageCache();
        if (valueTextItemsMap.size() == 0) {
            pageCache.remove(VALUETEXTITEMSMAP);
        } else {
            pageCache.put(VALUETEXTITEMSMAP, valueTextItemsMap.toString());
        }
    }

    private void buildF7SelectList(Map<String, String> param) {
        String f7Key;
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(KEY_F7SELECTEDLISTAP);
        Map<String, String> valueTextItemsMap = this.getf7ListData();
        if (valueTextItemsMap.containsKey(f7Key = param.get("f7Key")) && param.get("isAll") == null) {
            valueTextItemsMap.remove(f7Key);
        } else if (param.get("isRemove") == null) {
            valueTextItemsMap.put(f7Key, param.get("value"));
        }
        this.setf7ListData(valueTextItemsMap);
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(valueTextItemsMap.size());
        for (Map.Entry<String, String> entry : valueTextItemsMap.entrySet()) {
            ValueTextItem item = new ValueTextItem(entry.getKey(), entry.getValue());
            valueTextItems.add(item);
        }
        f7SelectedList.addItems(valueTextItems);
    }

    private void clearAllEntrySelect() {
        EntryGrid dataEntry = (EntryGrid)this.getControl(KEY_DATA_ENTRY);
        EntryGrid contextEntry = (EntryGrid)this.getControl(KEY_CONTEXT_ENTRY);
        dataEntry.selectRows(new int[0], 0);
        contextEntry.selectRows(new int[0], 0);
        this.getView().getPageCache().remove(VALUETEXTITEMSMAP);
    }

    private void returnToParentDataByKey(String entryKey, List<Map<String, Object>> selectDatas) {
        DynamicObjectCollection dataRows = this.getModel().getEntryEntity(entryKey);
        boolean isDataEntry = entryKey.equals(KEY_DATA_ENTRY);
        Map<String, String> valueTextItemsMap = this.getf7ListData();
        for (DynamicObject dataRow : dataRows) {
            StringBuilder key = new StringBuilder();
            key.append(isDataEntry ? dataRow.getString("id") : dataRow.get(KEY_HD_PARANAME));
            key.append('_');
            key.append(entryKey);
            String value = valueTextItemsMap.get(key.toString());
            if (null == value) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(KEY_PARANAME, value);
            data.put(KEY_PARATYPE, dataRow.getString(isDataEntry ? KEY_PARATYPE : KEY_HD_PARATYPE));
            if (isDataEntry) {
                Long id = (Long)this.getView().getFormShowParameter().getCustomParam(KEY_EVENTID);
                DynamicObject evnt = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)FORM_KEM_EVENT);
                DynamicObjectCollection datas = evnt.getDynamicObjectCollection(KEY_DATA_ENTRY);
                for (DynamicObject data1 : datas) {
                    if (!data1.getString(KEY_PARANAME).equals(dataRow.getString(KEY_PARANAME))) continue;
                    data.put(KEY_PARADESC, data1.get(KEY_PARADESC));
                }
            } else {
                data.put(KEY_PARADESC, dataRow.getString(KEY_HD_PARADESC));
            }
            selectDatas.add(data);
        }
    }

    private String getDataParamName(DynamicObject row) {
        DynamicObjectCollection dataRows = this.getModel().getEntryEntity(KEY_DATA_ENTRY);
        if (null == row.get("pid")) {
            return row.getString(KEY_PARANAME);
        }
        String pm = row.getString(KEY_PARANAME);
        pm = this.splitParamName(pm, row, dataRows);
        return pm;
    }

    private String splitParamName(String pm, DynamicObject dataRow, DynamicObjectCollection dataRows) {
        for (DynamicObject newRow : dataRows) {
            if (!newRow.getPkValue().equals(dataRow.get("pid"))) continue;
            pm = newRow.getString(KEY_PARANAME) + "." + pm;
            pm = this.splitParamName(pm, newRow, dataRows);
            break;
        }
        return pm;
    }

    private String getParamName(boolean isDataEntry, DynamicObjectCollection entryDatas, int rowIndex) {
        String paramKey = isDataEntry ? KEY_PARANAME : KEY_HD_PARAVALUE;
        return isDataEntry ? "$data." + this.getDataParamName((DynamicObject)entryDatas.get(rowIndex)) : this.getModel().getValue(paramKey, rowIndex).toString();
    }
}

