/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.form.plugin.sub;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.isc.kem.common.util.ObjectUtil;
import kd.isc.kem.form.util.KemParamsBuildUtil;

public class KemSubTargetTablePlugin
extends AbstractFormPlugin {
    private static final String ISC_KEM_FORMPLUGIN = "isc-kem-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter1 = this.getView().getFormShowParameter();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParams(showParameter1.getCustomParams());
        showParameter.setFormId((String)showParameter1.getCustomParam("formid"));
        String pageId = showParameter1.getPageId() + showParameter1.getCustomParam("formid");
        showParameter.setPageId(pageId);
        this.getPageCache().put("pageId", pageId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("target_flex");
        String formid = (String)showParameter1.getCustomParam("formid");
        if (formid.equals("kem_target_script_model")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"operatepanel"});
            showParameter.setCustomParam("operatepanel1", (Object)"operatepanel1");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "kem_target_script_model"));
        }
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("btnok")) {
            JSONObject data = new JSONObject();
            data.put("typeId", this.getView().getFormShowParameter().getCustomParam("typeId"));
            this.buildTargetData(data);
            data.getJSONObject("actionconfig_tag").put("targetType", this.getView().getFormShowParameter().getCustomParam("typeNumber"));
            this.getView().returnDataToParent((Object)data);
            this.getView().close();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("btnok")) {
            this.scriptRowData();
            this.msgUserCheck(evt);
            OperationResult result = this.getView().getView(this.getPageCache().get("pageId")).invokeOperation("check");
            if (result != null && !result.isSuccess()) {
                if (null != result && !result.isSuccess()) {
                    this.getView().showOperationResult(result);
                }
                evt.setCancel(true);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() != null) {
            if (evt.getActionId().equals("kem_target_script_model")) {
                Map map = (Map)evt.getReturnData();
                JSONObject data1 = new JSONObject();
                JSONObject data = new JSONObject();
                data1.put("typeId", this.getView().getFormShowParameter().getCustomParam("typeId"));
                data.put("remark", map.get("remark"));
                data.put("script", map.get("script_tag"));
                data.put("targetType", this.getView().getFormShowParameter().getCustomParam("typeNumber"));
                data1.put("actionconfig_tag", (Object)data);
                this.getView().returnDataToParent((Object)data1);
                this.getView().close();
            }
        } else {
            this.getView().close();
        }
    }

    private void scriptRowData() {
        IFormView view;
        CodeEdit edit;
        String text;
        FormShowParameter showParameter1 = this.getView().getFormShowParameter();
        String formid = (String)showParameter1.getCustomParam("formid");
        if (formid.contains("script") && this.getView().getView(this.getPageCache().get("pageId")) != null && null != (text = (edit = (CodeEdit)(view = this.getView().getView(this.getPageCache().get("pageId"))).getControl("codeeditap")).getText())) {
            view.getModel().setValue("script_tag", (Object)edit.getText());
            view.getModel().setValue("script", (Object)edit.getText());
        }
    }

    private void msgUserCheck(BeforeClickEvent evt) {
        FormShowParameter showParameter1 = this.getView().getFormShowParameter();
        String formid = (String)showParameter1.getCustomParam("formid");
        if (formid.contains("msg") && this.getView().getView(this.getPageCache().get("pageId")) != null) {
            IFormView view = this.getView().getView(this.getPageCache().get("pageId"));
            DynamicObject data = view.getModel().getDataEntity();
            if (data.getString("msg_user_type").equals("0") && data.getDynamicObjectCollection("msg_user").isEmpty() && ObjectUtil.isEmpty((Object)view.getModel().getValue("param_user"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u4e2a\u6d88\u606f\u63a5\u6536\u4eba\u3002", (String)"KemSubTargetTablePlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (data.getString("msg_user_type").equals("1") && ObjectUtil.isEmpty((Object)view.getModel().getValue("param_user_ext")) && ObjectUtil.isEmpty((Object)view.getModel().getValue("msg_user_ext"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u4e2a\u6d88\u606f\u63a5\u6536\u4eba\u3002", (String)"KemSubTargetTablePlugin_0", (String)ISC_KEM_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private void buildTargetData(JSONObject data) {
        FormShowParameter showParameter1 = this.getView().getFormShowParameter();
        String formid = (String)showParameter1.getCustomParam("formid");
        IDataModel model = this.getView().getView(this.getPageCache().get("pageId")).getModel();
        if (formid.contains("kem_target_api_model")) {
            KemParamsBuildUtil.buildApiTargetData(data, model);
        } else if (formid.contains("kem_target_sf_model")) {
            KemParamsBuildUtil.buildiscSfTargetData(data, model);
        } else if (formid.contains("msg")) {
            KemParamsBuildUtil.buildMsgTargetData(data, model);
        } else if (formid.contains("script")) {
            KemParamsBuildUtil.buildScriptTargetData(data, model);
        } else if (formid.contains("webhook")) {
            // empty if block
        }
    }
}

